/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.adapter;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.papyrus.infra.core.editor.reload.IReloadContextProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;

class DiagramOutlineReloadContextProvider
implements IReloadContextProvider {
    private static final int ID_OUTLINE = 0;
    private static final int ID_OVERVIEW = 1;
    private static final Class<?> diagramOutlinePage;
    private static final Method showPage;
    private static final Field showOutlineAction;
    private final Object diagramOutline;

    static {
        Class<?> diagramOutlinePageClass = null;
        Method showPageMethod = null;
        Field showOutlineActionField = null;
        Class<?>[] classArray = DiagramEditor.class.getDeclaredClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> next = classArray[n2];
            if ("DiagramOutlinePage".equals(next.getSimpleName())) {
                diagramOutlinePageClass = next;
                try {
                    showPageMethod = diagramOutlinePageClass.getDeclaredMethod("showPage", Integer.TYPE);
                    showPageMethod.setAccessible(true);
                    showOutlineActionField = diagramOutlinePageClass.getDeclaredField("showOutlineAction");
                    showOutlineActionField.setAccessible(true);
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                    diagramOutlinePageClass = null;
                }
                break;
            }
            ++n2;
        }
        diagramOutlinePage = diagramOutlinePageClass;
        showPage = showPageMethod;
        showOutlineAction = showOutlineActionField;
    }

    public DiagramOutlineReloadContextProvider(Object diagramOutline) {
        this.diagramOutline = diagramOutline;
    }

    public Object createReloadContext() {
        return new ReloadContext(this.diagramOutline);
    }

    public void restore(Object reloadContext) {
        ((ReloadContext)reloadContext).restore(this.diagramOutline);
    }

    static boolean isDiagramOutline(Object o) {
        return diagramOutlinePage != null && diagramOutlinePage.isInstance(o);
    }

    private static class ReloadContext {
        private final int pageID;

        public ReloadContext(Object diagramOutline) {
            try {
                this.pageID = ((IAction)showOutlineAction.get(diagramOutline)).isChecked() ? 0 : 1;
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
        }

        void restore(Object diagramOutline) {
            try {
                showPage.invoke(diagramOutline, this.pageID);
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof RuntimeException) {
                    throw (RuntimeException)target;
                }
                if (target instanceof Error) {
                    throw (Error)target;
                }
                Activator.log.error(target);
            }
        }
    }
}

