/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.figure.edge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.papyrus.infra.core.editor.CoreMultiDiagramEditor;
import org.eclipse.papyrus.infra.tools.util.EditorHelper;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class PapyrusEdgeFigure
extends PolylineConnectionEx {
    private int bendpointDiameter;

    public PapyrusEdgeFigure() {
        this.setBendPointDiameter(7);
    }

    protected void outlineShape(Graphics g) {
        super.outlineShape(g);
        this.drawCommonbendpoints(g);
    }

    public void resetStyle() {
    }

    public Collection<Point> getCommonBendpointsToDraw() {
        HashSet<Point> commonBendpointsToDraw = new HashSet<Point>();
        PointList bendPoints = this.getPoints();
        Map<?, ?> visualPartMap = this.getVisualPartMap((IFigure)this);
        if (visualPartMap != null) {
            EObject el;
            EditPart currentEditPart = (EditPart)visualPartMap.get((Object)this);
            EClass eClass = null;
            if (currentEditPart instanceof IGraphicalEditPart && (el = ((IGraphicalEditPart)currentEditPart).resolveSemanticElement()) != null) {
                eClass = el.eClass();
            }
            if (currentEditPart instanceof ConnectionEditPart && eClass != null) {
                EditPart sourceEP = ((ConnectionEditPart)currentEditPart).getSource();
                EditPart targetEP = ((ConnectionEditPart)currentEditPart).getTarget();
                HashSet allConnectionsEP = new HashSet();
                if (sourceEP instanceof AbstractGraphicalEditPart && targetEP instanceof AbstractGraphicalEditPart) {
                    allConnectionsEP.addAll(((AbstractGraphicalEditPart)sourceEP).getSourceConnections());
                    allConnectionsEP.addAll(((AbstractGraphicalEditPart)targetEP).getSourceConnections());
                    allConnectionsEP.addAll(((AbstractGraphicalEditPart)sourceEP).getTargetConnections());
                    allConnectionsEP.addAll(((AbstractGraphicalEditPart)targetEP).getTargetConnections());
                    allConnectionsEP.remove(currentEditPart);
                }
                HashSet<Connection> allConnections = new HashSet<Connection>();
                if (allConnectionsEP.size() > 0) {
                    for (Object current : allConnectionsEP) {
                        IFigure currentFig;
                        EObject eObject;
                        if (!current.getClass().isInstance(currentEditPart) || !currentEditPart.getClass().isInstance(current) || !(current instanceof IGraphicalEditPart) || (eObject = ((IGraphicalEditPart)current).resolveSemanticElement()) != null && eClass != null && eObject.eClass() != eClass || !((currentFig = ((IGraphicalEditPart)current).getFigure()) instanceof Connection)) continue;
                        allConnections.add((Connection)currentFig);
                    }
                }
                ArrayList<LineSeg> refs = new ArrayList<LineSeg>();
                int i = 0;
                while (i < bendPoints.size() - 1) {
                    LineSeg lineSeg = new LineSeg(bendPoints.getPoint(i), bendPoints.getPoint(i + 1));
                    refs.add(lineSeg);
                    ++i;
                }
                HashMap segs = new HashMap();
                for (Connection connection : allConnections) {
                    PointList currentPoints = connection.getPoints();
                    HashMap mapSegs = new HashMap();
                    segs.put(connection, mapSegs);
                    for (LineSeg refSeg : refs) {
                        ArrayList<LineSeg> commonSubSegs = new ArrayList<LineSeg>();
                        mapSegs.put(refSeg, commonSubSegs);
                        int i2 = 0;
                        while (i2 < currentPoints.size() - 1) {
                            LineSeg tmp = new LineSeg(currentPoints.getPoint(i2), currentPoints.getPoint(i2 + 1));
                            PointList intersection = PapyrusEdgeFigure.getCommonSegment(refSeg, tmp);
                            if (intersection.size() == 2 && !intersection.getFirstPoint().equals((Object)intersection.getLastPoint())) {
                                double distanceFromSecond;
                                double distanceFromFirst = refSeg.getOrigin().getDistance(intersection.getFirstPoint());
                                LineSeg commonSeg = distanceFromFirst < (distanceFromSecond = refSeg.getOrigin().getDistance(intersection.getLastPoint())) ? new LineSeg(intersection.getFirstPoint(), intersection.getLastPoint()) : new LineSeg(intersection.getLastPoint(), intersection.getFirstPoint());
                                commonSubSegs.add(commonSeg);
                            }
                            ++i2;
                        }
                    }
                }
                for (Map.Entry entry : segs.entrySet()) {
                    Map commonSegMap = (Map)entry.getValue();
                    int i3 = 0;
                    while (i3 < refs.size()) {
                        List nextCommonSegs;
                        LineSeg nextSeg;
                        List previousCommonSegs;
                        LineSeg previousSeg;
                        LineSeg currentFigureSeg = (LineSeg)refs.get(i3);
                        List currentCommonSegs = (List)commonSegMap.get(currentFigureSeg);
                        if (i3 != 0) {
                            previousSeg = (LineSeg)refs.get(i3 - 1);
                            previousCommonSegs = (List)commonSegMap.get(previousSeg);
                        } else {
                            previousSeg = null;
                            previousCommonSegs = null;
                        }
                        if (i3 != refs.size() - 1) {
                            nextSeg = (LineSeg)refs.get(i3 + 1);
                            nextCommonSegs = (List)commonSegMap.get(nextSeg);
                        } else {
                            nextSeg = null;
                            nextCommonSegs = null;
                        }
                        LineSeg previousCommonSeg = null;
                        LineSeg nextCommonSeg = null;
                        int a = 0;
                        while (a < currentCommonSegs.size()) {
                            LineSeg curr = (LineSeg)currentCommonSegs.get(a);
                            Point first = curr.getOrigin();
                            Point second = curr.getTerminus();
                            previousCommonSeg = a == 0 ? (previousCommonSegs != null && previousCommonSegs.size() > 0 ? (LineSeg)previousCommonSegs.get(previousCommonSegs.size() - 1) : null) : (LineSeg)currentCommonSegs.get(a - 1);
                            nextCommonSeg = a == currentCommonSegs.size() - 1 ? (nextCommonSegs != null && nextCommonSegs.size() > 0 ? (LineSeg)nextCommonSegs.get(0) : null) : (LineSeg)currentCommonSegs.get(a + 1);
                            if (previousCommonSeg == null) {
                                if (i3 == 0) {
                                    if (!bendPoints.getFirstPoint().equals((Object)first)) {
                                        commonBendpointsToDraw.add(first);
                                    }
                                } else {
                                    commonBendpointsToDraw.add(first);
                                }
                            } else if (!previousCommonSeg.getTerminus().equals((Object)first)) {
                                commonBendpointsToDraw.add(first);
                            }
                            if (nextCommonSeg == null) {
                                if (i3 == refs.size() - 1) {
                                    if (!bendPoints.getLastPoint().equals((Object)second)) {
                                        commonBendpointsToDraw.add(second);
                                    }
                                } else {
                                    commonBendpointsToDraw.add(second);
                                }
                            } else if (!nextCommonSeg.getOrigin().equals((Object)second)) {
                                commonBendpointsToDraw.add(second);
                            }
                            ++a;
                        }
                        ++i3;
                    }
                }
            }
        }
        return commonBendpointsToDraw;
    }

    public void drawCommonBendpoints(Graphics g, Collection<Point> bendPoints) {
        int diameter = this.getBendPointDiameter();
        if (this.getDrawBendpointPreferenceValue() && bendPoints.size() > 0 && diameter > 1) {
            if (this.getBackgroundColor() != null) {
                g.setForegroundColor(this.getBackgroundColor());
            }
            if (this.getForegroundColor() != null) {
                g.setBackgroundColor(this.getForegroundColor());
            }
            for (Point point : bendPoints) {
                g.fillOval(point.x - (diameter - 1) / 2, point.y - (diameter - 1) / 2, diameter, diameter);
            }
            if (this.getBackgroundColor() != null) {
                g.setBackgroundColor(this.getBackgroundColor());
            }
            if (this.getForegroundColor() != null) {
                g.setForegroundColor(this.getForegroundColor());
            }
        }
    }

    protected void drawCommonbendpoints(Graphics g) {
        if (this.getPoints().size() > 2 && this.getDrawBendpointPreferenceValue()) {
            Collection<Point> commonPoints = this.getCommonBendpointsToDraw();
            this.drawCommonBendpoints(g, commonPoints);
        }
    }

    protected boolean getDrawBendpointPreferenceValue() {
        return false;
    }

    protected Map<?, ?> getVisualPartMap(IFigure figure) {
        block3: {
            IWorkbenchWindow window;
            block2: {
                IEditorPart part = EditorHelper.getCurrentEditor();
                if (!(part instanceof CoreMultiDiagramEditor)) break block2;
                List visibleEditors = ((CoreMultiDiagramEditor)part).getISashWindowsContainer().getVisibleIEditorParts();
                for (IEditorPart current : visibleEditors) {
                    GraphicalViewer viewer = (GraphicalViewer)current.getAdapter(GraphicalViewer.class);
                    Map visualPartMap = viewer.getVisualPartMap();
                    if (!visualPartMap.containsKey(figure)) continue;
                    return visualPartMap;
                }
                break block3;
            }
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench == null || (window = workbench.getActiveWorkbenchWindow()) == null) break block3;
            List editors = EditorService.getInstance().getRegisteredEditorParts();
            for (IEditorPart editor : editors) {
                IDiagramWorkbenchPart de;
                IDiagramGraphicalViewer viewer;
                Map visualPartMap;
                if (editor.getEditorSite().getWorkbenchWindow() != window || !(editor instanceof IDiagramWorkbenchPart) || !(visualPartMap = (viewer = (de = (IDiagramWorkbenchPart)editor).getDiagramGraphicalViewer()).getVisualPartMap()).containsKey(figure)) continue;
                return visualPartMap;
            }
        }
        return null;
    }

    public static final PointList getCommonSegment(LineSeg seg1, LineSeg seg2) {
        ArrayList<Point> list = new ArrayList<Point>();
        list.add(seg1.getOrigin());
        list.add(seg2.getOrigin());
        list.add(seg1.getTerminus());
        list.add(seg2.getTerminus());
        ArrayList<Point> commonPoints = new ArrayList<Point>();
        for (Point point : list) {
            if (commonPoints.contains(point) || !seg1.containsPoint(point, 0) || !seg2.containsPoint(point, 0)) continue;
            commonPoints.add(point);
        }
        PointList result = new PointList();
        for (Point point : commonPoints) {
            result.addPoint(point);
        }
        return result;
    }

    public void setBendPointDiameter(int diameter) {
        if (diameter <= 1) {
            this.bendpointDiameter = 0;
        }
        if (diameter % 2 != 0) {
            this.bendpointDiameter = diameter;
        } else {
            this.setBendPointDiameter(diameter + 1);
        }
    }

    protected final int getBendPointDiameter() {
        return this.bendpointDiameter;
    }
}

