/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.core.utils.IExecutorPolicy;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IPapyrusCanonicalEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.tools.util.UIUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class DiagramHelper {
    private static final AtomicBoolean refreshPending = new AtomicBoolean();
    private static final ConcurrentMap<DiagramEditPart, Boolean> pendingDiagramRefresh = new MapMaker().concurrencyLevel(4).weakKeys().makeMap();
    private static final Executor uiExecutor = UIUtil.createUIExecutor((Display)Display.getDefault());
    private static final LoadingCache<TransactionalEditingDomain, Executor> domainExecutors = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<TransactionalEditingDomain, Executor>(){

        public Executor load(TransactionalEditingDomain domain) {
            IExecutorPolicy policy = new IExecutorPolicy(){

                public IExecutorPolicy.Ranking rank(Runnable task, Executor executor) {
                    if (executor == uiExecutor) {
                        return IExecutorPolicy.Ranking.ACCEPTABLE;
                    }
                    return Display.getCurrent() == null ? IExecutorPolicy.Ranking.DEPRECATED : IExecutorPolicy.Ranking.PREFERRED;
                }
            };
            return TransactionHelper.createTransactionExecutor((TransactionalEditingDomain)domain, (Executor)uiExecutor, (IExecutorPolicy)policy, (Map)TransactionHelper.mergeReadOnlyOption((boolean)true));
        }
    });

    public static void refresh(EditPart editPart, boolean recursive) {
        editPart.refresh();
        DiagramHelper.refreshCanonical(editPart);
        if (recursive) {
            List children = editPart.getChildren();
            for (EditPart childEditPart : children) {
                DiagramHelper.refresh(childEditPart, true);
            }
        }
    }

    private static void refreshCanonical(EditPart editPart) {
        EditPolicy editPolicy = editPart.getEditPolicy((Object)"Canonical");
        if (editPolicy instanceof IPapyrusCanonicalEditPolicy) {
            ((IPapyrusCanonicalEditPolicy)editPolicy).refreshActive();
        }
    }

    public static void refresh(DiagramEditPart diagramEditPart, boolean recursive) {
        DiagramHelper.setNeedsRefresh(diagramEditPart, false);
        diagramEditPart.refresh();
        if (recursive) {
            ImmutableList childrenToRefresh = ImmutableList.copyOf((Collection)diagramEditPart.getChildren());
            for (EditPart childEditPart : childrenToRefresh) {
                DiagramHelper.refresh(childEditPart, true);
            }
            ImmutableList connectionsToRefresh = ImmutableList.copyOf((Collection)diagramEditPart.getConnections());
            for (EditPart childEditPart : connectionsToRefresh) {
                DiagramHelper.refresh(childEditPart, true);
            }
        }
    }

    public static void refresh(IEditorPart editorPart) {
        List visibleEditorParts = null;
        if (editorPart instanceof IMultiDiagramEditor) {
            ServicesRegistry servicesRegistry = (ServicesRegistry)editorPart.getAdapter(ServicesRegistry.class);
            if (servicesRegistry != null) {
                try {
                    ISashWindowsContainer container = ServiceUtils.getInstance().getISashWindowsContainer((Object)servicesRegistry);
                    visibleEditorParts = container.getVisibleIEditorParts();
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        } else {
            visibleEditorParts = Collections.singletonList(editorPart);
        }
        if (visibleEditorParts != null) {
            for (IEditorPart visiblePart : visibleEditorParts) {
                DiagramEditor diagramEditor;
                DiagramEditPart topEditPart;
                if (!(visiblePart instanceof DiagramEditor) || (topEditPart = (diagramEditor = (DiagramEditor)visiblePart).getDiagramEditPart()) == null) continue;
                DiagramHelper.refresh(topEditPart, true);
            }
        }
    }

    public static void scheduleRefresh(final DiagramEditPart diagram) {
        if (DiagramHelper.setNeedsRefresh(diagram, true)) {
            DiagramHelper.asyncExec(diagram, new Runnable(){

                @Override
                public void run() {
                    if (DiagramHelper.setNeedsRefresh(diagram, false) && diagram.isActive() && diagram.getViewer() != null && DiagramHelper.isAttached(diagram.getModel())) {
                        DiagramHelper.refresh(diagram, true);
                    }
                }
            });
        }
    }

    private static boolean isAttached(Object diagramView) {
        return diagramView instanceof EObject && ((EObject)diagramView).eResource() != null;
    }

    private static boolean setNeedsRefresh(DiagramEditPart diagram, boolean refresh) {
        if (refresh) {
            return pendingDiagramRefresh.putIfAbsent(diagram, Boolean.TRUE) == null;
        }
        return pendingDiagramRefresh.remove(diagram, Boolean.TRUE);
    }

    private static Executor getExecutor(DiagramEditPart diagram) {
        TransactionalEditingDomain domain = diagram.getEditingDomain();
        return domain != null ? (Executor)domainExecutors.getUnchecked((Object)domain) : uiExecutor;
    }

    public static void forceRefresh(DiagramEditPart diagram) {
        DiagramHelper.setNeedsRefresh(diagram, true);
        DiagramHelper.refresh(diagram, true);
    }

    @Deprecated
    public static void refreshDiagrams() {
        if (refreshPending.compareAndSet(true, false)) {
            IMultiDiagramEditor[] editors = EditorUtils.getMultiDiagramEditors();
            if (editors == null || editors.length < 1) {
                return;
            }
            IMultiDiagramEditor[] iMultiDiagramEditorArray = editors;
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IMultiDiagramEditor activeMultiEditor = iMultiDiagramEditorArray[n2];
                DiagramHelper.refresh((IEditorPart)activeMultiEditor);
                ++n2;
            }
        }
    }

    @Deprecated
    public static boolean setNeedsRefresh() {
        return refreshPending.compareAndSet(false, true);
    }

    public static void scheduleRefresh() {
        if (DiagramHelper.setNeedsRefresh()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DiagramHelper.refreshDiagrams();
                }
            });
        }
    }

    public static void forceRefresh() {
        DiagramHelper.setNeedsRefresh();
        DiagramHelper.refreshDiagrams();
    }

    public static void asyncExec(DiagramEditPart context, Runnable task) {
        DiagramHelper.getExecutor(context).execute(task);
    }

    public static void asyncExec(EditPart context, Runnable task) {
        DiagramEditPart diagram = DiagramEditPartsUtil.getDiagramEditPart(context);
        if (diagram != null) {
            DiagramHelper.asyncExec(diagram, task);
        } else {
            uiExecutor.execute(task);
        }
    }

    public static <V> ListenableFuture<V> submit(DiagramEditPart context, Callable<V> task) {
        ListenableFutureTask result = ListenableFutureTask.create(task);
        DiagramHelper.getExecutor(context).execute((Runnable)result);
        return result;
    }

    public static <V> ListenableFuture<V> submit(EditPart context, Callable<V> task) {
        ListenableFutureTask result;
        DiagramEditPart diagram = DiagramEditPartsUtil.getDiagramEditPart(context);
        if (diagram != null) {
            result = DiagramHelper.submit(diagram, task);
        } else {
            ListenableFutureTask runnable = ListenableFutureTask.create(task);
            uiExecutor.execute((Runnable)runnable);
            result = runnable;
        }
        return result;
    }
}

