/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.sync;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.Map;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.requests.CanonicalDropObjectsRequest;
import org.eclipse.papyrus.infra.sync.EStructuralFeatureSyncFeature;
import org.eclipse.papyrus.infra.sync.SyncBucket;
import org.eclipse.papyrus.infra.sync.SyncItem;
import org.eclipse.papyrus.infra.sync.SyncRegistry;
import org.eclipse.papyrus.infra.sync.service.ISyncService;
import org.eclipse.papyrus.infra.sync.service.SyncServiceRunnable;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractNestedDiagramViewsSyncFeature<M extends EObject, N extends EObject, T extends EditPart>
extends EStructuralFeatureSyncFeature<M, T> {
    private final SyncRegistry<N, T, Notification> nestedRegistry;
    private Map<EObject, EObject> lastKnownElements = new MapMaker().weakKeys().weakValues().makeMap();

    public AbstractNestedDiagramViewsSyncFeature(SyncBucket<M, T, Notification> bucket, EReference reference, EReference ... more) {
        super(bucket, (EStructuralFeature)reference, (EStructuralFeature[])more);
        this.nestedRegistry = this.getSyncRegistry(this.getNestedSyncRegistryType());
    }

    protected abstract Class<? extends SyncRegistry<N, T, Notification>> getNestedSyncRegistryType();

    protected SyncRegistry<N, T, Notification> getNestedSyncRegistry() {
        return this.nestedRegistry;
    }

    protected abstract EditPart getEffectiveEditPart(EditPart var1);

    protected final Iterable<? extends T> getContents(T backend) {
        return this.filterContents(this.basicGetContents(backend));
    }

    abstract Iterable<? extends T> basicGetContents(T var1);

    protected Iterable<? extends T> filterContents(Iterable<? extends T> rawContents) {
        return Iterables.filter(rawContents, (Predicate)new Predicate<T>(){
            private final Class<? extends N> nestedType;
            {
                this.nestedType = AbstractNestedDiagramViewsSyncFeature.this.nestedRegistry.getModelType();
            }

            public boolean apply(T input) {
                View view = (View)TypeUtils.as((Object)input.getModel(), View.class);
                return view != null && this.nestedType.isInstance(view.getElement());
            }
        });
    }

    protected boolean shouldAdd(SyncItem<M, T> from, SyncItem<M, T> to, EObject newSource) {
        return this.getNestedSyncRegistry().getModelType().isInstance(newSource);
    }

    protected Command getAddCommand(final SyncItem<M, T> from, final SyncItem<M, T> to, final EObject newModel) {
        return new AbstractCommand(){
            private T child;
            private EObject objectToDrop;
            private org.eclipse.gef.commands.Command dropCommand;

            protected boolean prepare() {
                return true;
            }

            private org.eclipse.gef.commands.Command getDropCommand() {
                if (this.dropCommand == null) {
                    EditPartViewer viewer = AbstractNestedDiagramViewsSyncFeature.this.getEffectiveEditPart((EditPart)to.getBackend()).getViewer();
                    Control control = viewer.getControl();
                    FigureCanvas figureCanvas = (FigureCanvas)control;
                    Point location = figureCanvas.getViewport().getViewLocation();
                    DropObjectsRequest dropObjectsRequest = new DropObjectsRequest();
                    this.objectToDrop = AbstractNestedDiagramViewsSyncFeature.this.getTargetModel(from, to, newModel);
                    dropObjectsRequest.setObjects(Collections.singletonList(this.objectToDrop));
                    dropObjectsRequest.setLocation(location);
                    EditPart dropEditPart = AbstractNestedDiagramViewsSyncFeature.this.getEffectiveEditPart((EditPart)to.getBackend());
                    EditPart targetEditPart = AbstractNestedDiagramViewsSyncFeature.this.getTargetEditPart(dropEditPart, dropObjectsRequest);
                    if (targetEditPart != null) {
                        dropEditPart = targetEditPart;
                    }
                    this.dropCommand = dropEditPart.getCommand((Request)new CanonicalDropObjectsRequest(dropObjectsRequest));
                    if (this.dropCommand == null) {
                        this.dropCommand = UnexecutableCommand.INSTANCE;
                    }
                }
                return this.dropCommand;
            }

            public void execute() {
                this.getDropCommand().execute();
                this.onDo();
            }

            public void undo() {
                Command additional;
                if (this.child != null && (additional = AbstractNestedDiagramViewsSyncFeature.this.onTargetRemoved(to, this.child)) != null) {
                    additional.execute();
                }
                this.getDropCommand().undo();
            }

            public void redo() {
                this.getDropCommand().redo();
                this.onDo();
            }

            private void onDo() {
                AbstractNestedDiagramViewsSyncFeature.this.runAsync((SyncServiceRunnable)new SyncServiceRunnable.Safe<T>(){

                    public T run(ISyncService syncService) {
                        Command additional;
                        child = AbstractNestedDiagramViewsSyncFeature.this.findChild((EditPart)to.getBackend(), AbstractNestedDiagramViewsSyncFeature.this.getTargetModel(from, to, objectToDrop));
                        if (child != null && (additional = AbstractNestedDiagramViewsSyncFeature.this.onTargetAdded(from, newModel, to, child)) != null) {
                            syncService.execute(additional);
                        }
                        return child;
                    }
                });
            }
        };
    }

    protected EditPart getTargetEditPart(EditPart parentEditPart, DropObjectsRequest dropObjectsRequest) {
        return parentEditPart.getTargetEditPart((Request)dropObjectsRequest);
    }

    protected T findChild(T parent, EObject model) {
        if (parent == null || model == null) {
            return null;
        }
        Iterable<T> children = this.getContents(parent);
        for (EditPart child : children) {
            if (model != this.getModelOf(child)) continue;
            return (T)child;
        }
        return null;
    }

    protected Command getRemoveCommand(final SyncItem<M, T> from, final EObject oldSource, final SyncItem<M, T> to, T _oldTarget) {
        final View oldView = (View)_oldTarget.getModel();
        return new CommandWrapper(this.doGetRemoveCommand(from, oldSource, to, _oldTarget)){
            private T oldTarget;

            public void execute() {
                this.updateOldTarget();
                super.execute();
                this.onDo();
            }

            private void updateOldTarget() {
                Object editPart = ((EditPart)to.getBackend()).getViewer().getEditPartRegistry().get(oldView);
                this.oldTarget = (EditPart)AbstractNestedDiagramViewsSyncFeature.this.getNestedSyncRegistry().getBackendType().cast(editPart);
            }

            public void undo() {
                super.undo();
                if (oldSource != null) {
                    AbstractNestedDiagramViewsSyncFeature.this.runAsync((SyncServiceRunnable)new SyncServiceRunnable.Safe<Command>(){

                        public Command run(ISyncService syncService) {
                            this.updateOldTarget();
                            Command additional = AbstractNestedDiagramViewsSyncFeature.this.onTargetAdded(from, oldSource, to, oldTarget);
                            if (additional != null) {
                                syncService.execute(additional);
                            }
                            return additional;
                        }
                    });
                }
            }

            public void redo() {
                this.updateOldTarget();
                super.redo();
                this.onDo();
            }

            private void onDo() {
                Command additional = AbstractNestedDiagramViewsSyncFeature.this.onTargetRemoved(to, this.oldTarget);
                if (additional != null) {
                    additional.execute();
                }
            }
        };
    }

    protected Command doGetRemoveCommand(SyncItem<M, T> from, EObject oldSource, SyncItem<M, T> to, T oldTarget) {
        return DeleteCommand.create((EditingDomain)this.getEditingDomain(), (Object)oldTarget.getModel());
    }

    protected EObject getModelOfNotifier(EObject backendNotifier) {
        EObject result = ((View)backendNotifier).getElement();
        if (result != null) {
            if (this.lastKnownElements.get(backendNotifier) != result) {
                this.lastKnownElements.put(backendNotifier, result);
            }
        } else {
            result = this.lastKnownElements.get(backendNotifier);
        }
        return result;
    }

    protected EObject getNotifier(T backend) {
        return (View)this.getEffectiveEditPart((EditPart)backend).getModel();
    }
}

