/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.properties.widgets;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.gmfdiag.css.helper.ResetStyleHelper;
import org.eclipse.papyrus.views.properties.modelelement.DataSource;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ResetStyleWidget
implements SelectionListener {
    private Button button;
    private DataSource input;
    private String propertyPath;

    public ResetStyleWidget(Composite parent, int style) {
        this.button = new Button(parent, 8);
        this.button.addSelectionListener((SelectionListener)this);
        this.button.setText("Default style");
        this.button.setToolTipText("Resets the properties which have been customized outside of the Style support. The default style will be applied");
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget != this.button || this.input == null) {
            return;
        }
        IStructuredSelection viewSelection = this.input.getSelection();
        ResetStyleHelper.resetStyle((IStructuredSelection)viewSelection);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setText(String text) {
        this.button.setText(text);
    }

    public String getText() {
        return this.button.getText();
    }

    public void setToolTipText(String tooltip) {
        this.button.setToolTipText(tooltip);
    }

    public String getToolTipText() {
        return this.button.getToolTipText();
    }

    public void setInput(DataSource input) {
        this.input = input;
        this.checkInput();
    }

    public DataSource getInput() {
        return this.input;
    }

    public String getProperty() {
        return this.propertyPath;
    }

    public void setProperty(String property) {
        this.propertyPath = property;
        this.checkInput();
    }

    protected void checkInput() {
        if (this.propertyPath != null && this.input != null) {
            this.button.setEnabled(this.input.isEditable(this.propertyPath));
        } else {
            this.button.setEnabled(true);
        }
    }
}

