/**
 * Copyright (c) 2015 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *  CEA LIST - Initial Implementation
 *  Nicolas FAUVERGUE (ALL4TEC) nicolas.fauvergue@all4tec.net - Bug 473188
 */
package org.eclipse.papyrus.infra.gmfdiag.css3.formatting;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.papyrus.infra.gmfdiag.css3.services.CSSGrammarAccess;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter;
import org.eclipse.xtext.formatting.impl.FormattingConfig;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.xbase.lib.Extension;

/**
 * This class contains custom formatting declarations.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#formatting
 * on how and when to use it.
 * 
 * Also see {@link org.eclipse.xtext.xtext.XtextFormattingTokenSerializer} as an example
 */
@SuppressWarnings("all")
public class CSSFormatter extends AbstractDeclarativeFormatter {
  @Inject
  @Extension
  private CSSGrammarAccess _cSSGrammarAccess;
  
  /**
   * The space character.
   */
  private final static String SPACE = " ";
  
  protected void configureFormatting(final FormattingConfig c) {
    FormattingConfig.NoSpaceLocator _setNoSpace = c.setNoSpace();
    TerminalRule _wSRule = this.getWSRule();
    _setNoSpace.around(_wSRule);
    List<Pair<Keyword, Keyword>> _findKeywordPairs = this._cSSGrammarAccess.findKeywordPairs("{", "}");
    for (final Pair<Keyword, Keyword> curlyBracketPair : _findKeywordPairs) {
      {
        FormattingConfig.SpaceLocator _setSpace = c.setSpace(CSSFormatter.SPACE);
        Keyword _first = curlyBracketPair.getFirst();
        _setSpace.before(_first);
        FormattingConfig.IndentationLocatorStart _setIndentationIncrement = c.setIndentationIncrement();
        Keyword _first_1 = curlyBracketPair.getFirst();
        _setIndentationIncrement.after(_first_1);
        FormattingConfig.LinewrapLocator _setLinewrap = c.setLinewrap();
        Keyword _first_2 = curlyBracketPair.getFirst();
        _setLinewrap.after(_first_2);
        FormattingConfig.IndentationLocatorEnd _setIndentationDecrement = c.setIndentationDecrement();
        Keyword _second = curlyBracketPair.getSecond();
        _setIndentationDecrement.before(_second);
        FormattingConfig.LinewrapLocator _setLinewrap_1 = c.setLinewrap();
        Keyword _second_1 = curlyBracketPair.getSecond();
        _setLinewrap_1.after(_second_1);
      }
    }
    List<Pair<Keyword, Keyword>> _findKeywordPairs_1 = this._cSSGrammarAccess.findKeywordPairs("[", "]");
    for (final Pair<Keyword, Keyword> squareBracketPair : _findKeywordPairs_1) {
      {
        FormattingConfig.NoSpaceLocator _setNoSpace_1 = c.setNoSpace();
        Keyword _first = squareBracketPair.getFirst();
        _setNoSpace_1.around(_first);
        FormattingConfig.NoSpaceLocator _setNoSpace_2 = c.setNoSpace();
        Keyword _second = squareBracketPair.getSecond();
        _setNoSpace_2.around(_second);
      }
    }
    List<Pair<Keyword, Keyword>> _findKeywordPairs_2 = this._cSSGrammarAccess.findKeywordPairs("(", ")");
    for (final Pair<Keyword, Keyword> bracketPair : _findKeywordPairs_2) {
      {
        FormattingConfig.NoSpaceLocator _setNoSpace_1 = c.setNoSpace();
        Keyword _first = bracketPair.getFirst();
        _setNoSpace_1.after(_first);
        FormattingConfig.NoSpaceLocator _setNoSpace_2 = c.setNoSpace();
        Keyword _second = bracketPair.getSecond();
        _setNoSpace_2.before(_second);
      }
    }
    List<Keyword> _findKeywords = this._cSSGrammarAccess.findKeywords(";");
    for (final Keyword semicolon : _findKeywords) {
      {
        FormattingConfig.NoSpaceLocator _setNoSpace_1 = c.setNoSpace();
        _setNoSpace_1.before(semicolon);
        FormattingConfig.LinewrapLocator _setLinewrap = c.setLinewrap();
        _setLinewrap.after(semicolon);
      }
    }
    List<Keyword> _findKeywords_1 = this._cSSGrammarAccess.findKeywords(".");
    for (final Keyword dot : _findKeywords_1) {
      FormattingConfig.NoSpaceLocator _setNoSpace_1 = c.setNoSpace();
      _setNoSpace_1.around(dot);
    }
    List<Keyword> _findKeywords_2 = this._cSSGrammarAccess.findKeywords("%");
    for (final Keyword percent : _findKeywords_2) {
      FormattingConfig.NoSpaceLocator _setNoSpace_2 = c.setNoSpace();
      _setNoSpace_2.before(percent);
    }
    FormattingConfig.LinewrapLocator _setLinewrap = c.setLinewrap(0, 1, 2);
    TerminalRule _mL_COMMENTRule = this._cSSGrammarAccess.getML_COMMENTRule();
    _setLinewrap.before(_mL_COMMENTRule);
    FormattingConfig.LinewrapLocator _setLinewrap_1 = c.setLinewrap(0, 1, 1);
    TerminalRule _mL_COMMENTRule_1 = this._cSSGrammarAccess.getML_COMMENTRule();
    _setLinewrap_1.after(_mL_COMMENTRule_1);
    FormattingConfig.LinewrapLocator _setLinewrap_2 = c.setLinewrap(2);
    CSSGrammarAccess.StylesheetElements _stylesheetAccess = this._cSSGrammarAccess.getStylesheetAccess();
    Assignment _charsetAssignment_0 = _stylesheetAccess.getCharsetAssignment_0();
    _setLinewrap_2.after(_charsetAssignment_0);
    FormattingConfig.LinewrapLocator _setLinewrap_3 = c.setLinewrap(2);
    CSSGrammarAccess.StylesheetElements _stylesheetAccess_1 = this._cSSGrammarAccess.getStylesheetAccess();
    RuleCall _importsImportExpressionParserRuleCall_1_0 = _stylesheetAccess_1.getImportsImportExpressionParserRuleCall_1_0();
    _setLinewrap_3.after(_importsImportExpressionParserRuleCall_1_0);
    FormattingConfig.LinewrapLocator _setLinewrap_4 = c.setLinewrap(2);
    ParserRule _rulesetRule = this._cSSGrammarAccess.getRulesetRule();
    _setLinewrap_4.after(_rulesetRule);
    FormattingConfig.LinewrapLocator _setLinewrap_5 = c.setLinewrap(2);
    ParserRule _mediaRule = this._cSSGrammarAccess.getMediaRule();
    _setLinewrap_5.after(_mediaRule);
    FormattingConfig.LinewrapLocator _setLinewrap_6 = c.setLinewrap(2);
    ParserRule _pageRule = this._cSSGrammarAccess.getPageRule();
    _setLinewrap_6.after(_pageRule);
    FormattingConfig.LinewrapLocator _setLinewrap_7 = c.setLinewrap(2);
    ParserRule _font_faceRule = this._cSSGrammarAccess.getFont_faceRule();
    _setLinewrap_7.after(_font_faceRule);
    FormattingConfig.LinewrapLocator _setLinewrap_8 = c.setLinewrap(2);
    ParserRule _keyframesRule = this._cSSGrammarAccess.getKeyframesRule();
    _setLinewrap_8.after(_keyframesRule);
    FormattingConfig.SpaceLocator _setSpace = c.setSpace(CSSFormatter.SPACE);
    CSSGrammarAccess.CharsetElements _charsetAccess = this._cSSGrammarAccess.getCharsetAccess();
    Keyword _charsetKeyword_0_0 = _charsetAccess.getCharsetKeyword_0_0();
    _setSpace.after(_charsetKeyword_0_0);
    FormattingConfig.SpaceLocator _setSpace_1 = c.setSpace(CSSFormatter.SPACE);
    CSSGrammarAccess.CharsetElements _charsetAccess_1 = this._cSSGrammarAccess.getCharsetAccess();
    Keyword _cHARSETKeyword_0_1 = _charsetAccess_1.getCHARSETKeyword_0_1();
    _setSpace_1.after(_cHARSETKeyword_0_1);
    FormattingConfig.SpaceLocator _setSpace_2 = c.setSpace(CSSFormatter.SPACE);
    CSSGrammarAccess.ImportExpressionElements _importExpressionAccess = this._cSSGrammarAccess.getImportExpressionAccess();
    Keyword _importKeyword_0_0 = _importExpressionAccess.getImportKeyword_0_0();
    _setSpace_2.after(_importKeyword_0_0);
    FormattingConfig.SpaceLocator _setSpace_3 = c.setSpace(CSSFormatter.SPACE);
    CSSGrammarAccess.ImportExpressionElements _importExpressionAccess_1 = this._cSSGrammarAccess.getImportExpressionAccess();
    Keyword _iMPORTKeyword_0_1 = _importExpressionAccess_1.getIMPORTKeyword_0_1();
    _setSpace_3.after(_iMPORTKeyword_0_1);
    FormattingConfig.SpaceLocator _setSpace_4 = c.setSpace(CSSFormatter.SPACE);
    CSSGrammarAccess.PageElements _pageAccess = this._cSSGrammarAccess.getPageAccess();
    Keyword _pageKeyword_1_0 = _pageAccess.getPageKeyword_1_0();
    _setSpace_4.after(_pageKeyword_1_0);
    FormattingConfig.SpaceLocator _setSpace_5 = c.setSpace(CSSFormatter.SPACE);
    CSSGrammarAccess.PageElements _pageAccess_1 = this._cSSGrammarAccess.getPageAccess();
    Keyword _pAGEKeyword_1_1 = _pageAccess_1.getPAGEKeyword_1_1();
    _setSpace_5.after(_pAGEKeyword_1_1);
    FormattingConfig.NoSpaceLocator _setNoSpace_3 = c.setNoSpace();
    CSSGrammarAccess.Pseudo_pageElements _pseudo_pageAccess = this._cSSGrammarAccess.getPseudo_pageAccess();
    RuleCall _cOLONTerminalRuleCall_0 = _pseudo_pageAccess.getCOLONTerminalRuleCall_0();
    _setNoSpace_3.around(_cOLONTerminalRuleCall_0);
    FormattingConfig.SpaceLocator _setSpace_6 = c.setSpace(CSSFormatter.SPACE);
    CSSGrammarAccess.MediaElements _mediaAccess = this._cSSGrammarAccess.getMediaAccess();
    Keyword _mediaKeyword_0_0 = _mediaAccess.getMediaKeyword_0_0();
    _setSpace_6.after(_mediaKeyword_0_0);
    FormattingConfig.SpaceLocator _setSpace_7 = c.setSpace(CSSFormatter.SPACE);
    CSSGrammarAccess.MediaElements _mediaAccess_1 = this._cSSGrammarAccess.getMediaAccess();
    Keyword _mEDIAKeyword_0_1 = _mediaAccess_1.getMEDIAKeyword_0_1();
    _setSpace_7.after(_mEDIAKeyword_0_1);
    FormattingConfig.NoSpaceLocator _setNoSpace_4 = c.setNoSpace();
    CSSGrammarAccess.Media_listElements _media_listAccess = this._cSSGrammarAccess.getMedia_listAccess();
    RuleCall _cOMMATerminalRuleCall_1_0 = _media_listAccess.getCOMMATerminalRuleCall_1_0();
    _setNoSpace_4.before(_cOMMATerminalRuleCall_1_0);
    FormattingConfig.SpaceLocator _setSpace_8 = c.setSpace(CSSFormatter.SPACE);
    CSSGrammarAccess.Media_listElements _media_listAccess_1 = this._cSSGrammarAccess.getMedia_listAccess();
    RuleCall _cOMMATerminalRuleCall_1_0_1 = _media_listAccess_1.getCOMMATerminalRuleCall_1_0();
    _setSpace_8.after(_cOMMATerminalRuleCall_1_0_1);
    FormattingConfig.SpaceLocator _setSpace_9 = c.setSpace(CSSFormatter.SPACE);
    CSSGrammarAccess.Font_faceElements _font_faceAccess = this._cSSGrammarAccess.getFont_faceAccess();
    Keyword _fontFaceKeyword_1_0 = _font_faceAccess.getFontFaceKeyword_1_0();
    _setSpace_9.after(_fontFaceKeyword_1_0);
    FormattingConfig.SpaceLocator _setSpace_10 = c.setSpace(CSSFormatter.SPACE);
    CSSGrammarAccess.Font_faceElements _font_faceAccess_1 = this._cSSGrammarAccess.getFont_faceAccess();
    Keyword _fONTFACEKeyword_1_1 = _font_faceAccess_1.getFONTFACEKeyword_1_1();
    _setSpace_10.after(_fONTFACEKeyword_1_1);
    FormattingConfig.SpaceLocator _setSpace_11 = c.setSpace(CSSFormatter.SPACE);
    CSSGrammarAccess.KeyframesElements _keyframesAccess = this._cSSGrammarAccess.getKeyframesAccess();
    Keyword _keyframesKeyword_1_0 = _keyframesAccess.getKeyframesKeyword_1_0();
    _setSpace_11.after(_keyframesKeyword_1_0);
    FormattingConfig.SpaceLocator _setSpace_12 = c.setSpace(CSSFormatter.SPACE);
    CSSGrammarAccess.KeyframesElements _keyframesAccess_1 = this._cSSGrammarAccess.getKeyframesAccess();
    Keyword _kEYFRAMESKeyword_1_1 = _keyframesAccess_1.getKEYFRAMESKeyword_1_1();
    _setSpace_12.after(_kEYFRAMESKeyword_1_1);
    FormattingConfig.NoSpaceLocator _setNoSpace_5 = c.setNoSpace();
    CSSGrammarAccess.RulesetElements _rulesetAccess = this._cSSGrammarAccess.getRulesetAccess();
    RuleCall _cOMMATerminalRuleCall_1_1 = _rulesetAccess.getCOMMATerminalRuleCall_1_1();
    _setNoSpace_5.before(_cOMMATerminalRuleCall_1_1);
    FormattingConfig.LinewrapLocator _setLinewrap_9 = c.setLinewrap();
    CSSGrammarAccess.RulesetElements _rulesetAccess_1 = this._cSSGrammarAccess.getRulesetAccess();
    RuleCall _cOMMATerminalRuleCall_1_1_1 = _rulesetAccess_1.getCOMMATerminalRuleCall_1_1();
    _setLinewrap_9.after(_cOMMATerminalRuleCall_1_1_1);
    FormattingConfig.NoSpaceLocator _setNoSpace_6 = c.setNoSpace();
    TerminalRule _pLUSRule = this._cSSGrammarAccess.getPLUSRule();
    _setNoSpace_6.after(_pLUSRule);
    FormattingConfig.NoSpaceLocator _setNoSpace_7 = c.setNoSpace();
    TerminalRule _dASHRule = this._cSSGrammarAccess.getDASHRule();
    _setNoSpace_7.after(_dASHRule);
    FormattingConfig.NoSpaceLocator _setNoSpace_8 = c.setNoSpace();
    TerminalRule _oNE_INTRule = this._cSSGrammarAccess.getONE_INTRule();
    _setNoSpace_8.before(_oNE_INTRule);
    FormattingConfig.NoSpaceLocator _setNoSpace_9 = c.setNoSpace();
    TerminalRule _oNE_HEX_LETTERRule = this._cSSGrammarAccess.getONE_HEX_LETTERRule();
    _setNoSpace_9.before(_oNE_HEX_LETTERRule);
    FormattingConfig.NoSpaceLocator _setNoSpace_10 = c.setNoSpace();
    TerminalRule _iNCLUDESRule = this._cSSGrammarAccess.getINCLUDESRule();
    _setNoSpace_10.around(_iNCLUDESRule);
    FormattingConfig.NoSpaceLocator _setNoSpace_11 = c.setNoSpace();
    TerminalRule _dASHMATCHRule = this._cSSGrammarAccess.getDASHMATCHRule();
    _setNoSpace_11.around(_dASHMATCHRule);
    FormattingConfig.NoSpaceLocator _setNoSpace_12 = c.setNoSpace();
    ParserRule _operatorRule = this._cSSGrammarAccess.getOperatorRule();
    _setNoSpace_12.around(_operatorRule);
    FormattingConfig.NoSpaceLocator _setNoSpace_13 = c.setNoSpace();
    CSSGrammarAccess.PseudoClassElements _pseudoClassAccess = this._cSSGrammarAccess.getPseudoClassAccess();
    RuleCall _cOLONTerminalRuleCall_0_1 = _pseudoClassAccess.getCOLONTerminalRuleCall_0();
    _setNoSpace_13.around(_cOLONTerminalRuleCall_0_1);
    FormattingConfig.NoSpaceLocator _setNoSpace_14 = c.setNoSpace();
    CSSGrammarAccess.PseudoClassElements _pseudoClassAccess_1 = this._cSSGrammarAccess.getPseudoClassAccess();
    RuleCall _cOLONTerminalRuleCall_1 = _pseudoClassAccess_1.getCOLONTerminalRuleCall_1();
    _setNoSpace_14.around(_cOLONTerminalRuleCall_1);
    FormattingConfig.NoSpaceLocator _setNoSpace_15 = c.setNoSpace();
    CSSGrammarAccess.PseudoClassFunctionElements _pseudoClassFunctionAccess = this._cSSGrammarAccess.getPseudoClassFunctionAccess();
    RuleCall _cOLONTerminalRuleCall_1_0 = _pseudoClassFunctionAccess.getCOLONTerminalRuleCall_1_0();
    _setNoSpace_15.around(_cOLONTerminalRuleCall_1_0);
    FormattingConfig.NoSpaceLocator _setNoSpace_16 = c.setNoSpace();
    CSSGrammarAccess.PseudoClassFunctionElements _pseudoClassFunctionAccess_1 = this._cSSGrammarAccess.getPseudoClassFunctionAccess();
    Assignment _nameAssignment_1_1 = _pseudoClassFunctionAccess_1.getNameAssignment_1_1();
    _setNoSpace_16.after(_nameAssignment_1_1);
    FormattingConfig.NoSpaceLocator _setNoSpace_17 = c.setNoSpace();
    CSSGrammarAccess.Css_declarationElements _css_declarationAccess = this._cSSGrammarAccess.getCss_declarationAccess();
    RuleCall _cOLONTerminalRuleCall_3 = _css_declarationAccess.getCOLONTerminalRuleCall_3();
    _setNoSpace_17.before(_cOLONTerminalRuleCall_3);
    FormattingConfig.SpaceLocator _setSpace_13 = c.setSpace(CSSFormatter.SPACE);
    CSSGrammarAccess.Css_declarationElements _css_declarationAccess_1 = this._cSSGrammarAccess.getCss_declarationAccess();
    RuleCall _cOLONTerminalRuleCall_3_1 = _css_declarationAccess_1.getCOLONTerminalRuleCall_3();
    _setSpace_13.after(_cOLONTerminalRuleCall_3_1);
    FormattingConfig.NoSpaceLocator _setNoSpace_18 = c.setNoSpace();
    CSSGrammarAccess.AttributeSelectorElements _attributeSelectorAccess = this._cSSGrammarAccess.getAttributeSelectorAccess();
    Assignment _opAssignment_3_0 = _attributeSelectorAccess.getOpAssignment_3_0();
    _setNoSpace_18.around(_opAssignment_3_0);
    FormattingConfig.NoSpaceLocator _setNoSpace_19 = c.setNoSpace();
    CSSGrammarAccess.NotFunctionCallElements _notFunctionCallAccess = this._cSSGrammarAccess.getNotFunctionCallAccess();
    Keyword _notKeyword_1 = _notFunctionCallAccess.getNotKeyword_1();
    _setNoSpace_19.after(_notKeyword_1);
    FormattingConfig.NoSpaceLocator _setNoSpace_20 = c.setNoSpace();
    CSSGrammarAccess.SymbolTokElements _symbolTokAccess = this._cSSGrammarAccess.getSymbolTokAccess();
    Assignment _symbolAssignment_1 = _symbolTokAccess.getSymbolAssignment_1();
    _setNoSpace_20.around(_symbolAssignment_1);
    FormattingConfig.NoSpaceLocator _setNoSpace_21 = c.setNoSpace();
    ParserRule _validURLRule = this._cSSGrammarAccess.getValidURLRule();
    _setNoSpace_21.around(_validURLRule);
  }
}
