/*
 * generated by Xtext
 */
package org.eclipse.papyrus.infra.gmfdiag.css3.serializer;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.AttributeSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.CSSPackage;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ClassSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ColorTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ElementSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.FuncTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.IdSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.IdentifierTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.NumberTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.PseudoClassFunction;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.PseudoClassName;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.SimpleSelectorForNegation;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.StringTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.SymbolTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.URLType;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.UniversalSelector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.UrlTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.WSTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.charset;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.css_declaration;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.css_property;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.font_face;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.importExpression;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.keyframe_selector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.media;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.page;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ruleset;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.selector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.simple_selector;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.stylesheet;
import org.eclipse.papyrus.infra.gmfdiag.css3.services.CSSGrammarAccess;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider.INodesForEObjectProvider;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class CSSSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private CSSGrammarAccess grammarAccess;

	@Override
	public void createSequence(EObject context, EObject semanticObject) {
		if (semanticObject.eClass().getEPackage() == CSSPackage.eINSTANCE) {
			switch (semanticObject.eClass().getClassifierID()) {
			case CSSPackage.ATTRIBUTE_SELECTOR:
				sequence_AttributeSelector(context, (AttributeSelector) semanticObject);
				return;
			case CSSPackage.CLASS_SELECTOR:
				sequence_ClassSelector(context, (ClassSelector) semanticObject);
				return;
			case CSSPackage.COLOR_TOK:
				sequence_ColorTok(context, (ColorTok) semanticObject);
				return;
			case CSSPackage.ELEMENT_SELECTOR:
				sequence_ElementSelector(context, (ElementSelector) semanticObject);
				return;
			case CSSPackage.FUNC_TOK:
				sequence_IdentifierOrFuncTok(context, (FuncTok) semanticObject);
				return;
			case CSSPackage.ID_SELECTOR:
				sequence_IdSelector(context, (IdSelector) semanticObject);
				return;
			case CSSPackage.IDENTIFIER_TOK:
				sequence_IdentifierOrFuncTok(context, (IdentifierTok) semanticObject);
				return;
			case CSSPackage.NUMBER_TOK:
				sequence_NumberTok(context, (NumberTok) semanticObject);
				return;
			case CSSPackage.PSEUDO_CLASS_FUNCTION:
				sequence_PseudoClassFunction(context, (PseudoClassFunction) semanticObject);
				return;
			case CSSPackage.PSEUDO_CLASS_NAME:
				sequence_PseudoClassName(context, (PseudoClassName) semanticObject);
				return;
			case CSSPackage.SIMPLE_SELECTOR_FOR_NEGATION:
				sequence_SimpleSelectorForNegation(context, (SimpleSelectorForNegation) semanticObject);
				return;
			case CSSPackage.STRING_TOK:
				sequence_StringTok(context, (StringTok) semanticObject);
				return;
			case CSSPackage.SYMBOL_TOK:
				sequence_SymbolTok(context, (SymbolTok) semanticObject);
				return;
			case CSSPackage.URL_TYPE:
				if (context == grammarAccess.getURLTypeRule()) {
					sequence_URLType(context, (URLType) semanticObject);
					return;
				}
				else if (context == grammarAccess.getImportExpressionRule()) {
					sequence_URLType_importExpression(context, (URLType) semanticObject);
					return;
				} else {
					break;
				}
			case CSSPackage.UNIVERSAL_SELECTOR:
				sequence_UniversalSelector(context, (UniversalSelector) semanticObject);
				return;
			case CSSPackage.URL_TOK:
				sequence_UrlTok(context, (UrlTok) semanticObject);
				return;
			case CSSPackage.WS_TOK:
				sequence_WSTok(context, (WSTok) semanticObject);
				return;
			case CSSPackage.CHARSET:
				sequence_charset(context, (charset) semanticObject);
				return;
			case CSSPackage.CSS_DECLARATION:
				sequence_css_declaration(context, (css_declaration) semanticObject);
				return;
			case CSSPackage.CSS_PROPERTY:
				sequence_css_property(context, (css_property) semanticObject);
				return;
			case CSSPackage.FONT_FACE:
				if (context == grammarAccess.getFont_faceRule()) {
					sequence_font_face(context, (font_face) semanticObject);
					return;
				}
				else if (context == grammarAccess.getKeyframesRule()) {
					sequence_keyframes(context, (font_face) semanticObject);
					return;
				} else {
					break;
				}
			case CSSPackage.IMPORT_EXPRESSION:
				sequence_importExpression(context, (importExpression) semanticObject);
				return;
			case CSSPackage.KEYFRAME_SELECTOR:
				sequence_keyframe_selector(context, (keyframe_selector) semanticObject);
				return;
			case CSSPackage.MEDIA:
				sequence_media(context, (media) semanticObject);
				return;
			case CSSPackage.PAGE:
				sequence_page(context, (page) semanticObject);
				return;
			case CSSPackage.RULESET:
				sequence_ruleset(context, (ruleset) semanticObject);
				return;
			case CSSPackage.SELECTOR:
				sequence_selector(context, (selector) semanticObject);
				return;
			case CSSPackage.SIMPLE_SELECTOR:
				sequence_simple_selector(context, (simple_selector) semanticObject);
				return;
			case CSSPackage.STYLESHEET:
				sequence_stylesheet(context, (stylesheet) semanticObject);
				return;
			}
		}
		if (errorAcceptor != null) {
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
		}
	}

	/**
	 * Constraint:
	 * (
	 * name=Identifier
	 * (
	 * (
	 * op='^=' |
	 * op='$=' |
	 * op='*=' |
	 * op='=' |
	 * op=INCLUDES |
	 * op=DASHMATCH
	 * )
	 * (value=Identifier | value=CSSSTRING)
	 * )?
	 * )
	 */
	protected void sequence_AttributeSelector(EObject context, AttributeSelector semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * name=Identifier
	 */
	protected void sequence_ClassSelector(EObject context, ClassSelector semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CSSPackage.Literals.CLASS_SELECTOR__NAME) == ValueTransient.YES) {
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CSSPackage.Literals.CLASS_SELECTOR__NAME));
			}
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getClassSelectorAccess().getNameIdentifierParserRuleCall_2_0(), semanticObject.getName());
		feeder.finish();
	}


	/**
	 * Constraint:
	 * value=Hex
	 */
	protected void sequence_ColorTok(EObject context, ColorTok semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CSSPackage.Literals.COLOR_TOK__VALUE) == ValueTransient.YES) {
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CSSPackage.Literals.COLOR_TOK__VALUE));
			}
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getColorTokAccess().getValueHexParserRuleCall_1_0(), semanticObject.getValue());
		feeder.finish();
	}


	/**
	 * Constraint:
	 * name=Identifier
	 */
	protected void sequence_ElementSelector(EObject context, ElementSelector semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CSSPackage.Literals.ELEMENT_SELECTOR__NAME) == ValueTransient.YES) {
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CSSPackage.Literals.ELEMENT_SELECTOR__NAME));
			}
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getElementSelectorAccess().getNameIdentifierParserRuleCall_1_0(), semanticObject.getName());
		feeder.finish();
	}


	/**
	 * Constraint:
	 * name=Identifier
	 */
	protected void sequence_IdSelector(EObject context, IdSelector semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CSSPackage.Literals.ID_SELECTOR__NAME) == ValueTransient.YES) {
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CSSPackage.Literals.ID_SELECTOR__NAME));
			}
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getIdSelectorAccess().getNameIdentifierParserRuleCall_2_0(), semanticObject.getName());
		feeder.finish();
	}


	/**
	 * Constraint:
	 * (name=IdentifierOrFuncTok_FuncTok_2_0 params+=CssTok+)
	 */
	protected void sequence_IdentifierOrFuncTok(EObject context, FuncTok semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * name=Identifier
	 */
	protected void sequence_IdentifierOrFuncTok(EObject context, IdentifierTok semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CSSPackage.Literals.IDENTIFIER_TOK__NAME) == ValueTransient.YES) {
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CSSPackage.Literals.IDENTIFIER_TOK__NAME));
			}
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getIdentifierOrFuncTokAccess().getNameIdentifierParserRuleCall_1_0(), semanticObject.getName());
		feeder.finish();
	}


	/**
	 * Constraint:
	 * val=Num
	 */
	protected void sequence_NumberTok(EObject context, NumberTok semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CSSPackage.Literals.NUMBER_TOK__VAL) == ValueTransient.YES) {
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CSSPackage.Literals.NUMBER_TOK__VAL));
			}
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getNumberTokAccess().getValNumParserRuleCall_1_0(), semanticObject.getVal());
		feeder.finish();
	}


	/**
	 * Constraint:
	 * ((not?=NotFunctionCall paramSelector=SimpleSelectorForNegation) | (name=Identifier params+=CssTok*))
	 */
	protected void sequence_PseudoClassFunction(EObject context, PseudoClassFunction semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * name=Identifier
	 */
	protected void sequence_PseudoClassName(EObject context, PseudoClassName semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CSSPackage.Literals.PSEUDO_CLASS_NAME__NAME) == ValueTransient.YES) {
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CSSPackage.Literals.PSEUDO_CLASS_NAME__NAME));
			}
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getPseudoClassNameAccess().getNameIdentifierParserRuleCall_0(), semanticObject.getName());
		feeder.finish();
	}


	/**
	 * Constraint:
	 * (((element=ElementSelector | universal=UniversalSelector) subSelectors+=SubSelectorForNegation*) | subSelectors+=SubSelectorForNegation+)
	 */
	protected void sequence_SimpleSelectorForNegation(EObject context, SimpleSelectorForNegation semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * value=CSSSTRING
	 */
	protected void sequence_StringTok(EObject context, StringTok semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CSSPackage.Literals.STRING_TOK__VALUE) == ValueTransient.YES) {
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CSSPackage.Literals.STRING_TOK__VALUE));
			}
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getStringTokAccess().getValueCSSSTRINGTerminalRuleCall_1_0(), semanticObject.getValue());
		feeder.finish();
	}


	/**
	 * Constraint:
	 * (symbol=COMMA | symbol=PERCENT)
	 */
	protected void sequence_SymbolTok(EObject context, SymbolTok semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * url=ValidURL
	 */
	protected void sequence_URLType(EObject context, URLType semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * (url=ValidURL mediaList=media_list?)
	 */
	protected void sequence_URLType_importExpression(EObject context, URLType semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * (namespace=css_namespace_prefix?)
	 */
	protected void sequence_UniversalSelector(EObject context, UniversalSelector semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * url=URLType
	 */
	protected void sequence_UrlTok(EObject context, UrlTok semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CSSPackage.Literals.URL_TOK__URL) == ValueTransient.YES) {
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CSSPackage.Literals.URL_TOK__URL));
			}
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getUrlTokAccess().getUrlURLTypeParserRuleCall_1_0(), semanticObject.getUrl());
		feeder.finish();
	}


	/**
	 * Constraint:
	 * {WSTok}
	 */
	protected void sequence_WSTok(EObject context, WSTok semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * charset=CSSSTRING
	 */
	protected void sequence_charset(EObject context, charset semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CSSPackage.Literals.CHARSET__CHARSET) == ValueTransient.YES) {
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CSSPackage.Literals.CHARSET__CHARSET));
			}
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getCharsetAccess().getCharsetCSSSTRINGTerminalRuleCall_1_0(), semanticObject.getCharset());
		feeder.finish();
	}


	/**
	 * Constraint:
	 * (property=css_property valueTokens+=CssTok+ important?=IMPORTANT_SYM?)
	 */
	protected void sequence_css_declaration(EObject context, css_declaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * name=ValidPropertyIdent
	 */
	protected void sequence_css_property(EObject context, css_property semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CSSPackage.Literals.CSS_PROPERTY__NAME) == ValueTransient.YES) {
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CSSPackage.Literals.CSS_PROPERTY__NAME));
			}
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getCss_propertyAccess().getNameValidPropertyIdentParserRuleCall_1_0(), semanticObject.getName());
		feeder.finish();
	}


	/**
	 * Constraint:
	 * (declarations+=css_declaration? declarations+=css_declaration*)
	 */
	protected void sequence_font_face(EObject context, font_face semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * value=CSSSTRING
	 */
	protected void sequence_importExpression(EObject context, importExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, CSSPackage.Literals.IMPORT_EXPRESSION__VALUE) == ValueTransient.YES) {
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, CSSPackage.Literals.IMPORT_EXPRESSION__VALUE));
			}
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getImportExpressionAccess().getValueCSSSTRINGTerminalRuleCall_1_0_0(), semanticObject.getValue());
		feeder.finish();
	}


	/**
	 * Constraint:
	 * ((type=Identifier | percentage=Num) declarations+=css_declaration? declarations+=css_declaration*)
	 */
	protected void sequence_keyframe_selector(EObject context, keyframe_selector semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * (name=Identifier keyframeselectors+=keyframe_selector? keyframeselectors+=keyframe_selector*)
	 */
	protected void sequence_keyframes(EObject context, font_face semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * (medialist=media_list rulesets+=ruleset*)
	 */
	protected void sequence_media(EObject context, media semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * (pseudoPage=pseudo_page? declarations+=css_declaration? declarations+=css_declaration*)
	 */
	protected void sequence_page(EObject context, page semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * (selectors+=selector selectors+=selector* (declarations+=css_declaration declarations+=css_declaration*)?)
	 */
	protected void sequence_ruleset(EObject context, ruleset semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * (simpleselectors+=simple_selector ((combinator=combinator selector=selector) | (combinator=combinator? selector=selector))?)
	 */
	protected void sequence_selector(EObject context, selector semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * (((element=ElementSelector | universal=UniversalSelector) subSelectors+=SubSelector*) | subSelectors+=SubSelector+)
	 */
	protected void sequence_simple_selector(EObject context, simple_selector semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Constraint:
	 * (charset=charset? imports+=importExpression* (ruleset+=ruleset | media+=media | page+=page | font_face+=font_face | keyframes+=keyframes)*)
	 */
	protected void sequence_stylesheet(EObject context, stylesheet semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
}
