/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.converters;

import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.e4.ui.css.core.dom.properties.converters.AbstractCSSValueConverter;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverterConfig;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.Measure;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.RGBColor;

public class ColorToGMFConverter
extends AbstractCSSValueConverter {
    public static final String GMFColor = "GMFColor";

    public ColorToGMFConverter() {
        super((Object)GMFColor);
    }

    public Object convert(CSSValue value, CSSEngine engine, Object context) throws Exception {
        RGBColor color;
        if (value instanceof RGBColor) {
            color = (RGBColor)((Object)value);
        } else if (value instanceof CSSPrimitiveValue) {
            CSSPrimitiveValue cssValue = (CSSPrimitiveValue)value;
            try {
                int intValue = (int)cssValue.getFloatValue((short)13);
                return intValue;
            }
            catch (Exception exception) {
                color = CSS2ColorHelper.getRGBColor((String)cssValue.getStringValue());
            }
        } else {
            throw new IllegalArgumentException("Cannot convert " + value + " to GMF Color");
        }
        return ColorToGMFConverter.getIntColor(color);
    }

    public String convert(Object value, CSSEngine engine, Object context, ICSSValueConverterConfig config) throws Exception {
        throw new UnsupportedOperationException();
    }

    public static int getIntColor(RGBColor color) {
        int red = ColorToGMFConverter.getInt(color.getRed()) & 0xFF;
        int green = ColorToGMFConverter.getInt(color.getGreen()) & 0xFF;
        int blue = ColorToGMFConverter.getInt(color.getBlue()) & 0xFF;
        return blue << 16 | green << 8 | red;
    }

    public static int getInt(CSSPrimitiveValue value) {
        if (value instanceof Measure) {
            Measure measure = (Measure)value;
            return measure.getIntegerValue((short)1);
        }
        return (int)value.getFloatValue((short)1);
    }

    public static int getIntColor(String value, CSSValue cssValue) {
        RGBColor color = cssValue instanceof RGBColor ? (RGBColor)((Object)cssValue) : CSS2ColorHelper.getRGBColor((String)value);
        if (color == null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }
        return ColorToGMFConverter.getIntColor(color);
    }
}

