/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.notation;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.notation.EObjectListValueStyle;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.impl.DiagramImpl;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.DiagramCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.ForceValueHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.resource.CSSNotationResource;
import org.eclipse.papyrus.infra.gmfdiag.css.style.CSSView;
import org.eclipse.papyrus.infra.gmfdiag.css.style.impl.CSSViewDelegate;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsFactory;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class CSSDiagramImpl
extends DiagramImpl
implements CSSDiagram {
    protected ExtendedCSSEngine engine;
    private CSSView cssView;

    @Override
    public ExtendedCSSEngine getEngine() {
        if (this.engine == null) {
            this.engine = new DiagramCSSEngine(this.getModelEngine(), this);
        }
        return this.engine;
    }

    private void disposeEngine() {
        if (this.engine != null) {
            this.engine.dispose();
            this.engine = null;
        }
    }

    protected void eSetDirectResource(Resource.Internal resource) {
        Resource.Internal oldResource = this.eInternalResource();
        super.eSetDirectResource(resource);
        if (oldResource != resource) {
            this.disposeEngine();
        }
    }

    protected ExtendedCSSEngine getModelEngine() {
        Resource resource = this.eResource();
        return resource == null ? null : CSSNotationResource.getEngine(resource);
    }

    @Override
    public List<StyleSheet> getStyleSheets() {
        LinkedList<StyleSheet> result = new LinkedList<StyleSheet>();
        for (Object styleObject : this.getStyles()) {
            NamedStyle style;
            if (!(styleObject instanceof NamedStyle) || !"css_stylesheets".equals((style = (NamedStyle)styleObject).getName()) || !(style instanceof EObjectListValueStyle)) continue;
            EObjectListValueStyle stylesheetsStyle = (EObjectListValueStyle)style;
            for (Object eObjectValue : stylesheetsStyle.getEObjectListValue()) {
                if (!(eObjectValue instanceof StyleSheet)) continue;
                result.add((StyleSheet)eObjectValue);
            }
        }
        StyleSheet s = this.getViewpointDefinedStylesheet();
        if (s != null) {
            result.add(s);
        }
        return result;
    }

    private StyleSheet getViewpointDefinedStylesheet() {
        ViewPrototype proto = ViewPrototype.get((EObject)this);
        if (proto == null) {
            return null;
        }
        PapyrusView conf = proto.getConfiguration();
        if (conf == null || !(conf instanceof PapyrusDiagram)) {
            return null;
        }
        String path = ((PapyrusDiagram)conf).getCustomStyle();
        if (path == null || path.isEmpty()) {
            return null;
        }
        StyleSheetReference ref = StylesheetsFactory.eINSTANCE.createStyleSheetReference();
        ref.setPath(path);
        return ref;
    }

    protected CSSView getCSSView() {
        if (this.cssView == null) {
            this.cssView = new CSSViewDelegate((View)this, this.getEngine());
        }
        return this.cssView;
    }

    public boolean isVisible() {
        return this.isCSSVisible();
    }

    @Override
    public boolean isCSSVisible() {
        boolean value = super.isVisible();
        if (ForceValueHelper.isSet((View)this, (EStructuralFeature)NotationPackage.eINSTANCE.getView_Visible(), value)) {
            return value;
        }
        return this.getCSSView().isCSSVisible();
    }

    public NamedStyle getNamedStyle(EClass eClass, String name) {
        return this.getCSSNamedStyle(eClass, name);
    }

    @Override
    public NamedStyle getCSSNamedStyle(EClass eClass, String name) {
        NamedStyle userStyle = super.getNamedStyle(eClass, name);
        if (userStyle != null) {
            return userStyle;
        }
        return this.getCSSView().getCSSNamedStyle(eClass, name);
    }

    public Style getStyle(EClass eClass) {
        return this.getCSSStyle(eClass);
    }

    @Override
    public Style getCSSStyle(EClass eClass) {
        Style userStyle = super.getStyle(eClass);
        if (userStyle != null) {
            return userStyle;
        }
        return this.getCSSView().getCSSStyle(eClass);
    }
}

