/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.export.engine;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.core.editor.DiSashModelManagerServiceFactory;
import org.eclipse.papyrus.infra.core.editor.ModelSetServiceFactory;
import org.eclipse.papyrus.infra.core.editor.PageMngrServiceFactory;
import org.eclipse.papyrus.infra.core.resource.EditingDomainServiceFactory;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelsReader;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.service.ILocalPageService;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.DiSashModelManager;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceDescriptor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceMultiException;
import org.eclipse.papyrus.infra.core.services.ServiceStartKind;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.gmfdiag.css.service.CssMarkerEventManagerService;
import org.eclipse.papyrus.infra.gmfdiag.css.service.MarkerToPseudoSelectorMappingService;
import org.eclipse.papyrus.infra.gmfdiag.export.Activator;
import org.eclipse.papyrus.infra.gmfdiag.export.actions.ExportAllDiagramsParameter;
import org.eclipse.papyrus.infra.gmfdiag.export.engine.ExportDiagramLocalPageService;
import org.eclipse.papyrus.infra.gmfdiag.export.messages.Messages;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.markerlistener.MarkersMonitorService;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.papyrus.views.validation.internal.ValidationMarkersService;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ExportAllDiagramsEngine {
    private IWorkbenchWindow workbenchWindow;
    private boolean displayRenamingInformation;
    private static boolean useDisplayRunnable = true;
    private BasicDiagnostic diagnostic = null;
    private boolean hasDuplicates = false;
    private ExportAllDiagramsParameter exportParameter = null;

    public ExportAllDiagramsEngine() {
        try {
            this.workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        catch (IllegalStateException e) {
            this.workbenchWindow = null;
        }
    }

    public void initialise(ExportAllDiagramsParameter parameter) {
        this.diagnostic = new BasicDiagnostic(0, "", 0, Messages.ExportAllDiagrams_18, null);
        this.displayRenamingInformation = true;
        this.exportParameter = parameter;
    }

    public void exportDiagramsToImages() {
        WorkspaceJob job = new WorkspaceJob(Messages.ExportAllDiagrams_0){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                IProgressMonitor newMonitor = monitor;
                return ExportAllDiagramsEngine.this.export(newMonitor);
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private IStatus export(IProgressMonitor newMonitor) {
        IStatus status = Status.OK_STATUS;
        newMonitor.beginTask(Messages.ExportAllDiagrams_1, 10);
        newMonitor.subTask(Messages.ExportAllDiagrams_2);
        if (this.exportParameter != null) {
            ModelSet modelSet = this.exportParameter.getModelSet();
            try {
                if (modelSet == null) {
                    modelSet = this.initialiseModelSet();
                    if (this.diagnostic.getSeverity() != 0 || newMonitor.isCanceled()) {
                        IStatus iStatus = this.handleDiagnosticStatus();
                        return iStatus;
                    }
                    this.initialiseServiceRegistry(modelSet);
                    if (this.diagnostic.getSeverity() != 0 || newMonitor.isCanceled()) {
                        IStatus iStatus = this.handleDiagnosticStatus();
                        return iStatus;
                    }
                }
                IPageManager pageManager = null;
                try {
                    pageManager = ServiceUtilsForResourceSet.getInstance().getIPageManager((Object)modelSet);
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                }
                if (this.diagnostic.getSeverity() != 0 || newMonitor.isCanceled()) {
                    IStatus iStatus = this.handleDiagnosticStatus();
                    return iStatus;
                }
                ExportDiagramLocalPageService service = new ExportDiagramLocalPageService(UmlUtils.getUmlResource((ModelSet)modelSet).getContents().get(0));
                List pagesList = pageManager.allLocalPages((ILocalPageService)service);
                ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
                for (Object page : pagesList) {
                    if (!(page instanceof Diagram)) continue;
                    diagrams.add((Diagram)page);
                }
                if (newMonitor.isCanceled()) {
                    IStatus iStatus = this.handleDiagnosticStatus();
                    return iStatus;
                }
                newMonitor.worked(1);
                this.export((IProgressMonitor)new SubProgressMonitor(newMonitor, 9), diagrams);
            }
            finally {
                if (this.exportParameter.getModelSet() == null) {
                    modelSet.unload();
                }
            }
        }
        status = new Status(4, "org.eclipse.papyrus.infra.gmfdiag.export", Messages.ExportAllDiagrams_17);
        return status;
    }

    private IStatus handleDiagnosticStatus() {
        this.diagnostic.recomputeSeverity();
        return BasicDiagnostic.toIStatus((Diagnostic)this.diagnostic);
    }

    private ModelSet initialiseModelSet() {
        ServicesRegistry service = new ServicesRegistry();
        ServiceDescriptor descriptor = new ServiceDescriptor(ModelSet.class, ModelSetServiceFactory.class.getName(), ServiceStartKind.STARTUP, 10);
        descriptor.setServiceTypeKind(ServiceDescriptor.ServiceTypeKind.serviceFactory);
        service.add(descriptor);
        descriptor = new ServiceDescriptor(TransactionalEditingDomain.class, EditingDomainServiceFactory.class.getName(), ServiceStartKind.STARTUP, 10, Collections.singletonList(ModelSet.class.getName()));
        descriptor.setServiceTypeKind(ServiceDescriptor.ServiceTypeKind.serviceFactory);
        service.add(descriptor);
        try {
            service.startRegistry();
        }
        catch (ServiceMultiException e) {
            Activator.log.error((Throwable)e);
        }
        ModelSet modelSet = null;
        try {
            modelSet = ServiceUtils.getInstance().getModelSet((Object)service);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (modelSet == null) {
            modelSet = new ModelSet();
            try {
                ModelSetServiceFactory.setServiceRegistry((ResourceSet)modelSet, (ServicesRegistry)service);
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        ModelsReader modelsReader = new ModelsReader();
        modelsReader.readModel(modelSet);
        try {
            modelSet.loadModels(this.exportParameter.getDiFileUri());
        }
        catch (ModelMultiException e) {
            this.diagnostic = new BasicDiagnostic(4, "org.eclipse.papyrus.infra.gmfdiag.export", 0, Messages.ExportAllDiagrams_3, new Object[]{e});
        }
        modelSet.getTransactionalEditingDomain();
        return modelSet;
    }

    private void initialiseServiceRegistry(ModelSet modelSet) {
        ServicesRegistry service = ModelSetServiceFactory.getServiceRegistry((ResourceSet)modelSet);
        try {
            if (service == null) {
                service = new ServicesRegistry();
                this.addModelSetServices(modelSet, service);
                service.startRegistry();
            }
            this.addCSSServices(service);
            service.startRegistry();
            this.addModelerServices(service);
            service.startRegistry();
        }
        catch (ServiceException e) {
            this.diagnostic = new BasicDiagnostic(4, "org.eclipse.papyrus.infra.gmfdiag.export", 0, "Failed to load models", new Object[]{e});
        }
    }

    private void addModelSetServices(ModelSet modelSet, ServicesRegistry service) {
        service.add(ModelSet.class, 10, (Object)modelSet);
        ServiceDescriptor descriptor = new ServiceDescriptor(TransactionalEditingDomain.class, EditingDomainServiceFactory.class.getName(), ServiceStartKind.STARTUP, 10, Collections.singletonList(ModelSet.class.getName()));
        descriptor.setServiceTypeKind(ServiceDescriptor.ServiceTypeKind.serviceFactory);
        service.add(descriptor);
    }

    private void addModelerServices(ServicesRegistry service) {
        ServiceDescriptor descriptor = new ServiceDescriptor(DiSashModelManager.class, DiSashModelManagerServiceFactory.class.getName(), ServiceStartKind.STARTUP, 10, Collections.singletonList(TransactionalEditingDomain.class.getName()));
        descriptor.setServiceTypeKind(ServiceDescriptor.ServiceTypeKind.serviceFactory);
        service.add(descriptor);
        descriptor = new ServiceDescriptor(IPageManager.class, PageMngrServiceFactory.class.getName(), ServiceStartKind.STARTUP, 10, Collections.singletonList(DiSashModelManager.class.getName()));
        descriptor.setServiceTypeKind(ServiceDescriptor.ServiceTypeKind.serviceFactory);
        service.add(descriptor);
    }

    private void addCSSServices(ServicesRegistry service) {
        service.add(MarkersMonitorService.class, 10, (IService)new MarkersMonitorService());
        service.add(CssMarkerEventManagerService.class, 10, (IService)new CssMarkerEventManagerService());
        service.add(MarkerToPseudoSelectorMappingService.class, 10, (IService)new MarkerToPseudoSelectorMappingService());
        service.add(ValidationMarkersService.class, 10, (IService)new ValidationMarkersService());
        service.add(DecorationService.class, 10, (IService)new DecorationService());
    }

    public void export(IProgressMonitor newMonitor, List<Diagram> diagrams) {
        this.setHaveDuplicates(false);
        int tasksAmount = 9;
        if (this.exportParameter.getModelSet() == null) {
            ++tasksAmount;
        }
        newMonitor.beginTask(Messages.ExportAllDiagrams_4, tasksAmount);
        this.createDiagramFiles((IProgressMonitor)new SubProgressMonitor(newMonitor, 9), diagrams);
        if (this.exportParameter.getModelSet() == null) {
            this.unloadResources((IProgressMonitor)new SubProgressMonitor(newMonitor, 1), diagrams);
        }
        if (this.haveDuplicates() && this.displayRenamingInformation) {
            String message = Messages.ExportAllDiagrams_5;
            if (this.workbenchWindow != null && this.workbenchWindow.getShell() != null) {
                BasicDiagnostic newDiagnostic = new BasicDiagnostic(2, "", 0, message, null);
                this.diagnostic.add((Diagnostic)newDiagnostic);
            } else {
                Activator.log.info(message);
            }
        }
        this.handleExportDiagnostic();
    }

    private void handleExportDiagnostic() {
        int severity = this.diagnostic.recomputeSeverity();
        if (severity == 4) {
            BasicDiagnostic oldDiagnostic = this.diagnostic;
            this.diagnostic = new BasicDiagnostic(4, "", 0, Messages.ExportAllDiagrams_22, null);
            this.diagnostic.addAll((Diagnostic)oldDiagnostic);
        } else if (severity == 2) {
            BasicDiagnostic oldDiagnostic = this.diagnostic;
            this.diagnostic = new BasicDiagnostic(2, "", 0, Messages.ExportAllDiagrams_24, null);
            this.diagnostic.addAll((Diagnostic)oldDiagnostic);
        }
        if (this.workbenchWindow != null && this.workbenchWindow.getShell() != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (ExportAllDiagramsEngine.this.diagnostic.getSeverity() == 0) {
                        MessageDialog.openInformation((Shell)Activator.getActiveWorkbenchShell(), (String)Messages.ExportAllDiagrams_25, (String)(String.valueOf(Messages.ExportAllDiagrams_26) + ExportAllDiagramsEngine.this.exportParameter.getOutputDirectoryPath()));
                    } else {
                        DiagnosticDialog.open((Shell)Activator.getActiveWorkbenchShell(), (String)Messages.ExportAllDiagrams_27, (String)"", (Diagnostic)ExportAllDiagramsEngine.this.diagnostic);
                    }
                }
            });
        }
    }

    private void createDiagramFiles(final IProgressMonitor newMonitor, List<Diagram> diagrams) {
        try {
            ArrayList<String> diagramNames = new ArrayList<String>();
            try {
                newMonitor.beginTask(Messages.ExportAllDiagrams_7, diagrams.size());
                for (final Diagram diagram : diagrams) {
                    if (!newMonitor.isCanceled()) {
                        String uniqueFileName;
                        final String finalUniqueFileName = uniqueFileName = this.handleFileName(diagram, diagramNames);
                        diagramNames.add(uniqueFileName);
                        newMonitor.subTask(uniqueFileName);
                        if (useDisplayRunnable) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ExportAllDiagramsEngine.this.exportDiagram(finalUniqueFileName, diagram, newMonitor);
                                }
                            });
                        } else {
                            this.exportDiagram(uniqueFileName, diagram, newMonitor);
                        }
                        newMonitor.worked(1);
                        continue;
                    }
                    break;
                }
            }
            catch (SWTError e) {
                String message = Messages.ExportAllDiagrams_9;
                Activator.log.error(message, (Throwable)new Exception(message, e));
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    private String handleFileName(Diagram diagram, List<String> diagramNames) {
        String uniqueFileName;
        boolean nameCut = false;
        String label = "";
        if (this.exportParameter.isQualifiedName()) {
            ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            composedAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
            try {
                IItemLabelProvider itemLabelFactory = (IItemLabelProvider)composedAdapterFactory.adapt((Notifier)diagram.getElement(), IItemLabelProvider.class);
                label = String.valueOf(itemLabelFactory.getText((Object)diagram.getElement()).replace(Messages.ExportAllDiagrams_16, "")) + "_";
            }
            finally {
                composedAdapterFactory.dispose();
            }
        }
        if ((uniqueFileName = this.encodeFileName(String.valueOf(label) + diagram.getName())).length() > 150) {
            nameCut = true;
            uniqueFileName = uniqueFileName.substring(0, 150);
        }
        if (diagramNames.contains(uniqueFileName)) {
            this.setHaveDuplicates(true);
            uniqueFileName = this.getFirstAvailableName(uniqueFileName, diagramNames, 1);
        }
        if (nameCut) {
            BasicDiagnostic newDiagnostic = new BasicDiagnostic(2, "", 0, String.valueOf(Messages.ExportAllDiagrams_10) + uniqueFileName, null);
            this.diagnostic.add((Diagnostic)newDiagnostic);
        }
        return uniqueFileName;
    }

    private void setHaveDuplicates(boolean duplicates) {
        this.hasDuplicates = duplicates;
    }

    private boolean haveDuplicates() {
        return this.hasDuplicates;
    }

    private void exportDiagram(String uniqueFileName, Diagram diagram, IProgressMonitor newMonitor) {
        CopyToImageUtil copyImageUtil = new CopyToImageUtil();
        Path imagePath = new Path(String.valueOf(this.exportParameter.getOutputDirectoryPath()) + File.separator + uniqueFileName);
        imagePath = imagePath.addFileExtension(this.exportParameter.getExportFormat().getName());
        try {
            copyImageUtil.copyToImage(diagram, (IPath)imagePath, this.exportParameter.getExportFormat(), (IProgressMonitor)new SubProgressMonitor(newMonitor, 1), PreferencesHint.USE_DEFAULTS);
        }
        catch (Throwable e) {
            BasicDiagnostic newDiagnostic = new BasicDiagnostic(4, "", 0, String.format(Messages.ExportAllDiagrams_11, uniqueFileName, diagram.eResource().getURI().toString()), null);
            this.diagnostic.add((Diagnostic)newDiagnostic);
            String errorMessage = String.format(Messages.ExportAllDiagrams_11, uniqueFileName, diagram.eResource().getURI().toString());
            Activator.log.error(errorMessage, e);
        }
    }

    public void unloadResources(IProgressMonitor newMonitor, List<Diagram> diagrams) {
        if (newMonitor == null) {
            newMonitor = new NullProgressMonitor();
        }
        newMonitor.subTask(Messages.ExportAllDiagrams_12);
        if (diagrams != null && !diagrams.isEmpty()) {
            ResourceSet diagramResourceSet = diagrams.get(0).eResource().getResourceSet();
            newMonitor.beginTask(Messages.ExportAllDiagrams_13, diagramResourceSet.getResources().size());
            int i = diagramResourceSet.getResources().size() - 1;
            while (i >= 0) {
                try {
                    Resource resource = (Resource)diagramResourceSet.getResources().get(i);
                    if (resource.isLoaded()) {
                        resource.unload();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                newMonitor.worked(1);
                --i;
            }
        }
    }

    private String encodeFileName(String pathName) {
        pathName = pathName.trim();
        pathName = pathName.replaceAll(Messages.ExportAllDiagrams_14, Messages.ExportAllDiagrams_15);
        pathName = pathName.replaceAll("_-_", "-");
        while (pathName.contains("__")) {
            pathName = pathName.replaceAll("__", "_");
        }
        if (pathName.startsWith("_")) {
            pathName = pathName.replaceFirst("_", "");
        }
        if (pathName.endsWith("_")) {
            pathName = pathName.substring(0, pathName.length() - 1);
        }
        return pathName;
    }

    private String getFirstAvailableName(String commonBasis, List<String> existingNames, int cpt) {
        if (existingNames.contains(String.valueOf(commonBasis) + cpt)) {
            return this.getFirstAvailableName(commonBasis, existingNames, cpt + 1);
        }
        return String.valueOf(commonBasis) + cpt;
    }
}

