/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.editpolicies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.INonDirtying;
import org.eclipse.papyrus.commands.util.NonDirtyingUtils;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.Activator;
import org.eclipse.papyrus.infra.gmfdiag.navigation.ExistingNavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.NavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.NavigationHelper;
import org.eclipse.papyrus.infra.hyperlink.helper.HyperLinkHelperFactory;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkEditor;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.EditorNavigationDialog;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkHelpersRegistrationUtil;

public class NavigationEditPolicy
extends OpenEditPolicy {
    public static final String NAVIGATION_POLICY = "NavigationEditPolicy";

    protected Command getOpenCommand(Request request) {
        Command openCommand = this.getHyperlinkOpenCommand(request);
        if (openCommand == null || !openCommand.canExecute()) {
            openCommand = this.getShortCutOpenCommand(request);
        }
        return openCommand;
    }

    protected Command getHyperlinkOpenCommand(Request request) {
        IGraphicalEditPart gep = (IGraphicalEditPart)this.getHost() instanceof CompartmentEditPart ? (IGraphicalEditPart)this.getHost().getParent() : (IGraphicalEditPart)this.getHost();
        EObject semanticElement = gep.resolveSemanticElement();
        List navElements = null;
        ArrayList<Object> defaultHyperLinkObject = new ArrayList<Object>();
        HashMap<NavigableElement, List> existingDiagrams = new HashMap<NavigableElement, List>();
        if (semanticElement == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ArrayList hyperLinkHelpers = new ArrayList();
        hyperLinkHelpers.addAll(HyperLinkHelpersRegistrationUtil.INSTANCE.getAllRegisteredHyperLinkHelper());
        HyperLinkHelperFactory hyperlinkHelperFactory = new HyperLinkHelperFactory(hyperLinkHelpers);
        try {
            ArrayList hyperLinkObjectList = hyperlinkHelperFactory.getAllreferenced((EModelElement)gep.getNotationView());
            for (HyperLinkObject hyperlinkObject : hyperLinkObjectList) {
                if (!hyperlinkObject.getIsDefault()) continue;
                defaultHyperLinkObject.add(hyperlinkObject);
            }
            navElements = NavigationHelper.getInstance().getAllNavigableElements(semanticElement);
            HashMap possibleCreations = new HashMap();
            String navigationKind = Activator.getDefault().getPreferenceStore().getString("PAPYRUS_NAVIGATION_DOUBLECLICK_KIND");
            if (navigationKind.equals("NO_NAVIGATION")) {
                return UnexecutableCommand.INSTANCE;
            }
            if (navigationKind.equals("EXPLICIT_IMPLICIT_NAVIGATION")) {
                for (NavigableElement navElement : navElements) {
                    EObject element = navElement.getElement();
                    if (!(navElement instanceof ExistingNavigableElement)) continue;
                    List associatedDiagrams = DiagramUtils.getAssociatedDiagrams((EObject)element, null);
                    associatedDiagrams.remove(gep.getNotationView().getDiagram());
                    if (associatedDiagrams == null || associatedDiagrams.isEmpty()) continue;
                    existingDiagrams.put(navElement, associatedDiagrams);
                }
                for (List list : existingDiagrams.values()) {
                    for (Diagram diagram : list) {
                        HyperLinkEditor hyperLinkEditor = new HyperLinkEditor();
                        hyperLinkEditor.setObject((Object)diagram);
                        hyperLinkEditor.setTooltipText(String.valueOf(diagram.getName()) + " (found by heuristic)");
                        HyperLinkObject foundHyperlink = null;
                        int i = 0;
                        while (i < defaultHyperLinkObject.size() && foundHyperlink == null) {
                            if (((HyperLinkObject)defaultHyperLinkObject.get(i)).getObject().equals(diagram)) {
                                foundHyperlink = (HyperLinkObject)defaultHyperLinkObject.get(i);
                            }
                            ++i;
                        }
                        if (foundHyperlink != null) continue;
                        defaultHyperLinkObject.add(hyperLinkEditor);
                    }
                }
            }
            if (defaultHyperLinkObject.size() == 1) {
                HyperLinkObject hyperlinkObject = (HyperLinkObject)defaultHyperLinkObject.get(0);
                class NavigateHyperlinkCommand
                extends Command
                implements INonDirtying {
                    private ICommand openLinkCommand;
                    private final /* synthetic */ HyperLinkObject val$hyperlinkObject;

                    NavigateHyperlinkCommand(HyperLinkObject hyperLinkObject) {
                        this.val$hyperlinkObject = hyperLinkObject;
                        super("Navigate hyperlink");
                    }

                    public void execute() {
                        if (this.val$hyperlinkObject.needsOpenCommand()) {
                            try {
                                TransactionalEditingDomain editingDomain = ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain((Object)NavigationEditPolicy.this.getHost());
                                this.openLinkCommand = new OpenCommand(editingDomain, this.val$hyperlinkObject);
                                this.openLinkCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                            }
                            catch (ServiceException ex) {
                                Activator.log.error((Throwable)ex);
                            }
                            catch (ExecutionException ex) {
                                Activator.log.error((Throwable)ex);
                            }
                        } else {
                            this.val$hyperlinkObject.openLink();
                        }
                    }

                    public void undo() {
                        if (this.openLinkCommand != null && this.openLinkCommand.canUndo()) {
                            try {
                                this.openLinkCommand.undo((IProgressMonitor)new NullProgressMonitor(), null);
                            }
                            catch (ExecutionException ex) {
                                Activator.log.error((Throwable)ex);
                            }
                        }
                    }

                    public void redo() {
                        if (this.openLinkCommand != null && this.openLinkCommand.canRedo()) {
                            try {
                                this.openLinkCommand.redo((IProgressMonitor)new NullProgressMonitor(), null);
                            }
                            catch (ExecutionException ex) {
                                Activator.log.error((Throwable)ex);
                            }
                        }
                    }

                    public void dispose() {
                        if (this.openLinkCommand != null) {
                            this.openLinkCommand.dispose();
                            this.openLinkCommand = null;
                        }
                        super.dispose();
                    }
                }
                return new NavigateHyperlinkCommand(hyperlinkObject);
            }
            if (defaultHyperLinkObject.size() > 1) {
                EditorNavigationDialog diagramNavigationDialog = new EditorNavigationDialog(this.getHost().getViewer().getControl().getShell(), defaultHyperLinkObject, semanticElement);
                diagramNavigationDialog.open();
                List hList = diagramNavigationDialog.getSelectedHyperlinks();
                class NavigateHyperlinksCommand
                extends Command
                implements INonDirtying {
                    private CompositeCommand openLinksCommand;
                    private final /* synthetic */ List val$hList;

                    NavigateHyperlinksCommand(List list) {
                        this.val$hList = list;
                        super("Navigate hyperlinks");
                    }

                    public void execute() {
                        Iterator iter = this.val$hList.iterator();
                        this.openLinksCommand = NonDirtyingUtils.nonDirtyingGMFComposite((String)"Navigate hyperlinks");
                        try {
                            TransactionalEditingDomain editingDomain = ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain((Object)NavigationEditPolicy.this.getHost());
                            while (iter.hasNext()) {
                                HyperLinkObject hyperlinkObject = (HyperLinkObject)iter.next();
                                if (hyperlinkObject.needsOpenCommand()) {
                                    this.openLinksCommand.add((IUndoableOperation)new OpenCommand(editingDomain, hyperlinkObject));
                                    continue;
                                }
                                hyperlinkObject.openLink();
                            }
                            if (this.openLinksCommand.isEmpty()) {
                                return;
                            }
                            this.openLinksCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                        }
                        catch (ServiceException ex) {
                            Activator.log.error((Throwable)ex);
                        }
                        catch (ExecutionException ex) {
                            Activator.log.error((Throwable)ex);
                        }
                    }

                    public void undo() {
                        if (this.openLinksCommand != null && this.openLinksCommand.canUndo()) {
                            try {
                                this.openLinksCommand.undo((IProgressMonitor)new NullProgressMonitor(), null);
                            }
                            catch (ExecutionException ex) {
                                Activator.log.error((Throwable)ex);
                            }
                        }
                    }

                    public void redo() {
                        if (this.openLinksCommand != null && this.openLinksCommand.canRedo()) {
                            try {
                                this.openLinksCommand.redo((IProgressMonitor)new NullProgressMonitor(), null);
                            }
                            catch (ExecutionException ex) {
                                Activator.log.error((Throwable)ex);
                            }
                        }
                    }
                }
                return new NavigateHyperlinksCommand(hList);
            }
        }
        catch (Exception e) {
            Activator.log.error("Impossible to load hyperlinks", (Throwable)e);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected IPageIconsRegistry createEditorRegistry() {
        try {
            return (IPageIconsRegistry)ServiceUtilsForEditPart.getInstance().getService(IPageIconsRegistry.class, (Object)this.getHost());
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
    }

    protected Command getShortCutOpenCommand(Request request) {
        EObject element;
        IGraphicalEditPart host = (IGraphicalEditPart)this.getHost();
        View view = host.getNotationView();
        EObject eObject = element = view == null ? null : view.getElement();
        if (element instanceof Diagram && element.eResource() != null) {
            OpenDiagramCommand openDiagramCommand = new OpenDiagramCommand(host.getEditingDomain(), (Diagram)element);
            return new ICommandProxy((ICommand)openDiagramCommand);
        }
        return UnexecutableCommand.INSTANCE;
    }

    class OpenCommand
    extends AbstractTransactionalCommand
    implements INonDirtying {
        private final HyperLinkObject hyperlinkObject;

        OpenCommand(TransactionalEditingDomain editingDomain, HyperLinkObject hyperlinkObject) {
            super(editingDomain, "Navigate hyperlink", null);
            this.hyperlinkObject = hyperlinkObject;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.hyperlinkObject.openLink();
            return CommandResult.newOKCommandResult();
        }
    }

    private static class OpenDiagramCommand
    extends AbstractTransactionalCommand {
        private Diagram diagramToOpen = null;

        public OpenDiagramCommand(TransactionalEditingDomain domain, Diagram diagram) {
            super(domain, "open diagram", null);
            this.diagramToOpen = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                IPageManager pageMngr = ServiceUtilsForEObject.getInstance().getIPageManager((Object)this.diagramToOpen);
                if (pageMngr.isOpen((Object)this.diagramToOpen)) {
                    pageMngr.selectPage((Object)this.diagramToOpen);
                } else {
                    pageMngr.openPage((Object)this.diagramToOpen);
                }
                return CommandResult.newOKCommandResult();
            }
            catch (Exception e) {
                throw new ExecutionException("Can't open diagram", (Throwable)e);
            }
        }
    }
}

