/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.hyperlink.navigation;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.navigation.DiagramNavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationContributor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramNavigationProvider
implements NavigationContributor {
    public List<NavigableElement> getNavigableElements(Object fromElement) {
        if (fromElement != null) {
            LinkedList<NavigableElement> navigableElements = new LinkedList<NavigableElement>();
            for (Diagram diagram : this.getOwnedDiagrams(fromElement)) {
                navigableElements.add(new DiagramNavigableElement(diagram));
            }
            return navigableElements;
        }
        return Collections.emptyList();
    }

    protected List<Diagram> getOwnedDiagrams(Object fromElement) {
        EObject eObject = EMFHelper.getEObject((Object)fromElement);
        View currentView = NotationHelper.findView((Object)fromElement);
        if (eObject instanceof View || eObject == null) {
            return Collections.emptyList();
        }
        try {
            LinkedList<Diagram> ownedDiagrams = new LinkedList<Diagram>();
            IPageManager pageManager = ServiceUtilsForEObject.getInstance().getIPageManager((Object)eObject);
            for (Object pageObject : pageManager.allPages()) {
                if (!(pageObject instanceof Diagram)) continue;
                Diagram diagram = (Diagram)pageObject;
                if (currentView != null && currentView.getDiagram() == diagram || diagram.getElement() != eObject) continue;
                ownedDiagrams.add(diagram);
            }
            return ownedDiagrams;
        }
        catch (ServiceException ex) {
            return Collections.emptyList();
        }
    }
}

