/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.menu.utils;

import com.google.common.base.Optional;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler2;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.readonly.ReadOnlyManager;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeleteActionUtil {
    private DeleteActionUtil() {
    }

    public static boolean isSemanticDeletion(IGraphicalEditPart editPart) {
        boolean isSemanticDeletion = false;
        TransactionalEditingDomain editingDomain = null;
        try {
            editingDomain = ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain((Object)editPart);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (editingDomain != null) {
            IReadOnlyHandler2 readOnly = ReadOnlyManager.getReadOnlyHandler((EditingDomain)editingDomain);
            EObject semantic = EMFHelper.getEObject((Object)editPart);
            View graphical = NotationHelper.findView((Object)editPart);
            boolean bl = isSemanticDeletion = semantic != null && semantic != graphical && semantic.eContainer() != null;
            if (isSemanticDeletion && readOnly != null) {
                Optional result = readOnly.isReadOnly(ReadOnlyAxis.anyAxis(), semantic);
                if (!((Boolean)result.or((Object)false)).booleanValue() && graphical != null) {
                    result = readOnly.isReadOnly(ReadOnlyAxis.anyAxis(), (EObject)graphical);
                }
                isSemanticDeletion = (Boolean)result.or((Object)false) == false;
            }
        }
        return isSemanticDeletion;
    }

    public static boolean isReadOnly(IGraphicalEditPart editPart) {
        boolean isReadOnly = true;
        TransactionalEditingDomain editingDomain = null;
        try {
            editingDomain = ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain((Object)editPart);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (editingDomain != null) {
            Optional result;
            IReadOnlyHandler2 readOnly = ReadOnlyManager.getReadOnlyHandler((EditingDomain)editingDomain);
            EObject semantic = EMFHelper.getEObject((Object)editPart);
            View graphical = NotationHelper.findView((Object)editPart);
            if (readOnly != null && semantic != null && !(isReadOnly = ((Boolean)(result = readOnly.isReadOnly(ReadOnlyAxis.anyAxis(), semantic)).get()).booleanValue()) && graphical != null) {
                result = readOnly.isReadOnly(ReadOnlyAxis.anyAxis(), (EObject)graphical);
                isReadOnly = (Boolean)result.get();
            }
        }
        return isReadOnly;
    }

    public static Command getDeleteFromModelCommand(IGraphicalEditPart editPart, TransactionalEditingDomain editingDomain) {
        return editPart.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)new DestroyElementRequest(false)));
    }

    public static Command getDeleteFromDiagramCommand(IGraphicalEditPart editPart) {
        return editPart.getCommand((Request)new GroupRequest((Object)"delete"));
    }

    public static boolean isCanonical(List<IGraphicalEditPart> editParts) {
        boolean isCanonical = false;
        if (!editParts.isEmpty()) {
            Iterator<IGraphicalEditPart> si = editParts.iterator();
            while (si.hasNext() && !isCanonical) {
                IGraphicalEditPart child = si.next();
                isCanonical = DeleteActionUtil.isCanonicalView(child);
                if (!isCanonical) continue;
                isCanonical = DeleteActionUtil.isCanonicalEditPart(child);
            }
        }
        return isCanonical;
    }

    public static boolean isCanonicalEditPart(IGraphicalEditPart editPart) {
        ConnectionEditPart connection;
        boolean isCanonical = false;
        isCanonical = editPart instanceof ConnectionEditPart ? !(connection = (ConnectionEditPart)editPart).isSemanticConnection() || DeleteActionUtil.isCanonical(connection.getSource()) && DeleteActionUtil.isCanonical(connection.getTarget()) : DeleteActionUtil.isCanonical((EditPart)editPart);
        return isCanonical;
    }

    public static boolean isSupportView(List<IGraphicalEditPart> editParts) {
        boolean isSupportted = true;
        Iterator<IGraphicalEditPart> iter = editParts.iterator();
        while (isSupportted && iter.hasNext()) {
            IGraphicalEditPart object = iter.next();
            isSupportted = DeleteActionUtil.isSupportView(object);
        }
        return isSupportted;
    }

    public static boolean isSupportView(IGraphicalEditPart object) {
        return !(object instanceof GraphicalEditPart) || ((GraphicalEditPart)object).hasNotationView();
    }

    public static boolean isCanonicalView(IGraphicalEditPart editpart) {
        View view = (View)editpart.getAdapter(View.class);
        boolean canonicalView = true;
        if (view != null) {
            canonicalView = !(view.getElement() instanceof View);
        }
        return canonicalView;
    }

    public static boolean isCanonical(EditPart editPart) {
        boolean isCanonical = false;
        EObject eObject = EMFHelper.getEObject((Object)editPart);
        EditPart parent = editPart.getParent();
        if (eObject != null && parent != null) {
            CanonicalEditPolicy canonicalEditPolicy = (CanonicalEditPolicy)parent.getEditPolicy((Object)"Canonical");
            isCanonical = canonicalEditPolicy != null && canonicalEditPolicy.isEnabled() && canonicalEditPolicy.canCreate(eObject);
        }
        return isCanonical;
    }
}

