/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.preferences.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractGroup
extends Composite {
    private String key;
    private Set<FieldEditor> fieldsEditor;
    protected DialogPage dialogPage;

    protected DialogPage getDialogPage() {
        return this.dialogPage;
    }

    public String getKey() {
        return this.key;
    }

    protected void setKey(String title) {
        this.key = title;
    }

    public AbstractGroup(Composite parent, String key, DialogPage dialogPage) {
        super(parent, 0);
        this.key = key;
        this.dialogPage = dialogPage;
        this.setLayout((Layout)new GridLayout());
        this.fieldsEditor = new HashSet<FieldEditor>();
    }

    protected String getPreferenceConstant(int preferenceType) {
        return PreferencesConstantsHelper.getElementConstant((String)this.key, (int)preferenceType);
    }

    protected final Composite getEncapsulatedCompo(Composite parent) {
        Composite compo = new Composite(parent, 0);
        compo.setLayout((Layout)new GridLayout());
        return compo;
    }

    protected void addFieldEditor(FieldEditor fieldEditor) {
        this.fieldsEditor.add(fieldEditor);
    }

    public void load() {
        for (FieldEditor fe : this.fieldsEditor) {
            fe.load();
        }
    }

    public final void setPreferenceStore(IPreferenceStore store) {
        for (FieldEditor fe : this.fieldsEditor) {
            fe.setPreferenceStore(store);
        }
    }

    public final void loadDefault() {
        for (FieldEditor fe : this.fieldsEditor) {
            fe.loadDefault();
        }
    }

    public final void storePreferences() {
        for (FieldEditor fe : this.fieldsEditor) {
            fe.store();
        }
    }
}

