/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.databinding;

import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public abstract class AbstractDiagramPreferencesObservableValue
extends AbstractObservableValue {
    private String preferenceName;
    private IPreferenceStore editedPreferenceStore;
    private IPropertyChangeListener listener;

    public AbstractDiagramPreferencesObservableValue(Diagram diagram, String preferenceName, IPreferenceStore editedPreferenceStore) {
        this.preferenceName = preferenceName;
        this.editedPreferenceStore = editedPreferenceStore;
        this.listener = new IPropertyChangeListener(){

            public void propertyChange(final PropertyChangeEvent event) {
                if (AbstractDiagramPreferencesObservableValue.this.getEditedPreference().equals(event.getProperty())) {
                    ValueDiff diff = new ValueDiff(){

                        public Object getOldValue() {
                            return event.getOldValue();
                        }

                        public Object getNewValue() {
                            return event.getNewValue();
                        }
                    };
                    AbstractDiagramPreferencesObservableValue.this.fireValueChange(diff);
                }
            }
        };
        this.editedPreferenceStore.addPropertyChangeListener(this.listener);
    }

    public synchronized void dispose() {
        super.dispose();
        this.editedPreferenceStore.removePropertyChangeListener(this.listener);
    }

    public final String getEditedPreference() {
        return this.preferenceName;
    }

    public final IPreferenceStore getEditedPreferenceStore() {
        return this.editedPreferenceStore;
    }
}

