/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.modelelement;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.properties.Activator;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.GradientDataObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.properties.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.views.properties.modelelement.AbstractModelElement;

public class GradientDataModelElement
extends AbstractModelElement {
    private static final String PROPERTY_PATH = "gradientStyle";
    protected GradientData sourceElement;
    protected EObject owner;

    public GradientDataModelElement(GradientData sourceElement, EObject owner) {
        this.sourceElement = sourceElement;
        this.owner = owner;
    }

    public GradientDataModelElement(GradientData sourceElement) {
        this(sourceElement, null);
    }

    public IObservable doGetObservable(String propertyPath) {
        return new GradientDataObservableValue(this.sourceElement, propertyPath);
    }

    public boolean isMandatory(String propertyPath) {
        return true;
    }

    public boolean isEditable(String propertyPath) {
        return this.owner == null || !EMFHelper.isReadOnly((EObject)this.owner);
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        if (propertyPath.equals(PROPERTY_PATH)) {
            return new AbstractStaticContentProvider(){

                public Object[] getElements() {
                    return new Integer[]{0, 1};
                }
            };
        }
        return null;
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        if (propertyPath.equals(PROPERTY_PATH)) {
            return new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Integer) {
                        int value = (Integer)element;
                        if (value == 0) {
                            return Messages.GradientDataModelElement_Vertical;
                        }
                        return Messages.GradientDataModelElement_Horizontal;
                    }
                    return null;
                }
            };
        }
        return null;
    }

    public Object getDefaultValue(String propertyPath) {
        GradientDataObservableValue.GradientProperty property = GradientDataObservableValue.GradientProperty.valueOf(propertyPath);
        switch (property) {
            case activate: {
                return false;
            }
            case gradientColor1: {
                return GradientData.getDefaultGradientData().getGradientColor1();
            }
            case gradientColor2: {
                return GradientData.getDefaultGradientData().getGradientColor2();
            }
            case gradientStyle: {
                return GradientData.getDefaultGradientData().getGradientStyle();
            }
        }
        Activator.log.warn("Cannot find a default value for property : " + propertyPath);
        return null;
    }
}

