/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.helper.EditorHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkEditor;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractEditHyperlinkDocumentShell;
import org.eclipse.papyrus.infra.hyperlink.ui.EditorLookForEditorShell;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;

public class EditorHyperLinkEditorShell
extends AbstractEditHyperlinkDocumentShell {
    protected boolean usedefaultTooltip = true;
    protected HyperLinkEditor hyperLinkEditor;
    private IPageIconsRegistry editorRegistry;
    protected final EObject amodel;

    public void open() {
        Display display = Display.getCurrent();
        this.getEditHyperlinkShell().pack();
        this.getEditHyperlinkShell().open();
        while (!this.getEditHyperlinkShell().isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public EditorHyperLinkEditorShell(IPageIconsRegistry editorFactoryRegistry, EObject model) {
        this.amodel = model;
        this.editorRegistry = editorFactoryRegistry;
        this.createEditHyperlinkShell();
        this.getObjectcLabel().setText(Messages.EditorHyperLinkEditorShell_View);
        this.getUseDefaultCheckBox().setSelection(this.usedefaultTooltip);
        this.getObjectLabeltext().setEditable(false);
        if (this.usedefaultTooltip) {
            this.getTooltipInputText().setEditable(false);
            this.getTooltipInputText().setText(this.getObjectLabeltext().getText());
        }
        this.getUseDefaultCheckBox().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorHyperLinkEditorShell.this.usedefaultTooltip = EditorHyperLinkEditorShell.this.getUseDefaultCheckBox().getSelection();
                if (EditorHyperLinkEditorShell.this.usedefaultTooltip) {
                    EditorHyperLinkEditorShell.this.getTooltipInputText().setEditable(false);
                    EditorHyperLinkEditorShell.this.getTooltipInputText().setText(EditorHyperLinkEditorShell.this.getObjectLabeltext().getText());
                } else {
                    EditorHyperLinkEditorShell.this.getTooltipInputText().setEditable(true);
                }
            }
        });
        this.getChooseDiagramButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorLookForEditorShell editorLookForDiagram = new EditorLookForEditorShell(EditorHyperLinkEditorShell.this.editorRegistry, EditorHyperLinkEditorShell.this.amodel);
                editorLookForDiagram.open();
                Object selection = editorLookForDiagram.getSelectedEditor();
                if (selection != null) {
                    LabelProvider labelProvider;
                    EditorHyperLinkHelper helper = new EditorHyperLinkHelper();
                    EditorHyperLinkEditorShell.this.hyperLinkEditor = helper.getHyperLinkObjectFor(selection);
                    Assert.isNotNull((Object)EditorHyperLinkEditorShell.this.hyperLinkEditor, (String)NLS.bind((String)Messages.EditorHyperLinkEditorShell_ICanFindTheHyperLinkEditorObject, (Object)selection));
                    EditorHyperLinkEditorShell.this.hyperLinkEditor.setObject(selection);
                    try {
                        labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getServiceRegistry(EditorHyperLinkEditorShell.this.amodel).getService(LabelProviderService.class)).getLabelProvider();
                    }
                    catch (ServiceException ex) {
                        Activator.log.error((Throwable)ex);
                        labelProvider = new LabelProvider();
                    }
                    EditorHyperLinkEditorShell.this.getObjectLabeltext().setText(labelProvider.getText(selection));
                    if (EditorHyperLinkEditorShell.this.usedefaultTooltip) {
                        EditorHyperLinkEditorShell.this.getTooltipInputText().setText(EditorHyperLinkEditorShell.this.getObjectLabeltext().getText());
                    }
                }
            }
        });
        this.getCancelButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorHyperLinkEditorShell.this.hyperLinkEditor = null;
                EditorHyperLinkEditorShell.this.getEditHyperlinkShell().close();
            }
        });
        this.getOkButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditorHyperLinkEditorShell.this.hyperLinkEditor != null) {
                    EditorHyperLinkEditorShell.this.hyperLinkEditor.setTooltipText(EditorHyperLinkEditorShell.this.getTooltipInputText().getText().trim());
                    if (EditorHyperLinkEditorShell.this.hyperLinkEditor.getObject() == null) {
                        EditorHyperLinkEditorShell.this.hyperLinkEditor = null;
                    }
                }
                EditorHyperLinkEditorShell.this.getEditHyperlinkShell().close();
            }
        });
    }

    public HyperLinkEditor getHyperLinkEditor() {
        return this.hyperLinkEditor;
    }

    public void setHyperLinkEditor(HyperLinkEditor hyperLinkEditor) {
        this.getTooltipInputText().setText(hyperLinkEditor.getTooltipText());
        this.hyperLinkEditor = hyperLinkEditor;
    }
}

