/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.commands.CreationCommandDescriptor;
import org.eclipse.papyrus.commands.CreationCommandRegistry;
import org.eclipse.papyrus.commands.ICreationCommand;
import org.eclipse.papyrus.commands.ICreationCommandRegistry;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.extension.NotFoundException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.providers.strategy.SemanticEMFContentProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractLookForEditorShell;
import org.eclipse.papyrus.infra.hyperlink.util.EditorListContentProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class EditorLookForEditorShell
extends AbstractLookForEditorShell {
    protected AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    protected Object selectedEditor;
    protected EObject model;
    protected Menu diagramMenuButton;
    protected TreeViewer diagramListTreeViewer;
    protected TreeViewer treeViewer;

    protected Object getSelectedEditor() {
        return this.selectedEditor;
    }

    protected void setSelectedEditor(Object selectedEditor) {
        this.selectedEditor = selectedEditor;
    }

    public EditorLookForEditorShell(IPageIconsRegistry editorFactoryRegistry, EObject amodel) {
        LabelProvider labelProvider;
        this.model = amodel;
        this.createLookforShell();
        this.treeViewer = this.getModeFilteredTree().getViewer();
        this.treeViewer.setUseHashlookup(true);
        ServicesRegistry registry = null;
        try {
            registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(this.model);
            labelProvider = ((LabelProviderService)registry.getService(LabelProviderService.class)).getLabelProvider();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            labelProvider = new LabelProvider();
        }
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)new SemanticEMFContentProvider(null, null, new EObject[]{EcoreUtil.getRootContainer((EObject)amodel)}){

            public boolean hasChildren(Object element) {
                return super.getChildren(element).length > 0;
            }

            public Object[] getChildren(Object parentElement) {
                Object[] children;
                HashSet<EObject> alreadyVisited = new HashSet<EObject>();
                ArrayList<Object> returnedChildren = new ArrayList<Object>();
                Object[] objectArray = children = super.getChildren(parentElement);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object current = objectArray[n2];
                    EObject el = EMFHelper.getEObject((Object)current);
                    if (el != null && !alreadyVisited.contains(el)) {
                        returnedChildren.add(current);
                        alreadyVisited.add(el);
                    }
                    ++n2;
                }
                return returnedChildren.toArray();
            }
        });
        this.treeViewer.setInput((Object)registry);
        this.diagramListTreeViewer = this.getDiagramfilteredTree().getViewer();
        this.diagramListTreeViewer.setUseHashlookup(true);
        this.diagramListTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.diagramListTreeViewer.setContentProvider((IContentProvider)new EditorListContentProvider(this.model));
        this.diagramListTreeViewer.setInput((Object)"");
        this.diagramMenuButton = new Menu((Control)this.getNewDiagrambutton());
        this.getNewDiagrambutton().setMenu(this.diagramMenuButton);
        CreationCommandRegistry commandRegistry = CreationCommandRegistry.getInstance((String)"org.eclipse.papyrus.infra.core");
        for (CreationCommandDescriptor desc : commandRegistry.getCommandDescriptors()) {
            MenuItem menuItem = new MenuItem(this.diagramMenuButton, 8);
            menuItem.addSelectionListener((SelectionListener)new DiagramCreateListener(desc, null, (ICreationCommandRegistry)commandRegistry));
            menuItem.setText(desc.getLabel());
        }
        this.getNewDiagrambutton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditorLookForEditorShell.this.diagramMenuButton.setVisible(true);
            }
        });
        this.getRemoveDiagrambutton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPageManager pageManager;
                IStructuredSelection iSelection = (IStructuredSelection)EditorLookForEditorShell.this.getModeFilteredTree().getViewer().getSelection();
                Iterator iterator = iSelection.iterator();
                try {
                    pageManager = ServiceUtilsForEObject.getInstance().getIPageManager((Object)EditorLookForEditorShell.this.model);
                }
                catch (ServiceException ex) {
                    Activator.log.error((Throwable)ex);
                    return;
                }
                LinkedList<EObject> pagesToDelete = new LinkedList<EObject>();
                while (iterator.hasNext()) {
                    EObject eObject = EMFHelper.getEObject(iterator.next());
                    if (!pageManager.allPages().contains(eObject)) continue;
                    pagesToDelete.add(eObject);
                }
                if (pagesToDelete.isEmpty()) {
                    return;
                }
                for (Object e2 : pagesToDelete) {
                    pageManager.closeAllOpenedPages(e2);
                }
                EditorLookForEditorShell.this.getModeFilteredTree().getViewer().refresh();
            }
        });
        this.getModeFilteredTree().getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)EditorLookForEditorShell.this.getModeFilteredTree().getViewer().getSelection()).getFirstElement();
                EditorLookForEditorShell.this.refresh(selection);
            }
        });
        this.getDiagramfilteredTree().getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)EditorLookForEditorShell.this.getDiagramfilteredTree().getViewer().getSelection()).getFirstElement();
                EditorLookForEditorShell.this.refresh(selection);
            }
        });
        this.getOKbutton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditorLookForEditorShell.this.getLookforShell().close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.getCancelbutton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditorLookForEditorShell.this.setSelectedEditor(null);
                EditorLookForEditorShell.this.getLookforShell().close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.getLookforShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EditorLookForEditorShell.this.adapterFactory instanceof IDisposable) {
                    ((IDisposable)EditorLookForEditorShell.this.adapterFactory).dispose();
                }
            }
        });
    }

    public void open() {
        Display display = Display.getCurrent();
        this.getLookforShell().pack();
        this.getLookforShell().pack();
        this.getLookforShell().open();
        while (!this.getLookforShell().isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void refresh(Object selectedElement) {
        selectedElement = EMFHelper.getEObject((Object)selectedElement);
        Button but = this.getOKbutton();
        if (this.isAValidEditor(selectedElement)) {
            but = this.getOKbutton();
            but.setEnabled(true);
            this.selectedEditor = selectedElement;
        } else {
            but.setEnabled(false);
            this.selectedEditor = null;
        }
    }

    protected boolean isAValidEditor(Object object) {
        if (!(object instanceof EObject)) {
            return false;
        }
        EObject eObject = (EObject)object;
        try {
            return ServiceUtilsForEObject.getInstance().getIPageMngr((Object)eObject).allPages().contains(object);
        }
        catch (ServiceException ex) {
            return false;
        }
    }

    public class DiagramCreateListener
    extends SelectionAdapter {
        private final CreationCommandDescriptor commandDescriptor;
        private EObject container;
        private final ICreationCommandRegistry iCreationCommandRegistry;

        public void widgetSelected(SelectionEvent e) {
            try {
                if (EditorLookForEditorShell.this.treeViewer.getSelection().isEmpty()) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)EditorLookForEditorShell.this.treeViewer.getSelection();
                EObject elt = EMFHelper.getEObject((Object)selection.getFirstElement());
                if (elt == null) {
                    return;
                }
                this.setContainer(elt);
                ModelSet modelSet = ServiceUtilsForEObject.getInstance().getModelSet((Object)elt);
                ICreationCommand creationCommand = this.iCreationCommandRegistry.getCommand(this.commandDescriptor.getCommandId());
                creationCommand.createDiagram(modelSet, this.container, null);
                EditorLookForEditorShell.this.getDiagramfilteredTree().getViewer().refresh();
                EditorLookForEditorShell.this.getModeFilteredTree().getViewer().refresh();
            }
            catch (NotFoundException ex) {
                Activator.log.error((Throwable)ex);
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
            }
        }

        public DiagramCreateListener(CreationCommandDescriptor commandDescriptor, EObject container, ICreationCommandRegistry iCreationCommandRegistry) {
            this.commandDescriptor = commandDescriptor;
            this.container = container;
            this.iCreationCommandRegistry = iCreationCommandRegistry;
        }

        public void setContainer(EObject container) {
            this.container = container;
        }
    }
}

