/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForHandlers;
import org.eclipse.papyrus.infra.nattable.common.Activator;
import org.eclipse.papyrus.infra.nattable.common.handlers.PolicyDefinedTableHandler;
import org.eclipse.papyrus.infra.nattable.common.wizards.CreateNattableFromCatalogWizard;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusSyncTable;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusTable;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateNatTableFromCatalogHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final EObject context = this.getSelection().get(0);
        final CreateNattableFromCatalogWizard wizard = new CreateNattableFromCatalogWizard(context);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        ServicesRegistry serviceRegistry = null;
        TransactionalEditingDomain domain = null;
        try {
            serviceRegistry = ServiceUtilsForHandlers.getInstance().getServiceRegistry(event);
            domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)serviceRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
        if (dialog.open() == 0) {
            final ArrayList<ViewPrototype> data = new ArrayList<ViewPrototype>();
            for (ViewPrototype proto : PolicyChecker.getCurrent().getPrototypesFor(context)) {
                if (!(proto.getConfiguration() instanceof PapyrusTable) && !(proto.getConfiguration() instanceof PapyrusSyncTable)) continue;
                data.add(proto);
            }
            RecordingCommand rc = new RecordingCommand(domain){

                protected void doExecute() {
                    for (TableConfiguration tableConfiguration : wizard.getSelectedConfig().keySet()) {
                        ViewPrototype protoToUse = null;
                        int j = 0;
                        while (j < data.size() && protoToUse == null) {
                            ViewPrototype current = (ViewPrototype)data.get(j);
                            ++j;
                            if (!current.getImplementation().equals(tableConfiguration.getType())) continue;
                            protoToUse = current;
                        }
                        if (protoToUse == null) continue;
                        Integer tablesQuantity = wizard.getSelectedConfig().get(tableConfiguration);
                        String tableConfigName = wizard.getTableNames().get(tableConfiguration);
                        int i = 0;
                        while (i < tablesQuantity) {
                            PolicyDefinedTableHandler handler2 = new PolicyDefinedTableHandler(tableConfiguration.eResource().getURI(), context, String.valueOf(tableConfigName) + "_" + i);
                            handler2.execute(protoToUse);
                            ++i;
                        }
                    }
                }
            };
            domain.getCommandStack().execute((Command)rc);
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(this.getSelection().size() == 1);
    }

    protected List<EObject> getSelection() {
        ISelection selection;
        ArrayList<EObject> selectedElements = new ArrayList<EObject>();
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (ww != null && (selection = ww.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object object : structuredSelection) {
                EObject currentEObject = EMFHelper.getEObject(object);
                if (currentEObject == null) continue;
                selectedElements.add(currentEObject);
            }
        }
        return selectedElements;
    }
}

