/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.utils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class TableUtil {
    public static List<Table> getAssociatedTables(EObject element, ResourceSet resourceSet) {
        if (resourceSet == null && element != null && element.eResource() != null) {
            resourceSet = element.eResource().getResourceSet();
        }
        if (resourceSet instanceof ModelSet) {
            Resource notationResource = NotationUtils.getNotationResource((ModelSet)((ModelSet)resourceSet));
            return TableUtil.getAssociatedTablesFromNotationResource(element, notationResource);
        }
        return Collections.emptyList();
    }

    public static List<Table> getAssociatedTablesFromNotationResource(EObject element, Resource notationResource) {
        if (notationResource != null) {
            LinkedList<Table> tables = new LinkedList<Table>();
            for (EObject eObj : notationResource.getContents()) {
                Table table;
                if (!(eObj instanceof Table) || !element.equals((table = (Table)eObj).getOwner())) continue;
                tables.add(table);
            }
            return tables;
        }
        return Collections.emptyList();
    }
}

