/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTableHandler;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.Cell;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.NattablecellPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableproblem.Problem;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class ResolvedProblemHandler
extends AbstractTableHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final TransactionalEditingDomain domain = this.getTableEditingDomain();
        Problem problemToDestroy = this.getProblemToDestroy(event);
        DestroyElementRequest request = new DestroyElementRequest(domain, (EObject)problemToDestroy, false);
        final Cell cell = (Cell)problemToDestroy.eContainer();
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)cell);
        CompositeCommand composite = new CompositeCommand("Destroy Problem Command");
        composite.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        composite.add((IUndoableOperation)new AbstractTransactionalCommand(domain, "Clean Table Model : remove empty Cell", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                boolean isEmpty = true;
                if (cell.getProblems().size() == 0) {
                    ArrayList<EReference> featureToIgnore = new ArrayList<EReference>();
                    featureToIgnore.add(EcorePackage.eINSTANCE.getEModelElement_EAnnotations());
                    featureToIgnore.add(NattablecellPackage.eINSTANCE.getCell_ColumnWrapper());
                    featureToIgnore.add(NattablecellPackage.eINSTANCE.getCell_RowWrapper());
                    ArrayList allFeatures = new ArrayList(cell.eClass().getEAllStructuralFeatures());
                    allFeatures.removeAll(featureToIgnore);
                    for (EStructuralFeature eStructuralFeature : allFeatures) {
                        if (eStructuralFeature.isMany()) {
                            if (((Collection)cell.eGet(eStructuralFeature)).isEmpty()) continue;
                            isEmpty = false;
                            continue;
                        }
                        if (cell.eGet(eStructuralFeature) == eStructuralFeature.getDefaultValue()) continue;
                        isEmpty = false;
                    }
                }
                if (isEmpty) {
                    DestroyElementRequest request = new DestroyElementRequest(domain, (EObject)cell, false);
                    IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)cell.eContainer());
                    provider.getEditCommand((IEditCommandRequest)request).execute(null, null);
                }
                return null;
            }
        });
        GMFtoEMFCommandWrapper cmd = new GMFtoEMFCommandWrapper((ICommand)composite);
        domain.getCommandStack().execute((Command)cmd);
        return null;
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        if (this.isEnabled()) {
            this.setBaseEnabled(this.getProblemToDestroy(evaluationContext) != null);
        }
    }

    private Problem getProblemToDestroy(Object evaluationContextOrExecutionEvent) {
        Collection<PositionCoordinate> selectionCells;
        TableSelectionWrapper wrapper = this.getTableSelectionWrapper(evaluationContextOrExecutionEvent);
        if (this.isEnabled() && wrapper != null && (selectionCells = wrapper.getSelectedCells()).size() == 1) {
            EList problems;
            Object columnElement;
            Object rowElement;
            PositionCoordinate positionCoordinate = selectionCells.iterator().next();
            INattableModelManager nattableManager = this.getCurrentNattableModelManager();
            if (!nattableManager.getTable().isInvertAxis()) {
                rowElement = nattableManager.getRowElement(positionCoordinate.getRowPosition());
                columnElement = nattableManager.getColumnElement(positionCoordinate.getColumnPosition());
            } else {
                columnElement = nattableManager.getRowElement(positionCoordinate.getRowPosition());
                rowElement = nattableManager.getColumnElement(positionCoordinate.getColumnPosition());
            }
            Cell cell = nattableManager.getCell(columnElement, rowElement);
            if (cell != null && (problems = cell.getProblems()).size() == 1) {
                return (Problem)problems.iterator().next();
            }
        }
        return null;
    }
}

