/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTableHandler;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;

public class UnsetCellValueHandler
extends AbstractTableHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!this.canUnsetCell(event)) {
            return null;
        }
        TableSelectionWrapper wrapper = this.getTableSelectionWrapper(event);
        CompoundCommand cc = new CompoundCommand("Unset cell values");
        for (PositionCoordinate current : wrapper.getSelectedCells()) {
            int colPosition = current.getColumnPosition();
            int rowposition = current.getRowPosition();
            INattableModelManager manager = this.getCurrentNattableModelManager();
            SelectionLayer layer = manager.getBodyLayerStack().getSelectionLayer();
            int colIndex = layer.getColumnIndexByPosition(colPosition);
            int rowIndex = layer.getRowIndexByPosition(rowposition);
            Object columnElement = AxisUtils.getRepresentedElement(manager.getColumnElement(colIndex));
            Object rowElement = AxisUtils.getRepresentedElement(manager.getRowElement(rowIndex));
            Command command = CellManagerFactory.INSTANCE.getUnsetCellValueCommand(this.getContextEditingDomain(), columnElement, rowElement, manager);
            if (command == null || !command.canExecute()) continue;
            cc.append(command);
        }
        if (!cc.isEmpty() && cc.canExecute()) {
            this.getContextEditingDomain().getCommandStack().execute((Command)cc);
        }
        return null;
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        if (this.isEnabled()) {
            boolean enabled = this.canUnsetCell(evaluationContext);
            this.setBaseEnabled(enabled);
        }
    }

    protected boolean canUnsetCell(Object evaluationContext) {
        boolean enabled = false;
        TableSelectionWrapper wrapper = this.getTableSelectionWrapper(evaluationContext);
        if (!wrapper.getSelectedCells().isEmpty()) {
            LabelStack labels;
            enabled = true;
            NatEventData data = this.getNatEventData();
            if (data != null && (labels = data.getRegionLabels()) != null) {
                enabled = labels.hasLabel("BODY") && labels.getLabels().size() == 1;
            }
        }
        return enabled;
    }
}

