/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.dialog.PasteImportStatusDialog;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IPasteConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.parsers.CSVParser;
import org.eclipse.papyrus.infra.nattable.parsers.CellIterator;
import org.eclipse.papyrus.infra.nattable.parsers.RowIterator;
import org.eclipse.papyrus.infra.nattable.provider.PasteEObjectAxisInNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.provider.PasteEObjectTreeAxisInNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.CreatableEObjectAxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.PasteConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.PasteEnablementStatus;
import org.eclipse.papyrus.infra.nattable.utils.PasteModeEnumeration;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.papyrus.infra.services.edit.utils.ElementTypeUtils;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractPasteImportInNattableManager {
    protected final CSVPasteHelper pasteHelper;
    protected final INattableModelManager tableManager;
    private boolean useProgressMonitorDialog;
    private static final String INVERTED_MESSAGE = Messages.AbstractPasteImportInNattableManager_INVERTED_MESSAGE;

    public AbstractPasteImportInNattableManager(INattableModelManager tableManager, CSVPasteHelper pasteHelper, boolean useProgressMonitorDialog) {
        this.pasteHelper = pasteHelper;
        this.tableManager = tableManager;
        this.useProgressMonitorDialog = useProgressMonitorDialog;
    }

    public IStatus doPaste() {
        if (this.tableManager.getTable().isInvertAxis()) {
            return new Status(4, "org.eclipse.papyrus.infra.nattable", INVERTED_MESSAGE);
        }
        PasteEnablementStatus pasteStatus = this.findPasteModeFromTableConfiguration(this.tableManager);
        if (pasteStatus.getPasteMode() == PasteModeEnumeration.PASTE_EOBJECT_ROW_OR_COLUMN) {
            boolean value = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)PasteImportStatusDialog.DIALOG_TITLE, (String)Messages.AbstractPasteImportInNattableManager_WhatAreYouPasting);
            if (value) {
                pasteStatus.getColumnStatus().add((IStatus)new Status(8, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_TheUserChosesToPasteRows));
            } else {
                pasteStatus.getRowStatus().add((IStatus)new Status(8, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_TheUserChosesToPasteColumns));
            }
        }
        PasteModeEnumeration pasteMode = pasteStatus.getPasteMode();
        switch (pasteMode) {
            case PASTE_NO_CONFIGURATION: {
                return new Status(1, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_NoPasteConfiguration2);
            }
            case CANT_PASTE: {
                return this.createCantPasteStatus(pasteStatus);
            }
            case PASTE_EOBJECT_ROW: {
                return this.pasteRow(this.tableManager, pasteStatus, this.pasteHelper);
            }
            case PASTE_EOBJECT_COLUMN: {
                return this.pasteColumn(this.tableManager, pasteStatus, this.pasteHelper);
            }
            case PASTE_EOBJECT_ROW_OR_COLUMN: {
                break;
            }
        }
        return new Status(1, "org.eclipse.papyrus.infra.nattable", " paste not yet managed");
    }

    private IStatus createCantPasteStatus(PasteEnablementStatus pasteStatus) {
        MultiStatus rowStatus = pasteStatus.getRowStatus();
        MultiStatus columnStatus = pasteStatus.getColumnStatus();
        if (rowStatus == null && columnStatus != null) {
            return new Status(4, "org.eclipse.papyrus.infra.nattable", this.getFirstNonOKStatus((IStatus)columnStatus).getMessage());
        }
        if (columnStatus == null && rowStatus != null) {
            return new Status(4, "org.eclipse.papyrus.infra.nattable", this.getFirstNonOKStatus((IStatus)rowStatus).getMessage());
        }
        if (columnStatus != null && rowStatus != null) {
            StringBuffer buffer = new StringBuffer(Messages.AbstractPasteImportInNattableManager_NoPasteConfiguration);
            buffer.append(Messages.AbstractPasteImportInNattableManager_PasteRowsError);
            buffer.append(this.getFirstNonOKStatus((IStatus)rowStatus).getMessage());
            buffer.append(Messages.AbstractPasteImportInNattableManager_PasteColumnsError);
            buffer.append(this.getFirstNonOKStatus((IStatus)columnStatus).getMessage());
            return new Status(4, "org.eclipse.papyrus.infra.nattable", buffer.toString());
        }
        return new Status(1, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_NoPasteConfiguration2);
    }

    private IStatus getFirstNonOKStatus(IStatus status) {
        if (status != null && !status.isOK()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus current = iStatusArray[n2];
                if (!current.isOK()) {
                    if (current.isMultiStatus()) {
                        return this.getFirstNonOKStatus(current);
                    }
                    return current;
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean openPasteWithNoConfigurationDialog() {
        new PasteImportStatusDialog(Display.getDefault().getActiveShell(), Messages.AbstractPasteImportInNattableManager_NoPasteConfiguration2, 2).open();
        return true;
    }

    private IStatus pasteColumn(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper) {
        return new Status(4, "org.eclipse.papyrus.infra.nattable", "Paste column, not yet implemented");
    }

    private IStatus pasteRow(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper) {
        if (TableHelper.isTreeTable(manager)) {
            return this.pasteTreeRows(manager, pasteStatus, pasteHelper);
        }
        return this.pasteNormalRows(manager, pasteStatus, pasteHelper);
    }

    protected LabelProviderService getLabelProviderService(IConfigRegistry registry) {
        return (LabelProviderService)registry.getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
    }

    private IStatus pasteTreeRows(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper) {
        List<Integer> hiddenCategories = StyleUtils.getHiddenDepths(manager);
        for (Integer n : hiddenCategories) {
            int size = FillingConfigurationUtils.getAllTreeFillingConfigurationForDepth(manager.getTable(), n).size();
            if (size <= 1) continue;
            return new Status(4, "org.eclipse.papyrus.infra.nattable", 3, NLS.bind((String)"You have more than 1 category for the depth {0}, so this depth must be visible to do the paste and our pasted file must be conform to the new table appearance", (Object)n), null);
        }
        for (TreeFillingConfiguration treeFillingConfiguration : FillingConfigurationUtils.getAllTreeFillingConfiguration(manager.getTable())) {
            Status status;
            PasteEObjectConfiguration conf = treeFillingConfiguration.getPasteConfiguration();
            if (conf == null) {
                Status status2 = new Status(4, "org.eclipse.papyrus.infra.nattable", 1, "There is no paste configuration for a TreeFillingConfiguration", null);
                return status2;
            }
            String elementTypeId = conf.getPastedElementId();
            if (elementTypeId == null || elementTypeId.isEmpty()) {
                status = new Status(4, "org.eclipse.papyrus.infra.nattable", 2, "There is no element id defined in the paste configuration", null);
                return status;
            }
            if (!ElementTypeUtils.getAllExistingElementTypesIds().contains(elementTypeId)) {
                status = new Status(4, "org.eclipse.papyrus.infra.nattable", 4, NLS.bind((String)"The element type {0} is unknown", (Object)elementTypeId), null);
                return status;
            }
            EStructuralFeature feature = conf.getPasteElementContainementFeature();
            if (feature != null) continue;
            IAxis axis = treeFillingConfiguration.getAxisUsedAsAxisProvider();
            NatTable natTable = (NatTable)manager.getAdapter(NatTable.class);
            LabelProviderContextElementWrapper wrapper = new LabelProviderContextElementWrapper();
            wrapper.setObject(axis);
            wrapper.setConfigRegistry(natTable.getConfigRegistry());
            LabelProviderService serv = (LabelProviderService)natTable.getConfigRegistry().getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
            ILabelProvider p = serv.getLabelProvider((Object)wrapper);
            p = serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.header.labelprovider");
            String categoryName = p.getText((Object)axis);
            Status status3 = new Status(4, "org.eclipse.papyrus.infra.nattable", 0, NLS.bind((String)"Paste feature has not been set for category {0} on depth {1}", (Object)categoryName, (Object)treeFillingConfiguration.getDepth()), null);
            return status3;
        }
        IStatus iStatus = Status.OK_STATUS;
        if (iStatus.isOK()) {
            this.pasteTree(manager, pasteStatus, this.useProgressMonitorDialog, this.createReader(), this.getDataSize());
        }
        return iStatus;
    }

    private IStatus pasteNormalRows(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper) {
        Reader reader = this.createReader();
        IStatus status = this.verifyColumnCountOnFirstLine(manager, reader);
        try {
            reader.close();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        if (status.isOK()) {
            this.paste(manager, pasteStatus, this.useProgressMonitorDialog, this.createReader(), this.getDataSize());
        }
        return status;
    }

    private IStatus verifyColumnCountOnFirstLine(INattableModelManager tableManager, Reader reader) {
        int axisCount = tableManager.getColumnCount();
        CSVParser parser = this.pasteHelper.createParser(reader);
        RowIterator rowIter = parser.parse();
        int nbCell = 0;
        if (rowIter.hasNext()) {
            CellIterator cellIter = (CellIterator)rowIter.next();
            while (cellIter.hasNext()) {
                cellIter.next();
                ++nbCell;
            }
        }
        if (axisCount == 0) {
            return new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_TheTableDoesntHaveColumns);
        }
        if (axisCount == nbCell) {
            return new Status(0, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_NumberOfColumnsAreEquals);
        }
        return new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInNattableManager_NumberOfColumnsAreNotEquals, (Object)nbCell, (Object)axisCount));
    }

    private void pasteTree(INattableModelManager manager, PasteEnablementStatus status, boolean useProgressMonitorDialog, Reader reader, long totalSize) {
        PasteEObjectTreeAxisInNattableCommandProvider commandProvider = null;
        switch (status.getPasteMode()) {
            case PASTE_EOBJECT_ROW: {
                commandProvider = new PasteEObjectTreeAxisInNattableCommandProvider(manager, false, reader, this.pasteHelper, totalSize);
                break;
            }
        }
        if (commandProvider != null) {
            commandProvider.executePasteFromStringCommand(useProgressMonitorDialog);
        }
    }

    private void paste(INattableModelManager manager, PasteEnablementStatus status, boolean useProgressMonitorDialog, Reader reader, long totalSize) {
        PasteEObjectAxisInNattableCommandProvider commandProvider = null;
        switch (status.getPasteMode()) {
            case PASTE_EOBJECT_ROW: {
                commandProvider = new PasteEObjectAxisInNattableCommandProvider(manager, false, reader, this.pasteHelper, totalSize);
                break;
            }
            case PASTE_EOBJECT_COLUMN: {
                commandProvider = new PasteEObjectAxisInNattableCommandProvider(manager, true, reader, this.pasteHelper, totalSize);
                break;
            }
        }
        if (commandProvider != null) {
            commandProvider.executePasteFromStringCommand(useProgressMonitorDialog);
        }
    }

    private PasteEnablementStatus findPasteModeFromTableConfiguration(INattableModelManager tableManager) {
        if (TableHelper.isTreeTable(tableManager)) {
            return this.findPasteModeFromTableConfigurationForTreeTable(tableManager);
        }
        return this.findPasteModeFromTableConfigurationForNormalTable(tableManager);
    }

    private PasteEnablementStatus findPasteModeFromTableConfigurationForTreeTable(INattableModelManager tableManager) {
        MultiStatus pasteRowsStatus = AbstractPasteImportInNattableManager.canPasteAxis_verifyPasteConfigurationForTreeTable(tableManager);
        boolean fullSynchro = FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(tableManager.getTable(), 0);
        if (fullSynchro) {
            pasteRowsStatus.add((IStatus)AbstractPasteImportInNattableManager.canPasteAxis_verifyPasteConfiguration(tableManager, false));
        }
        PasteEnablementStatus pasteStatus = new PasteEnablementStatus(null, pasteRowsStatus);
        return pasteStatus;
    }

    private PasteEnablementStatus findPasteModeFromTableConfigurationForNormalTable(INattableModelManager tableManager) {
        MultiStatus pasteRowsStatus = AbstractPasteImportInNattableManager.canPasteAxis_verifyPasteConfiguration(tableManager, false);
        MultiStatus pasteColumnsStatus = AbstractPasteImportInNattableManager.canPasteAxis_verifyPasteConfiguration(tableManager, true);
        PasteEnablementStatus pasteStatus = new PasteEnablementStatus(pasteColumnsStatus, pasteRowsStatus);
        return pasteStatus;
    }

    private static MultiStatus canPasteAxis_verifyPasteConfigurationForTreeTable(INattableModelManager tableManager) {
        String pluginId = "org.eclipse.papyrus.infra.nattable";
        String axisName = Messages.AbstractPasteImportInNattableManager_row;
        MultiStatus status = null;
        for (TreeFillingConfiguration current : FillingConfigurationUtils.getAllTreeFillingConfiguration(tableManager.getTable())) {
            PasteEObjectConfiguration conf = current.getPasteConfiguration();
            if (!(conf instanceof PasteEObjectConfiguration)) continue;
            status = new MultiStatus("org.eclipse.papyrus.infra.nattable", 0, NLS.bind((String)Messages.AbstractPasteImportInNattableManager_EnablementStatusForPasteInTheTable, (Object)axisName), null);
            status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInNattableManager_TheTableHasAConfigurationToPaste, (Object)axisName)));
            if (!status.isOK() || current.getDepth() != 0) continue;
            PasteEObjectConfiguration pasteConfiguration = conf;
            status.add(PasteConfigurationUtils.hasConsistentPasteEObjectConfiguration(pasteConfiguration));
            if (!status.isOK()) continue;
            EStructuralFeature containmentFeature = pasteConfiguration.getPasteElementContainementFeature();
            if (tableManager.getTable().getContext().eClass().getEAllStructuralFeatures().contains((Object)containmentFeature)) {
                status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_TheContextOfTheTableHasTheContainmentFeatureDefinedForThePaste));
            } else {
                status.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_TheContextOfTheTableHasNotTheContainmentFeatureDefinedForThePaste));
            }
            if (!status.isOK()) continue;
            String elementId = pasteConfiguration.getPastedElementId();
            if (CreatableEObjectAxisUtils.getCreatableElementIds(tableManager, false).contains(elementId)) {
                status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInNattableManager_TheTableCanCreateElement, (Object)elementId, (Object)axisName)));
                continue;
            }
            status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInNattableManager_TheTableCantCreateElement, (Object)elementId, (Object)axisName)));
        }
        return status;
    }

    private static MultiStatus canPasteAxis_verifyPasteConfiguration(INattableModelManager tableManager, boolean columnAxis) {
        IPasteConfiguration conf = (IPasteConfiguration)AxisConfigurationUtils.getIAxisConfigurationUsedInTable(tableManager.getTable(), NattableaxisconfigurationPackage.eINSTANCE.getPasteEObjectConfiguration(), columnAxis);
        String pluginId = "org.eclipse.papyrus.infra.nattable";
        String axisName = columnAxis ? Messages.AbstractPasteImportInNattableManager_column : Messages.AbstractPasteImportInNattableManager_row;
        MultiStatus status = null;
        if (conf instanceof PasteEObjectConfiguration) {
            status = new MultiStatus("org.eclipse.papyrus.infra.nattable", 0, NLS.bind((String)Messages.AbstractPasteImportInNattableManager_EnablementStatusForPasteInTheTable, (Object)axisName), null);
            status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInNattableManager_TheTableHasAConfigurationToPaste, (Object)axisName)));
            if (status.isOK()) {
                PasteEObjectConfiguration pasteConfiguration = (PasteEObjectConfiguration)conf;
                status.add(PasteConfigurationUtils.hasConsistentPasteEObjectConfiguration(pasteConfiguration));
                if (status.isOK()) {
                    EStructuralFeature containmentFeature = pasteConfiguration.getPasteElementContainementFeature();
                    if (tableManager.getTable().getContext().eClass().getEAllStructuralFeatures().contains((Object)containmentFeature)) {
                        status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_TheContextOfTheTableHasTheContainmentFeatureDefinedForThePaste));
                    } else {
                        status.add((IStatus)new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInNattableManager_TheContextOfTheTableHasNotTheContainmentFeatureDefinedForThePaste));
                    }
                    if (status.isOK()) {
                        String elementId = pasteConfiguration.getPastedElementId();
                        if (CreatableEObjectAxisUtils.getCreatableElementIds(tableManager, columnAxis).contains(elementId)) {
                            status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInNattableManager_TheTableCanCreateElement, (Object)elementId, (Object)axisName)));
                        } else {
                            status.add((IStatus)new Status(0, "org.eclipse.papyrus.infra.nattable", NLS.bind((String)Messages.AbstractPasteImportInNattableManager_TheTableCantCreateElement, (Object)elementId, (Object)axisName)));
                        }
                    }
                }
            }
        }
        return status;
    }

    protected abstract Reader createReader();

    protected abstract long getDataSize();
}

