/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.cell;

import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.nattable.manager.cell.ICellManager;
import org.eclipse.papyrus.infra.nattable.manager.cell.IUnsetValueCellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecell.Cell;
import org.eclipse.papyrus.infra.nattable.utils.CellHelper;
import org.eclipse.papyrus.infra.tools.converter.AbstractStringValueConverter;

public class StringResolutionProblemWrapperCellManager
implements IUnsetValueCellManager {
    private ICellManager wrappedCellManager;

    public StringResolutionProblemWrapperCellManager(ICellManager wrappedCellManager) {
        this.wrappedCellManager = wrappedCellManager;
    }

    @Override
    public boolean handles(Object columnElement, Object rowElement) {
        return this.wrappedCellManager.handles(columnElement, rowElement);
    }

    @Override
    public Object getValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        EList problems;
        Cell cell = tableManager.getCell(columnElement, rowElement);
        if (cell != null && (problems = cell.getProblems()).size() != 0) {
            return problems;
        }
        return this.wrappedCellManager.getValue(columnElement, rowElement, tableManager);
    }

    public Object getValueIgnoringCellProblem(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return this.wrappedCellManager.getValue(columnElement, rowElement, tableManager);
    }

    @Override
    public void setValue(final TransactionalEditingDomain domain, final Object columnElement, final Object rowElement, final Object newValue, final INattableModelManager tableManager) {
        final Command destroyStringProblemCommand = CellHelper.getDestroyStringResolutionProblemCommand(domain, columnElement, rowElement, newValue, tableManager);
        if (destroyStringProblemCommand != null) {
            RecordingCommand rc = new RecordingCommand(domain){

                protected void doExecute() {
                    destroyStringProblemCommand.execute();
                    StringResolutionProblemWrapperCellManager.this.wrappedCellManager.setValue(domain, columnElement, rowElement, newValue, tableManager);
                }
            };
            domain.getCommandStack().execute((Command)rc);
        } else {
            this.wrappedCellManager.setValue(domain, columnElement, rowElement, newValue, tableManager);
        }
    }

    @Override
    public boolean isCellEditable(Object columnElement, Object rowElement) {
        return this.wrappedCellManager.isCellEditable(columnElement, rowElement);
    }

    @Override
    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        Command cmd = this.wrappedCellManager.getSetValueCommand(domain, columnElement, rowElement, newValue, tableManager);
        Command destroyStringProblem = CellHelper.getDestroyStringResolutionProblemCommand(domain, columnElement, rowElement, newValue, tableManager);
        if (cmd != null && destroyStringProblem != null && destroyStringProblem.canExecute()) {
            return cmd.chain(destroyStringProblem);
        }
        return cmd;
    }

    @Override
    public Command getSetStringValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, String newValue, AbstractStringValueConverter valueConverter, INattableModelManager tableManager) {
        CompoundCommand cc = new CompoundCommand();
        Command setValueCommand = this.wrappedCellManager.getSetStringValueCommand(domain, columnElement, rowElement, newValue, valueConverter, tableManager);
        if (setValueCommand != null && setValueCommand.canExecute()) {
            cc.append(setValueCommand);
            Command destroyExistingCellStringResolutionProblemCommand = CellHelper.getDestroyStringResolutionProblemCommand(domain, columnElement, rowElement, newValue, tableManager);
            if (destroyExistingCellStringResolutionProblemCommand != null && destroyExistingCellStringResolutionProblemCommand.canExecute()) {
                cc.append(destroyExistingCellStringResolutionProblemCommand);
            }
        }
        if (setValueCommand == null) {
            Command destroyExistingCellStringResolutionProblemCommand;
            Command createCellProblemCommand = CellHelper.getCreateStringResolutionProblemCommand(domain, tableManager, columnElement, rowElement, newValue, valueConverter.getConvertedValue());
            if (createCellProblemCommand != null && createCellProblemCommand.canExecute()) {
                cc.append(createCellProblemCommand);
            }
            if (createCellProblemCommand != null && (destroyExistingCellStringResolutionProblemCommand = CellHelper.getDestroyStringResolutionProblemCommand(domain, columnElement, rowElement, newValue, tableManager)) != null && destroyExistingCellStringResolutionProblemCommand.canExecute()) {
                cc.append(destroyExistingCellStringResolutionProblemCommand);
            }
        }
        if (cc.isEmpty() || !cc.canExecute()) {
            return null;
        }
        return cc;
    }

    @Override
    public AbstractStringValueConverter getOrCreateStringValueConverterClass(INattableModelManager tableManager, Map<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter> existingConverters, String multiValueSeparator) {
        return this.wrappedCellManager.getOrCreateStringValueConverterClass(tableManager, existingConverters, multiValueSeparator);
    }

    @Override
    public boolean isCellEditable(Object columnElement, Object rowElement, Map<?, ?> sharedMap) {
        return this.wrappedCellManager.isCellEditable(columnElement, rowElement, sharedMap);
    }

    @Override
    public void setStringValue(Object columnElement, Object rowElement, String valueAsString, AbstractStringValueConverter valueConverter, INattableModelManager tableManager, Map<?, ?> sharedMap) {
        this.wrappedCellManager.setStringValue(columnElement, rowElement, valueAsString, valueConverter, tableManager, sharedMap);
        CellHelper.createStringResolutionProblem(tableManager, columnElement, rowElement, valueAsString, valueConverter.getConvertedValue(), sharedMap);
    }

    @Override
    public void unsetCellValue(TransactionalEditingDomain domain, Object columnElement, Object rowElement, INattableModelManager tableManager) {
        if (this.wrappedCellManager instanceof IUnsetValueCellManager) {
            ((IUnsetValueCellManager)this.wrappedCellManager).unsetCellValue(domain, columnElement, rowElement, tableManager);
        }
    }

    @Override
    public Command getUnsetCellValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, INattableModelManager tableManager) {
        if (this.wrappedCellManager instanceof IUnsetValueCellManager) {
            return ((IUnsetValueCellManager)this.wrappedCellManager).getUnsetCellValueCommand(domain, columnElement, rowElement, tableManager);
        }
        return null;
    }
}

