/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.ISelectionEvent;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.ui.services.IDisposable;

public class TableSelectionProvider
implements ISelectionProvider,
IDisposable,
ILayerListener {
    private SelectionLayer selectionLayer;
    private final ILayerListener selectionListener;
    private ISelection currentSelection;
    private final List<ISelectionChangedListener> listeners;
    private INattableModelManager manager;
    private boolean isDisposed = false;

    public TableSelectionProvider(INattableModelManager manager, SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
        this.selectionListener = this;
        this.selectionLayer.addLayerListener(this.selectionListener);
        this.currentSelection = new StructuredSelection();
        this.listeners = new ArrayList<ISelectionChangedListener>();
        this.manager = manager;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public synchronized ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void setSelection(ISelection selection) {
        if (this.currentSelection.equals(selection)) {
            return;
        }
        this.currentSelection = selection;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.currentSelection);
        for (ISelectionChangedListener current : this.listeners) {
            current.selectionChanged(event);
        }
    }

    protected void calculateAndStoreNewSelection(ILayerEvent event) {
        StructuredSelection newSelection;
        HashSet<Object> selection = new HashSet<Object>();
        if (event instanceof ISelectionEvent) {
            List selectedCells = ListHelper.asList((Object[])this.selectionLayer.getSelectedCellPositions());
            HashMap<Integer, Object> fullySelectedRows = new HashMap<Integer, Object>();
            HashMap<Integer, Object> fullySelectedColumns = new HashMap<Integer, Object>();
            ArrayList<Integer> selectedRowsIndexes = new ArrayList<Integer>();
            int[] nArray = this.selectionLayer.getFullySelectedRowPositions();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                int rowIndex = this.selectionLayer.getRowIndexByPosition(i);
                selectedRowsIndexes.add(new Integer(rowIndex));
                Object el = this.manager.getRowElement(rowIndex);
                if (el != null) {
                    fullySelectedRows.put(rowIndex, el);
                    el = AxisUtils.getRepresentedElement(el);
                    selection.add(el);
                }
                ++n2;
            }
            ArrayList<Integer> selectedColumnsIndexes = new ArrayList<Integer>();
            int[] rowIndex = this.selectionLayer.getFullySelectedColumnPositions();
            int n3 = rowIndex.length;
            n = 0;
            while (n < n3) {
                int i = rowIndex[n];
                int columnIndex = this.selectionLayer.getColumnIndexByPosition(i);
                selectedColumnsIndexes.add(new Integer(columnIndex));
                Object el = this.manager.getColumnElement(columnIndex);
                if (el != null) {
                    fullySelectedColumns.put(columnIndex, el);
                    el = AxisUtils.getRepresentedElement(el);
                    selection.add(el);
                }
                ++n;
            }
            for (PositionCoordinate cellLocation : selectedCells) {
                Object value;
                ILayerCell cell;
                int colPos = cellLocation.getColumnPosition();
                int rowPos = cellLocation.getRowPosition();
                if (selectedColumnsIndexes.contains(new Integer(this.selectionLayer.getColumnIndexByPosition(colPos))) || selectedRowsIndexes.contains(new Integer(this.selectionLayer.getRowIndexByPosition(rowPos))) || (cell = this.selectionLayer.getCellByPosition(colPos, rowPos)) == null || (value = cell.getDataValue()) == null) continue;
                if (value instanceof Collection) {
                    for (Object current : (Collection)value) {
                        selection.add(current);
                    }
                    continue;
                }
                selection.add(value);
            }
            TableSelectionWrapper wrapper = new TableSelectionWrapper(selectedCells, fullySelectedRows, fullySelectedColumns);
            newSelection = new TableStructuredSelection(selection.toArray(), wrapper);
        } else {
            newSelection = new StructuredSelection();
        }
        this.setSelection((ISelection)newSelection);
    }

    public void dispose() {
        this.isDisposed = true;
        this.manager = null;
        this.setSelection((ISelection)StructuredSelection.EMPTY);
        if (this.selectionLayer != null) {
            this.selectionLayer.removeLayerListener(this.selectionListener);
            this.selectionLayer = null;
        }
        this.listeners.clear();
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (!this.isDisposed && event instanceof ISelectionEvent) {
            this.calculateAndStoreNewSelection(event);
        }
    }
}

