/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeCollapseAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandCollapseCommand;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.infra.nattable.tree.CollapseAndExpandActionsEnum;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrus.infra.tools.util.SelectionHelper;

public class CollapseExpandActionHelper {
    private CollapseExpandActionHelper() {
    }

    public static final void doCollapseExpandAction(CollapseAndExpandActionsEnum actionId, List<ITreeItemAxis> selectedAxis, ITableAxisElementProvider axisProvider, NatTable natTable) {
        switch (actionId) {
            case EXPAND_ALL: {
                natTable.doCommand((ILayerCommand)new TreeExpandAllCommand());
                return;
            }
            case COLLAPSE_ALL: {
                CollapseExpandActionHelper.doCollapseAll(axisProvider, natTable);
                return;
            }
        }
        if (selectedAxis == null) {
            CollapseExpandActionHelper.doCollapseExpandActionOnSelection(actionId, axisProvider, natTable);
        } else {
            CollapseExpandActionHelper.doCollapseExpandActionOnChoosenRows(actionId, selectedAxis, axisProvider, natTable);
        }
    }

    private static final void doCollapseAll(ITableAxisElementProvider axisProvider, NatTable natTable) {
        natTable.doCommand((ILayerCommand)new TreeCollapseAllCommand());
        if (axisProvider instanceof INattableModelManager && StyleUtils.isHiddenDepth((INattableModelManager)axisProvider, 0)) {
            List<Object> rows = axisProvider.getRowElementsList();
            ArrayList<ITreeItemAxis> axis = new ArrayList<ITreeItemAxis>();
            for (Object current : rows) {
                Assert.isTrue((boolean)(current instanceof ITreeItemAxis));
                Assert.isTrue((((ITreeItemAxis)current).getParent() == null ? 1 : 0) != 0);
                axis.add((ITreeItemAxis)current);
            }
            CollapseExpandActionHelper.doCollapseExpandActionOnChoosenRows(CollapseAndExpandActionsEnum.EXPAND_ONE_LEVEL, axis, axisProvider, natTable);
        }
    }

    private static final void doCollapseExpandActionOnSelection(CollapseAndExpandActionsEnum actionId, ITableAxisElementProvider axisProvider, NatTable natTable) {
        switch (actionId) {
            case COLLAPSE_ALL_FROM_SELECTION: {
                CollapseExpandActionHelper.collapseAllFromSelectedRows(axisProvider, natTable);
                return;
            }
            case COLLAPSE_ONE_LEVEL: {
                CollapseExpandActionHelper.collapseSelectedRows(axisProvider, natTable);
                return;
            }
            case EXPAND_TWO_LEVEL: {
                CollapseExpandActionHelper.expandOn2LevelsSelectedRows(axisProvider, natTable);
                return;
            }
            case EXPAND_ALL_FROM_SELECTION: {
                CollapseExpandActionHelper.expandAllFromSelectedRows(axisProvider, natTable);
                return;
            }
            case EXPAND_ONE_LEVEL: {
                CollapseExpandActionHelper.expandFromSelectedRows(axisProvider, natTable);
                return;
            }
            case EXPAND_TO_NODE: {
                return;
            }
        }
    }

    private static final void doCollapseExpandActionOnChoosenRows(CollapseAndExpandActionsEnum actionId, List<ITreeItemAxis> selectedRows, ITableAxisElementProvider axisProvider, NatTable natTable) {
        switch (actionId) {
            case COLLAPSE_ALL_FROM_SELECTION: {
                CollapseExpandActionHelper.collapseAllRows(selectedRows, axisProvider, natTable);
                break;
            }
            case COLLAPSE_ONE_LEVEL: {
                CollapseExpandActionHelper.collapseRows(selectedRows, axisProvider, natTable);
                break;
            }
            case EXPAND_ALL_FROM_SELECTION: {
                CollapseExpandActionHelper.expandAllRows(selectedRows, axisProvider, natTable);
                break;
            }
            case EXPAND_ONE_LEVEL: {
                CollapseExpandActionHelper.expandRows(selectedRows, axisProvider, natTable);
                break;
            }
            case EXPAND_TO_NODE: {
                CollapseExpandActionHelper.expandToRows(selectedRows, axisProvider, natTable);
                break;
            }
            case EXPAND_TWO_LEVEL: {
                CollapseExpandActionHelper.expandOn2LevelsRows(selectedRows, axisProvider, natTable);
                break;
            }
        }
    }

    private static final void expandOn2LevelsRows(List<ITreeItemAxis> axis, ITableAxisElementProvider axisProvider, NatTable natTable) {
        ArrayList<ITreeItemAxis> toExpand = new ArrayList<ITreeItemAxis>();
        for (ITreeItemAxis current : axis) {
            int index;
            toExpand.add(current);
            if (current.isExpanded() || current.getChildren().size() <= 0 || (index = axisProvider.getRowElementsList().indexOf(current)) == -1) continue;
            natTable.doCommand((ILayerCommand)new TreeExpandCollapseCommand(index));
        }
        for (ITreeItemAxis current : toExpand) {
            for (ITreeItemAxis child : current.getChildren()) {
                int index;
                if (child.isExpanded() || child.getChildren().size() <= 0 || (index = axisProvider.getRowElementsList().indexOf(child)) == -1) continue;
                natTable.doCommand((ILayerCommand)new TreeExpandCollapseCommand(index));
            }
        }
    }

    private static final void expandRows(List<ITreeItemAxis> axis, ITableAxisElementProvider axisProvider, NatTable natTable) {
        for (ITreeItemAxis current : axis) {
            int index;
            if (current.isExpanded() || (index = axisProvider.getRowElementsList().indexOf(current)) == -1) continue;
            natTable.doCommand((ILayerCommand)new TreeExpandCollapseCommand(index));
        }
    }

    private static final void expandAllRows(List<ITreeItemAxis> axis, ITableAxisElementProvider axisProvider, NatTable natTable) {
        for (ITreeItemAxis current : axis) {
            CollapseExpandActionHelper.expandFullBranch(current, axisProvider, natTable);
        }
    }

    private static final void collapseAllRows(List<ITreeItemAxis> axis, ITableAxisElementProvider axisProvider, NatTable natTable) {
        for (ITreeItemAxis current : axis) {
            if (!current.isExpanded()) continue;
            CollapseExpandActionHelper.collapseFullBranch((ITreeItemAxis)axis, axisProvider, natTable);
        }
    }

    private static final void collapseRows(List<ITreeItemAxis> axis, ITableAxisElementProvider axisProvider, NatTable natTable) {
        for (ITreeItemAxis current : axis) {
            int index = axisProvider.getRowElementsList().indexOf(axis);
            if (index == -1 || !current.isExpanded()) continue;
            natTable.doCommand((ILayerCommand)new TreeExpandCollapseCommand(index));
        }
    }

    private static final void expandToRows(List<ITreeItemAxis> axis, ITableAxisElementProvider axisProvider, NatTable natTable) {
        for (ITreeItemAxis current : axis) {
            CollapseExpandActionHelper.expandToNode(current, axisProvider, natTable);
        }
    }

    private static final void expandToNode(ITreeItemAxis axis, ITableAxisElementProvider axisProvider, NatTable natTable) {
        ArrayList<ITreeItemAxis> axisToExpand = new ArrayList<ITreeItemAxis>();
        ITreeItemAxis parent = axis.getParent();
        while (parent != null) {
            if (!parent.isExpanded()) {
                axisToExpand.add(parent);
            }
            parent = parent.getParent();
        }
        for (ITreeItemAxis current : axisToExpand) {
            int index = axisProvider.getRowElementsList().indexOf(current);
            natTable.doCommand((ILayerCommand)new TreeExpandCollapseCommand(index));
        }
    }

    private static final void collapseSelectedRows(ITableAxisElementProvider axisProvider, NatTable natTable) {
        for (Map.Entry<Integer, Object> current : CollapseExpandActionHelper.getFullySelectedRows().entrySet()) {
            ITreeItemAxis axis;
            Object value = current.getValue();
            if (!(value instanceof ITreeItemAxis) || !(axis = (ITreeItemAxis)value).isExpanded()) continue;
            natTable.doCommand((ILayerCommand)new TreeExpandCollapseCommand(current.getKey().intValue()));
        }
    }

    private static final void expandFromSelectedRows(ITableAxisElementProvider axisProvider, NatTable natTable) {
        for (Map.Entry<Integer, Object> current : CollapseExpandActionHelper.getFullySelectedRows().entrySet()) {
            ITreeItemAxis axis;
            Object value = current.getValue();
            if (!(value instanceof ITreeItemAxis) || (axis = (ITreeItemAxis)value).isExpanded()) continue;
            natTable.doCommand((ILayerCommand)new TreeExpandCollapseCommand(current.getKey().intValue()));
        }
    }

    private static final void collapseAllFromSelectedRows(ITableAxisElementProvider axisProvider, NatTable natTable) {
        for (Map.Entry<Integer, Object> current : CollapseExpandActionHelper.getFullySelectedRows().entrySet()) {
            ITreeItemAxis axis;
            Object value = current.getValue();
            if (!(value instanceof ITreeItemAxis) || !(axis = (ITreeItemAxis)value).isExpanded()) continue;
            CollapseExpandActionHelper.collapseFullBranch(axis, axisProvider, natTable);
        }
    }

    private static final void collapseFullBranch(ITreeItemAxis axis, ITableAxisElementProvider axisProvider, NatTable natTable) {
        if (axis.isExpanded() && axis.getChildren().size() > 0) {
            int index = axisProvider.getRowElementsList().indexOf(axis);
            for (ITreeItemAxis child : axis.getChildren()) {
                CollapseExpandActionHelper.collapseFullBranch(child, axisProvider, natTable);
            }
            natTable.doCommand((ILayerCommand)new TreeExpandCollapseCommand(index));
        }
    }

    private static final void expandOn2LevelsSelectedRows(ITableAxisElementProvider axisProvider, NatTable natTable) {
        ArrayList<ITreeItemAxis> toExpand = new ArrayList<ITreeItemAxis>();
        for (Map.Entry<Integer, Object> entry : CollapseExpandActionHelper.getFullySelectedRows().entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof ITreeItemAxis)) continue;
            ITreeItemAxis axis = (ITreeItemAxis)value;
            toExpand.add(axis);
            if (axis.isExpanded() || axis.getChildren().size() <= 0) continue;
            natTable.doCommand((ILayerCommand)new TreeExpandCollapseCommand(entry.getKey().intValue()));
        }
        for (ITreeItemAxis iTreeItemAxis : toExpand) {
            for (ITreeItemAxis child : iTreeItemAxis.getChildren()) {
                if (child.isExpanded() || child.getChildren().size() <= 0) continue;
                int index = axisProvider.getRowElementsList().indexOf(child);
                natTable.doCommand((ILayerCommand)new TreeExpandCollapseCommand(index));
            }
        }
    }

    private static Map<Integer, Object> getFullySelectedRows() {
        IStructuredSelection selection = SelectionHelper.getCurrentStructuredSelection();
        if (selection instanceof TableStructuredSelection) {
            TableStructuredSelection tableSelection = (TableStructuredSelection)selection;
            TableSelectionWrapper wrapper = (TableSelectionWrapper)tableSelection.getAdapter(TableSelectionWrapper.class);
            return wrapper.getFullySelectedRows();
        }
        return Collections.emptyMap();
    }

    private static final void expandAllFromSelectedRows(ITableAxisElementProvider axisProvider, NatTable natTable) {
        for (Map.Entry<Integer, Object> current : CollapseExpandActionHelper.getFullySelectedRows().entrySet()) {
            Object value = current.getValue();
            if (!(value instanceof ITreeItemAxis)) continue;
            CollapseExpandActionHelper.expandFullBranch((ITreeItemAxis)value, axisProvider, natTable);
        }
    }

    private static final void expandFullBranch(ITreeItemAxis axis, ITableAxisElementProvider axisProvider, NatTable natTable) {
        if (!axis.isExpanded() && axis.getChildren().size() > 0) {
            int index = axisProvider.getRowElementsList().indexOf(axis);
            natTable.doCommand((ILayerCommand)new TreeExpandCollapseCommand(index));
            for (ITreeItemAxis child : axis.getChildren()) {
                CollapseExpandActionHelper.expandFullBranch(child, axisProvider, natTable);
            }
        }
    }
}

