/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.selection.ObjectsSelectionExtractor;
import org.eclipse.papyrus.infra.nattable.utils.NattableModelManagerFactory;
import org.eclipse.papyrus.infra.services.edit.utils.ElementTypeUtils;

public class CreatableEObjectAxisUtils {
    private CreatableEObjectAxisUtils() {
    }

    public static final Collection<String> getCreatableElementIds(Table table, boolean onColumn) {
        INattableModelManager nattableModelManager = NattableModelManagerFactory.INSTANCE.createNatTableModelManager(table, new ObjectsSelectionExtractor());
        return CreatableEObjectAxisUtils.getCreatableElementIds(nattableModelManager, onColumn);
    }

    public static final Collection<String> getCreatableElementIds(INattableModelManager nattableModelManager, boolean onColumn) {
        IAxisManager axisManager = onColumn ? nattableModelManager.getColumnAxisManager() : nattableModelManager.getRowAxisManager();
        Collection possibleValues = ElementTypeUtils.getAllExistingElementTypes();
        TreeSet<String> allowedElements = new TreeSet<String>();
        for (IElementType current : possibleValues) {
            String id = current.getId();
            if (!axisManager.canCreateAxisElement(id)) continue;
            allowedElements.add(id);
        }
        return allowedElements;
    }
}

