/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattableFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.CellEditorDeclaration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.DisplayStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.IntListValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.TableDisplayStyle;

public class TableHelper {
    private TableHelper() {
    }

    public static final Table createTable(TableConfiguration configuration) {
        return TableHelper.createTable(configuration, null);
    }

    public static final Table createTable(TableConfiguration configuration, EObject context) {
        return TableHelper.createTable(configuration, null, null);
    }

    public static final Table createTable(TableConfiguration configuration, EObject context, String name) {
        return TableHelper.createTable(configuration, null, null, null);
    }

    public static final Table createTable(TableConfiguration configuration, EObject context, String name, String description) {
        assert (configuration != null);
        Table table = NattableFactory.eINSTANCE.createTable();
        table.setTableConfiguration(configuration);
        table.setDescription(description);
        table.setName(name);
        table.setContext(context);
        AbstractAxisProvider rowProvider = configuration.getDefaultRowAxisProvider();
        rowProvider = (AbstractAxisProvider)EcoreUtil.copy((EObject)rowProvider);
        AbstractAxisProvider columnProvider = configuration.getDefaultColumnAxisProvider();
        columnProvider = (AbstractAxisProvider)EcoreUtil.copy((EObject)columnProvider);
        table.setCurrentRowAxisProvider(rowProvider);
        table.setCurrentColumnAxisProvider(columnProvider);
        table.getRowAxisProvidersHistory().add((Object)rowProvider);
        table.getColumnAxisProvidersHistory().add((Object)columnProvider);
        IntListValueStyle style = (IntListValueStyle)configuration.getNamedStyle(NattablestylePackage.eINSTANCE.getIntListValueStyle(), "hiddenCategoriesByDepth");
        if (style != null) {
            IntListValueStyle copy = (IntListValueStyle)EcoreUtil.copy((EObject)style);
            table.getStyles().add((Object)copy);
        }
        return table;
    }

    public static final DisplayStyle getTableDisplayStyle(Table table) {
        TableDisplayStyle displayStyle = (TableDisplayStyle)table.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        if (displayStyle == null) {
            displayStyle = (TableDisplayStyle)table.getTableConfiguration().getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        }
        if (displayStyle != null) {
            return displayStyle.getDisplayStyle();
        }
        return DisplayStyle.NORMAL;
    }

    public static final DisplayStyle getTableDisplayStyle(INattableModelManager tableManager) {
        return TableHelper.getTableDisplayStyle(tableManager.getTable());
    }

    public static final boolean isTreeTable(INattableModelManager tableManager) {
        return TableHelper.isTreeTable(tableManager.getTable());
    }

    public static final boolean isTreeTable(Table table) {
        TableDisplayStyle style = (TableDisplayStyle)table.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        if (style == null) {
            style = (TableDisplayStyle)table.getTableConfiguration().getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        }
        if (style != null) {
            DisplayStyle displayStyle = style.getDisplayStyle();
            return DisplayStyle.HIERARCHIC_MULTI_TREE_COLUMN.equals((Object)displayStyle) || DisplayStyle.HIERARCHIC_SINGLE_TREE_COLUMN.equals((Object)displayStyle);
        }
        return false;
    }

    public static final boolean isSingleColumnTreeTable(Table table) {
        TableDisplayStyle style = (TableDisplayStyle)table.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        if (style == null) {
            style = (TableDisplayStyle)table.getTableConfiguration().getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        }
        if (style != null) {
            DisplayStyle displayStyle = style.getDisplayStyle();
            return DisplayStyle.HIERARCHIC_SINGLE_TREE_COLUMN.equals((Object)displayStyle);
        }
        return false;
    }

    public static final boolean isSingleColumnTreeTable(INattableModelManager tableManager) {
        return TableHelper.isSingleColumnTreeTable(tableManager.getTable());
    }

    public static final boolean isMultiColumnTreeTable(Table table) {
        TableDisplayStyle style = (TableDisplayStyle)table.getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        if (style == null) {
            style = (TableDisplayStyle)table.getTableConfiguration().getStyle(NattablestylePackage.eINSTANCE.getTableDisplayStyle());
        }
        if (style != null) {
            DisplayStyle displayStyle = style.getDisplayStyle();
            return DisplayStyle.HIERARCHIC_MULTI_TREE_COLUMN.equals((Object)displayStyle);
        }
        return false;
    }

    public static final boolean isMultiColumnTreeTable(INattableModelManager tableManager) {
        return TableHelper.isMultiColumnTreeTable(tableManager.getTable());
    }

    public static final Table findTable(EObject anEObject) throws Exception {
        if (EcoreUtil.getRootContainer((EObject)anEObject.eClass()) != NattablePackage.eINSTANCE) {
            throw new Exception("The eobject is not an element of the Papyrus table metamodel");
        }
        EObject container = anEObject;
        while (container != null && !(container instanceof Table)) {
            container = container.eContainer();
        }
        if (container == null) {
            return null;
        }
        return (Table)container;
    }

    public static final CellEditorDeclaration getCellEditorDeclaration(INattableModelManager tableManager) {
        return TableHelper.getCellEditorDeclaration(tableManager.getTable());
    }

    public static final CellEditorDeclaration getCellEditorDeclaration(Table table) {
        CellEditorDeclaration declaration = table.getTableConfiguration().getCellEditorDeclaration();
        if (table.isInvertAxis()) {
            switch (declaration) {
                case COLUMN: {
                    return CellEditorDeclaration.ROW;
                }
                case ROW: {
                    return CellEditorDeclaration.COLUMN;
                }
            }
        }
        return declaration;
    }

    public static final void getPath(List<ITreeItemAxis> path, ITreeItemAxis element) {
        path.add(element);
        ITreeItemAxis parent = element.getParent();
        while (parent != null) {
            path.add(0, parent);
            parent = parent.getParent();
        }
    }
}

