/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.widget;

import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.widget.NatCombo;
import org.eclipse.papyrus.infra.nattable.celleditor.ButtonConfiguration;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class NatComboButton
extends NatCombo {
    private ButtonConfiguration buttonConfiguration;
    private Button button;

    public NatComboButton(Composite parent, IStyle cellStyle, int style, ButtonConfiguration buttonConfiguration) {
        super(parent, cellStyle, style);
        this.buttonConfiguration = buttonConfiguration;
        this.configureButton();
    }

    public NatComboButton(Composite parent, IStyle cellStyle, int maxVisibleItems, int style, ButtonConfiguration buttonConfiguration) {
        super(parent, cellStyle, maxVisibleItems, style);
        this.buttonConfiguration = buttonConfiguration;
        this.configureButton();
    }

    @Deprecated
    public NatComboButton(Composite parent, IStyle cellStyle, int maxVisibleItems, boolean freeEdit, int style, ButtonConfiguration buttonConfiguration) {
        super(parent, cellStyle, maxVisibleItems, NatComboButton.computeFreeEditStyle(freeEdit, style));
        this.buttonConfiguration = buttonConfiguration;
        this.configureButton();
    }

    @Deprecated
    private static int computeFreeEditStyle(boolean freeEdit, int style) {
        if (freeEdit) {
            return style & 0xFFFFFFF7;
        }
        return style | 8;
    }

    @Deprecated
    private static int computeMultiSelectStyle(boolean multiselect, int style) {
        if (multiselect) {
            return style | 2;
        }
        return style & 0xFFFFFFFD;
    }

    @Deprecated
    public NatComboButton(Composite parent, IStyle cellStyle, int maxVisibleItems, boolean freeEdit, boolean multiselect, int style, ButtonConfiguration buttonConfiguration) {
        this(parent, cellStyle, maxVisibleItems, multiselect, NatComboButton.computeMultiSelectStyle(multiselect, style), buttonConfiguration);
    }

    @Deprecated
    public NatComboButton(Composite parent, IStyle cellStyle, int maxVisibleItems, boolean freeEdit, boolean multiselect, int style, Image iconImage, ButtonConfiguration buttonConfiguration) {
        this(parent, cellStyle, maxVisibleItems, NatComboButton.computeMultiSelectStyle(multiselect, NatComboButton.computeFreeEditStyle(freeEdit, style)), buttonConfiguration);
    }

    public NatComboButton(Composite parent, IStyle cellStyle, int maxVisibleItems, int style, Image iconImage, ButtonConfiguration buttonConfiguration) {
        super(parent, cellStyle, maxVisibleItems, style, iconImage);
        this.buttonConfiguration = buttonConfiguration;
        this.configureButton();
    }

    protected void configureButton() {
        Image img;
        String toolTip;
        String txt = this.buttonConfiguration.getText();
        if (txt != null) {
            this.button.setText(txt);
        }
        if ((toolTip = this.buttonConfiguration.getTooltipText()) != null) {
            this.button.setToolTipText(toolTip);
        }
        if ((img = this.buttonConfiguration.getImage()) != null) {
            this.button.setImage(img);
        }
    }

    protected void createTextControl(int style) {
        super.createTextControl(style);
        this.createButton();
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
    }

    protected void createButton() {
        this.button = new Button((Composite)this, 0);
        GridData gridData = new GridData(4, 4, false, true);
        this.button.setLayoutData((Object)gridData);
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NatComboButton.this.runAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void runAction() {
        this.buttonConfiguration.getAction().run();
    }

    public void dispose() {
        super.dispose();
        this.buttonConfiguration = null;
        this.button = null;
    }
}

