/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.core.sashwindows.di.AbstractPanel;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashPanel;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.TabFolder;
import org.eclipse.papyrus.infra.core.sashwindows.di.Window;
import org.eclipse.papyrus.infra.core.sashwindows.di.exception.SashEditorException;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiUtils;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.controlmode.ControlModePlugin;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;
import org.eclipse.papyrus.infra.services.controlmode.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializeSashCommand
extends AbstractControlCommand {
    private static final String SASH_RESOURCE_ERROR = Messages.getString("InitializeSashCommand.resource.error");
    private static final String SASH_COMMAND_TITLE = Messages.getString("InitializeSashCommand.command.title");

    public InitializeSashCommand(ControlModeRequest request) {
        super(SASH_COMMAND_TITLE, null, request);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Collection<EObject> openables = this.getMovedOpenablesFromRequest();
        try {
            SashWindowsMngr sashMng = this.createSashWindowsMngr(openables);
            Resource sashResourceResource = this.getSashResource();
            if (sashResourceResource == null) {
                return CommandResult.newErrorCommandResult((String)SASH_RESOURCE_ERROR);
            }
            sashResourceResource.getContents().add((Object)sashMng);
        }
        catch (SashEditorException e) {
            ControlModePlugin.log.error((Throwable)e);
            return CommandResult.newErrorCommandResult((Throwable)e);
        }
        catch (ServiceException e) {
            ControlModePlugin.log.error((Throwable)e);
            return CommandResult.newErrorCommandResult((Throwable)e);
        }
        return CommandResult.newOKCommandResult();
    }

    protected Collection<EObject> getMovedOpenablesFromRequest() {
        Collection tabs = (Collection)this.getRequest().getParameter("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.MovedOpenables");
        if (tabs == null) {
            return new ArrayList<EObject>();
        }
        return tabs;
    }

    protected Resource getSashResource() throws ServiceException {
        SashModel sashModel = SashModelUtils.getSashModel((ModelSet)this.request.getModelSet());
        Resource sashResource = this.request.getTargetResource("di");
        if ("sash".equals(sashModel.getResourceURI().fileExtension())) {
            URI targetUri = sashResource.getURI().trimFileExtension();
            sashModel.loadModel(targetUri);
            sashResource = SashModelUtils.getSashModel((ModelSet)this.request.getModelSet()).getResource();
        }
        return sashResource;
    }

    protected SashWindowsMngr createSashWindowsMngr(Collection<EObject> openables) throws SashEditorException, ServiceException {
        SashWindowsMngr windowsMngr = DiUtils.createDefaultSashWindowsMngr();
        Resource rootSashModel = SashModelUtils.getSashModel((ModelSet)this.request.getModelSet()).getResource();
        SashWindowsMngr rootSashMngr = DiUtils.lookupSashWindowsMngr((Resource)rootSashModel);
        if (rootSashMngr == null) {
            rootSashMngr = DiUtils.createDefaultSashWindowsMngr();
            rootSashModel.getContents().add((Object)rootSashMngr);
        }
        for (EObject openable : openables) {
            PageRef pageRef = this.getPageRef(rootSashMngr, openable);
            if (pageRef == null) continue;
            windowsMngr.getSashModel().addPage(windowsMngr.getSashModel().getCurrentSelection(), pageRef.getPageIdentifier());
        }
        rootSashModel.setModified(!openables.isEmpty());
        return windowsMngr;
    }

    private PageRef getPageRef(SashWindowsMngr sashWindowsManager, EObject emfPageIdentifier) {
        PageRef pageRef = null;
        boolean match = false;
        Iterator windowsIterator = sashWindowsManager.getSashModel().getWindows().iterator();
        while (!match && windowsIterator.hasNext()) {
            Window window = (Window)windowsIterator.next();
            Iterator panelIterator = window.getChildren().iterator();
            while (!match && panelIterator.hasNext()) {
                pageRef = this.parsePanel((AbstractPanel)panelIterator.next(), emfPageIdentifier);
                boolean bl = match = pageRef != null;
            }
        }
        return pageRef;
    }

    private PageRef parsePanel(AbstractPanel panel, EObject emfPageIdentifier) {
        PageRef pageRef = null;
        if (panel instanceof TabFolder) {
            pageRef = this.parseTabFolder((TabFolder)panel, emfPageIdentifier);
        } else if (panel instanceof SashPanel) {
            Iterator panelIterator = ((SashPanel)panel).getChildren().iterator();
            while (pageRef == null && panelIterator.hasNext()) {
                pageRef = this.parsePanel((AbstractPanel)panelIterator.next(), emfPageIdentifier);
            }
        }
        return pageRef;
    }

    private PageRef parseTabFolder(TabFolder panel, EObject emfPageIdentifier) {
        PageRef pageRef = null;
        boolean match = false;
        Iterator pageRefsIterator = panel.getChildren().iterator();
        while (!match && pageRefsIterator.hasNext()) {
            PageRef currentPage = (PageRef)pageRefsIterator.next();
            boolean bl = match = currentPage.getEmfPageIdentifier() != null && emfPageIdentifier.equals(currentPage.getEmfPageIdentifier());
            if (!match) continue;
            pageRef = currentPage;
        }
        return pageRef;
    }
}

