/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.listener;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.papyrus.infra.core.resource.IModelSetSnippet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ResourceAdapter;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.utils.TransactionHelper;
import org.eclipse.papyrus.infra.services.controlmode.commands.LoadDiagramCommand;

public class LoadResourceSnippet
implements IModelSetSnippet {
    private LoadResourceAdapter adapter;

    public void start(ModelSet startingModel) {
        this.adapter = new LoadResourceAdapter();
        startingModel.eAdapters().add((Object)this.adapter);
    }

    public void dispose(ModelSet stoppingModel) {
        stoppingModel.eAdapters().remove((Object)this.adapter);
        this.adapter = null;
    }

    private class LoadResourceAdapter
    extends ResourceAdapter {
        private LoadResourceAdapter() {
        }

        protected void handleResourceLoaded(Resource resource) {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)resource);
            LoadDiagramCommand loadCommand = new LoadDiagramCommand(resource);
            try {
                TransactionHelper.run((EditingDomain)editingDomain, (Runnable)loadCommand);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (RollbackException rollbackException) {
                // empty catch block
            }
        }
    }
}

