/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.participants;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.CreateControlResource;
import org.eclipse.papyrus.infra.services.controlmode.commands.RemoveControlResourceCommand;
import org.eclipse.papyrus.infra.services.controlmode.messages.Messages;
import org.eclipse.papyrus.infra.services.controlmode.participants.IControlCommandParticipant;
import org.eclipse.papyrus.infra.services.controlmode.participants.IUncontrolCommandParticipant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSatelliteResourceParticipant
implements IControlCommandParticipant,
IUncontrolCommandParticipant {
    private static final String POST_CONTROL_COMMAND_TITLE = Messages.getString("AbstractSatelliteResourceParticipant.control.post.label");
    private static final String PRE_CONTROL_COMMAND_TITLE = Messages.getString("AbstractSatelliteResourceParticipant.control.pre.label");
    private static final String POST_UNCONTROL_COMMAND_TITLE = Messages.getString("AbstractSatelliteResourceParticipant.uncontrol.post.label");
    private static final String PRE_UNCONTROL_COMMAND_TITLE = Messages.getString("AbstractSatelliteResourceParticipant.uncontrol.pre.label");
    private static final String COMMAND_LABEL = Messages.getString("AbstractSatelliteResourceParticipant.command.title");

    protected abstract String getResourceFileExtension();

    protected abstract String getParticipantLabel();

    protected abstract boolean createNewResource();

    protected abstract boolean deleteOldResource();

    @Override
    public boolean provideUnControlCommand(ControlModeRequest request) {
        return request.getTargetObject() != null;
    }

    protected String getCorrectCompositeLabel(String type) {
        return Messages.getString(COMMAND_LABEL, type, this.getParticipantLabel());
    }

    protected CompositeTransactionalCommand createCompositeTransactionalCommand(ControlModeRequest request, String type) {
        return new CompositeTransactionalCommand(request.getEditingDomain(), this.getCorrectCompositeLabel(type));
    }

    @Override
    public ICommand getPreUncontrolCommand(ControlModeRequest request) {
        boolean result = this.setSatelliteTargetRequest(request);
        if (result) {
            CompositeTransactionalCommand cc = this.createCompositeTransactionalCommand(request, PRE_UNCONTROL_COMMAND_TITLE);
            for (ICommand cmd : this.getPreUncontrolCommands(request)) {
                cc.compose((IUndoableOperation)cmd);
            }
            if (!cc.isEmpty()) {
                return cc;
            }
            return null;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected abstract List<ICommand> getPreUncontrolCommands(ControlModeRequest var1);

    @Override
    public ICommand getPostUncontrolCommand(ControlModeRequest request) {
        CompositeTransactionalCommand cc = this.createCompositeTransactionalCommand(request, POST_UNCONTROL_COMMAND_TITLE);
        for (ICommand cmd : this.getPostUncontrolCommands(request)) {
            cc.compose((IUndoableOperation)cmd);
        }
        if (this.deleteOldResource()) {
            cc.compose((IUndoableOperation)new RemoveControlResourceCommand(request, this.getResourceFileExtension()));
        }
        if (!cc.isEmpty()) {
            return cc;
        }
        return null;
    }

    protected abstract List<ICommand> getPostUncontrolCommands(ControlModeRequest var1);

    @Override
    public boolean provideControlCommand(ControlModeRequest request) {
        return request.getTargetObject() != null;
    }

    @Override
    public ICommand getPreControlCommand(ControlModeRequest request) {
        CompositeTransactionalCommand cc = this.createCompositeTransactionalCommand(request, PRE_CONTROL_COMMAND_TITLE);
        for (ICommand cmd : this.getPreControlCommands(request)) {
            cc.compose((IUndoableOperation)cmd);
        }
        if (!cc.isEmpty()) {
            return cc;
        }
        return null;
    }

    protected abstract List<ICommand> getPreControlCommands(ControlModeRequest var1);

    @Override
    public ICommand getPostControlCommand(ControlModeRequest request) {
        CompositeTransactionalCommand cc = this.createCompositeTransactionalCommand(request, POST_CONTROL_COMMAND_TITLE);
        if (this.createNewResource()) {
            cc.compose((IUndoableOperation)new CreateControlResource(request, this.getResourceFileExtension()));
        }
        for (ICommand cmd : this.getPostControlCommands(request)) {
            cc.compose((IUndoableOperation)cmd);
        }
        if (!cc.isEmpty()) {
            return cc;
        }
        return null;
    }

    protected abstract List<ICommand> getPostControlCommands(ControlModeRequest var1);

    protected boolean setSatelliteTargetRequest(ControlModeRequest request) {
        URI satelliteResourceURI = request.getNewURI().trimFileExtension().appendFileExtension(this.getResourceFileExtension());
        ModelSet modelSet = request.getModelSet();
        if (modelSet != null) {
            Resource satelliteResource = null;
            try {
                satelliteResource = modelSet.getResource(satelliteResourceURI, true);
            }
            catch (Exception e) {
                satelliteResource = null;
            }
            if (satelliteResource == null) {
                return false;
            }
            request.setTargetResource(satelliteResource, this.getResourceFileExtension());
            return true;
        }
        return false;
    }
}

