/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.services.controlmode.service.IUncontrolledObjectsProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UncontrolledObjectsProvider
implements IUncontrolledObjectsProvider {
    private Map<Resource, List<EObject>> uncontrolledEObjectMap = new HashMap<Resource, List<EObject>>();

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
    }

    public void startService() throws ServiceException {
    }

    public void disposeService() throws ServiceException {
        this.uncontrolledEObjectMap = null;
    }

    @Override
    public void addUncontrolledObject(Resource resource, EObject uncontroledObject) {
        List<EObject> uncontrolledObjectList = this.uncontrolledEObjectMap.get(resource);
        if (uncontrolledObjectList == null) {
            uncontrolledObjectList = new ArrayList<EObject>();
        }
        uncontrolledObjectList.add(uncontroledObject);
        this.uncontrolledEObjectMap.put(resource, uncontrolledObjectList);
    }

    @Override
    public void clear() {
        this.uncontrolledEObjectMap.clear();
    }

    @Override
    public Iterator<Resource> getResources() {
        return this.uncontrolledEObjectMap.keySet().iterator();
    }

    @Override
    public List<EObject> getResourceUncontrolledObject(Resource resource) {
        return this.uncontrolledEObjectMap.get(resource);
    }

    @Override
    public boolean hasUncontrolledObjects() {
        return !this.uncontrolledEObjectMap.isEmpty();
    }
}

