/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.validation.preferences;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.services.validation.Activator;
import org.eclipse.papyrus.infra.services.validation.Messages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public PreferencePage() {
        super(1);
    }

    public void createFieldEditors() {
        String[][] selection = new String[][]{{"&No", "NO"}, {"&Direct parent", "DIRECT"}, {"&All parents", "ALL"}};
        this.addField((FieldEditor)new RadioGroupFieldEditor("org.eclipse.papyrus.infra.services.validation.HierarchicalMarkers", Messages.PreferencePage_MarkParents, 1, selection, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("org.eclipse.papyrus.infra.services.validation.AutoShowValidationView", Messages.PreferencePage_AutoOpenValidationView, this.getFieldEditorParent()));
    }

    protected void checkState() {
        super.checkState();
    }

    public boolean performOk() {
        boolean retCode = super.performOk();
        this.triggerRedraw();
        return retCode;
    }

    protected void performApply() {
        super.performApply();
        this.triggerRedraw();
    }

    protected void triggerRedraw() {
        IMultiDiagramEditor[] papyrusEditors;
        IMultiDiagramEditor[] iMultiDiagramEditorArray = papyrusEditors = EditorUtils.getMultiDiagramEditors();
        int n = papyrusEditors.length;
        int n2 = 0;
        while (n2 < n) {
            IMultiDiagramEditor papyrusEditor = iMultiDiagramEditorArray[n2];
            ServicesRegistry serviceRegistry = papyrusEditor.getServicesRegistry();
            if (serviceRegistry != null) {
                try {
                    ModelSet modelSet = (ModelSet)serviceRegistry.getService(ModelSet.class);
                    modelSet.eNotify((Notification)new NotificationImpl(1, new Object(), null));
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }
}

