/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.converter;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.tools.converter.ConvertedValueContainer;
import org.eclipse.papyrus.infra.tools.converter.IStringValueConverter;
import org.eclipse.papyrus.infra.tools.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStringValueConverter
implements IStringValueConverter {
    protected static final String THE_STRING_X_IS_NOT_VALID_TO_CREATE_Y = Messages.AbstractStringValueConverter_TheStringXIsNotValidToCreateY;
    protected static final String THE_FEATURE_X_CANT_BE_RESOLVED = Messages.AbstractStringValueConverter_TheFeatureXCantBeResolved;
    protected static final String THE_STRING_VALUE_X_CANT_BE_RESOLVED = Messages.AbstractStringValueConverter_TheStringValueXCantBeResolved;
    protected static final String SOME_STRING_ARE_NOT_VALID_TO_CREATE_X = Messages.AbstractStringValueConverter_SomeStringsAreNotValidToCreateY;
    protected static final String SOME_STRING_CANT_BE_RESOLVED_TO_FIND_X = Messages.AbstractStringValueConverter_SomeStringsCantBeResolvedToFindY;
    protected static final String NO_X_REPRESENTED_BY_Y_HAVE_BEEN_FOUND = Messages.AbstractStringValueConverter_NoXReprensentedByYHaveBeenFound;
    private ConvertedValueContainer<?> result;

    @Override
    public final ConvertedValueContainer<?> deduceValueFromString(Object type, String valueAsString) {
        this.result = this.doDeduceValueFromString(type, valueAsString);
        if (this.result == null) {
            Status status = new Status(4, "org.eclipse.papyrus.infra.tools", NLS.bind((String)THE_STRING_VALUE_X_CANT_BE_RESOLVED, (Object)valueAsString));
            this.result = new ConvertedValueContainer<Object>(null, (IStatus)status);
        }
        return this.result;
    }

    public final ConvertedValueContainer<?> getConvertedValue() {
        if (this.result == null) {
            throw new IllegalStateException("You should call deduceValueFromString before to call this method");
        }
        return this.result;
    }

    protected abstract ConvertedValueContainer<?> doDeduceValueFromString(Object var1, String var2);
}

