/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.databinding;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.papyrus.infra.tools.databinding.DelegatingObservable;
import org.eclipse.papyrus.infra.tools.databinding.IDelegatingObservable;
import org.eclipse.papyrus.infra.tools.databinding.ReferenceCountedObservable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DelegatingInvocationHandler
implements InvocationHandler {
    private final IDelegatingObservable delegator;
    private final Class<? extends IObservable> delegatedInterface;

    private DelegatingInvocationHandler(IDelegatingObservable delegator, Class<? extends IObservable> delegatedInterface) {
        this.delegator = delegator;
        this.delegatedInterface = delegatedInterface;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends IObservable> T wrap(IDelegatingObservable delegator, Class<T> delegatedInterface) {
        Object result;
        ArrayList<Class<T>> mixins = null;
        IObservable delegate = delegator.getDelegate();
        for (Class<T> clazz : DelegatingInvocationHandler.allInterfaces(delegate.getClass())) {
            if (clazz.isAssignableFrom(delegatedInterface)) continue;
            if (mixins == null) {
                mixins = new ArrayList<Class<T>>(1);
            }
            mixins.add(clazz);
        }
        if (mixins == null) {
            result = (IObservable)delegatedInterface.cast(delegator);
        } else {
            void var5_10;
            ClassLoader classLoader = delegator.getDelegate().getClass().getClassLoader();
            try {
                if (classLoader.loadClass(IDelegatingObservable.class.getName()) != IDelegatingObservable.class) {
                    ClassLoader classLoader2 = DelegatingInvocationHandler.class.getClassLoader();
                }
            }
            catch (Exception e) {
                ClassLoader classLoader3 = DelegatingInvocationHandler.class.getClassLoader();
            }
            result = DelegatingInvocationHandler.wrap(delegator, delegatedInterface, (ClassLoader)var5_10, mixins.toArray(new Class[mixins.size()]));
        }
        return (T)result;
    }

    static Set<Class<?>> allInterfaces(Class<?> clazz) {
        HashSet result = new HashSet();
        DelegatingInvocationHandler.collectAllInterfaces(clazz, result);
        return result;
    }

    private static void collectAllInterfaces(Class<?> clazz, Collection<Class<?>> result) {
        Class<?>[] interfaces = clazz.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            result.add(interfaces[i]);
            ++i;
        }
        Class<?> zuper = clazz.getSuperclass();
        if (zuper != null) {
            DelegatingInvocationHandler.collectAllInterfaces(zuper, result);
        }
    }

    public static <T extends IObservable> T wrap(IDelegatingObservable delegator, Class<T> delegatedInterface, ClassLoader loader, Class<?> ... mixins) {
        IObservable result;
        if (loader == null || mixins.length == 0) {
            result = (IObservable)delegatedInterface.cast(delegator);
        } else {
            ArrayList interfaces = new ArrayList(mixins.length + 2);
            interfaces.add(delegatedInterface);
            interfaces.add(IDelegatingObservable.class);
            interfaces.addAll(Arrays.asList(mixins));
            DelegatingInvocationHandler handler = new DelegatingInvocationHandler(delegator, delegatedInterface);
            result = (IObservable)delegatedInterface.cast(Proxy.newProxyInstance(loader, interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)handler));
            ((DelegatingObservable)delegator).setRealObservable(result);
        }
        return (T)result;
    }

    static <T extends IObservable> T wrapDynamicProxy(T proxy) throws Exception {
        DelegatingInvocationHandler proxyHandler = (DelegatingInvocationHandler)Proxy.getInvocationHandler(proxy);
        DelegatingObservable proxyDelegator = (DelegatingObservable)proxyHandler.delegator;
        DelegatingObservable delegator = (DelegatingObservable)proxyDelegator.getClass().getDeclaredConstructor(proxyHandler.delegatedInterface).newInstance(proxy);
        DelegatingInvocationHandler handler = new DelegatingInvocationHandler(delegator, proxyHandler.delegatedInterface);
        return (T)((IObservable)proxy.getClass().getDeclaredConstructor(InvocationHandler.class).newInstance(handler));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        Class<? extends IObservable> owner = method.getDeclaringClass();
        try {
            result = owner == this.delegatedInterface || owner == IDelegatingObservable.class || owner == ReferenceCountedObservable.class || owner == Object.class || owner.isAssignableFrom(this.delegatedInterface) ? method.invoke((Object)this.delegator, args) : method.invoke((Object)this.delegator.getDelegate(), args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return result;
    }
}

