/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForHandlers;

public abstract class AbstractCommonCommandHandler
extends AbstractHandler {
    protected List<?> selection = Collections.EMPTY_LIST;

    protected abstract List<EObject> getSelectedElements();

    public abstract Object execute(ExecutionEvent var1) throws ExecutionException;

    protected TransactionalEditingDomain getEditingDomain(ExecutionEvent event) {
        try {
            return ServiceUtilsForHandlers.getInstance().getTransactionalEditingDomain((Object)event);
        }
        catch (ServiceException ex) {
            return null;
        }
    }

    public void setEnabled(Object evaluationContext) {
        if (evaluationContext instanceof IEvaluationContext) {
            Object selection = ((IEvaluationContext)evaluationContext).getVariable("selection");
            if (selection instanceof Collection) {
                this.selection = selection instanceof List ? (List)selection : new ArrayList((Collection)selection);
            } else if (selection instanceof IStructuredSelection) {
                this.selection = ((IStructuredSelection)selection).toList();
            }
            this.setBaseEnabled(this.computeEnabled());
            this.selection = Collections.EMPTY_LIST;
        }
        super.setEnabled(evaluationContext);
    }

    protected boolean computeEnabled() {
        List<EObject> elts = this.getSelectedElements();
        return elts.size() != 0;
    }

    protected List<?> getSelection() {
        return this.selection;
    }

    public boolean isVisible() {
        return this.isEnabled();
    }
}

