/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.sysml.service.types.utils.AssociationUtils;
import org.eclipse.papyrus.sysml.service.types.utils.ConnectorUtils;
import org.eclipse.papyrus.uml.diagram.common.helper.CreateOrShowExistingElementHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.common.util.LinkEndsMapper;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class SysMLCreateOrShowExistingElementHelper
extends CreateOrShowExistingElementHelper {
    public SysMLCreateOrShowExistingElementHelper() {
    }

    public SysMLCreateOrShowExistingElementHelper(ILinkMappingHelper linkHelper) {
        super(linkHelper);
    }

    protected String getIElementTypeNameToDisplay(IElementType elementType) {
        if (SysMLElementTypes.ASSOCIATION_NONE.equals(elementType) || SysMLElementTypes.ASSOCIATION_NONE_DIRECTED.equals(elementType)) {
            return "Association/DirectAssociation";
        }
        if (SysMLElementTypes.ASSOCIATION_COMPOSITE.equals(elementType) || SysMLElementTypes.ASSOCIATION_COMPOSITE_DIRECTED.equals(elementType)) {
            return "Composition/DirectComposition";
        }
        if (SysMLElementTypes.ASSOCIATION_SHARED.equals(elementType) || SysMLElementTypes.ASSOCIATION_SHARED_DIRECTED.equals(elementType)) {
            return "Aggregation/DirectAggregation";
        }
        return super.getIElementTypeNameToDisplay(elementType);
    }

    protected boolean hasWantedType(EObject eobject, IElementType wantedType) {
        boolean result = super.hasWantedType(eobject, wantedType);
        if (result && eobject instanceof Association) {
            Association association = (Association)eobject;
            if (association.getMemberEnds().size() < 2) {
                return false;
            }
            AggregationKind current = SysMLCreateOrShowExistingElementHelper.getAssociationAggregationKind((Association)eobject);
            if (current == AggregationKind.NONE_LITERAL) {
                if (SysMLElementTypes.ASSOCIATION_NONE.equals(current) || SysMLElementTypes.ASSOCIATION_NONE_DIRECTED.equals(wantedType)) {
                    result = true;
                }
            } else if (current == AggregationKind.COMPOSITE_LITERAL) {
                if (SysMLElementTypes.ASSOCIATION_COMPOSITE.equals(current) || SysMLElementTypes.ASSOCIATION_COMPOSITE_DIRECTED.equals(wantedType)) {
                    result = true;
                }
            } else if (current == AggregationKind.SHARED_LITERAL) {
                if (SysMLElementTypes.ASSOCIATION_SHARED.equals(current) || SysMLElementTypes.ASSOCIATION_SHARED_DIRECTED.equals(wantedType)) {
                    result = true;
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    private static final AggregationKind getAssociationAggregationKind(Association association) {
        if (association.getMemberEnds().size() < 2) {
            return AggregationKind.NONE_LITERAL;
        }
        Property source = (Property)association.getMemberEnds().get(0);
        Property target = (Property)association.getMemberEnds().get(1);
        if (source.getAggregation() == AggregationKind.NONE_LITERAL && target.getAggregation() == AggregationKind.NONE_LITERAL) {
            return AggregationKind.NONE_LITERAL;
        }
        if (source.getAggregation() == AggregationKind.COMPOSITE_LITERAL || target.getAggregation() == AggregationKind.COMPOSITE_LITERAL) {
            return AggregationKind.COMPOSITE_LITERAL;
        }
        return AggregationKind.SHARED_LITERAL;
    }

    protected List<LinkEndsMapper> getExistingLinksBetweenSourceAndTarget(CreateRelationshipRequest request, IElementType wantedElementType) {
        List<LinkEndsMapper> existingElement = null;
        EClass wantedEClass = wantedElementType.getEClass();
        if (UMLPackage.eINSTANCE.getConnector().equals(wantedEClass)) {
            EList ownedElements = ((Element)request.getContainer()).getOwnedElements();
            existingElement = new ArrayList();
            for (Element current : ownedElements) {
                View targetView;
                View sourceView;
                boolean canBeDisplayed;
                if (!this.hasWantedType((EObject)current, wantedElementType)) continue;
                Collection sources = this.linkMappingHelper.getSource(current);
                Collection targets = this.linkMappingHelper.getTarget(current);
                if (!sources.contains(request.getSource()) || !targets.contains(request.getTarget()) || !(canBeDisplayed = ConnectorUtils.canDisplayExistingConnectorBetweenViewsAccordingToNestedPaths((Connector)((Connector)current), (View)(sourceView = (View)request.getParameter("SOURCE_GRAPHICAL_VIEW")), (View)(targetView = (View)request.getParameter("TARGET_GRAPHICAL_VIEW"))))) continue;
                existingElement.add(new LinkEndsMapper((EObject)current, sources, null, null));
            }
        } else if (UMLPackage.eINSTANCE.getAssociation().equals(wantedEClass)) {
            EList ownedElements = ((Element)request.getContainer()).getOwnedElements();
            existingElement = new ArrayList();
            for (Element current : ownedElements) {
                if (!this.hasWantedType((EObject)current, wantedElementType)) continue;
                Collection sources = this.linkMappingHelper.getSource(current);
                Collection targets = this.linkMappingHelper.getTarget(current);
                if (!sources.contains(request.getSource()) || !targets.contains(request.getTarget()) || !(current instanceof Association)) continue;
                boolean identicalAssociation = true;
                Iterator iterator = ((Association)current).getMemberEnds().iterator();
                while (iterator.hasNext() && identicalAssociation) {
                    Property property = (Property)iterator.next();
                    boolean source = request.getSource().equals(property.getType());
                    if (SysMLElementTypes.ASSOCIATION_NONE_DIRECTED.equals(wantedElementType)) {
                        if (AssociationUtils.isIdenticalProperties((boolean)false, (AggregationKind)AggregationKind.NONE_LITERAL, (boolean)source, (Property)property)) continue;
                        identicalAssociation = false;
                        continue;
                    }
                    if (SysMLElementTypes.ASSOCIATION_NONE.equals(wantedElementType)) {
                        if (AssociationUtils.isIdenticalProperties((boolean)true, (AggregationKind)AggregationKind.NONE_LITERAL, (boolean)source, (Property)property)) continue;
                        identicalAssociation = false;
                        continue;
                    }
                    if (SysMLElementTypes.ASSOCIATION_COMPOSITE_DIRECTED.equals(wantedElementType)) {
                        if (AssociationUtils.isIdenticalProperties((boolean)false, (AggregationKind)AggregationKind.COMPOSITE_LITERAL, (boolean)source, (Property)property)) continue;
                        identicalAssociation = false;
                        continue;
                    }
                    if (SysMLElementTypes.ASSOCIATION_COMPOSITE.equals(wantedElementType)) {
                        if (AssociationUtils.isIdenticalProperties((boolean)true, (AggregationKind)AggregationKind.COMPOSITE_LITERAL, (boolean)source, (Property)property)) continue;
                        identicalAssociation = false;
                        continue;
                    }
                    if (SysMLElementTypes.ASSOCIATION_SHARED_DIRECTED.equals(wantedElementType)) {
                        if (AssociationUtils.isIdenticalProperties((boolean)false, (AggregationKind)AggregationKind.SHARED_LITERAL, (boolean)source, (Property)property)) continue;
                        identicalAssociation = false;
                        continue;
                    }
                    if (!SysMLElementTypes.ASSOCIATION_SHARED.equals(wantedElementType) || AssociationUtils.isIdenticalProperties((boolean)true, (AggregationKind)AggregationKind.SHARED_LITERAL, (boolean)source, (Property)property)) continue;
                    identicalAssociation = false;
                }
                if (!identicalAssociation) continue;
                existingElement.add(new LinkEndsMapper((EObject)current, sources, null, null));
            }
        } else {
            existingElement = super.getExistingLinksBetweenSourceAndTarget(request, wantedElementType);
        }
        return existingElement;
    }
}

