/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.validation;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.uml.alf.AlfPackage;
import org.eclipse.papyrus.uml.alf.AnnotatedStatement;
import org.eclipse.papyrus.uml.alf.Expression;
import org.eclipse.papyrus.uml.alf.FeatureReference;
import org.eclipse.papyrus.uml.alf.NameBinding;
import org.eclipse.papyrus.uml.alf.PropertyAccessExpression;
import org.eclipse.papyrus.uml.alf.SequenceAccessExpression;
import org.eclipse.papyrus.uml.alf.validation.AbstractAlfValidator;
import org.eclipse.xtext.validation.Check;

public class AlfValidator
extends AbstractAlfValidator {
    @Override
    public List<EPackage> getEPackages() {
        ArrayList<EPackage> list = new ArrayList<EPackage>();
        list.add(AlfPackage.eINSTANCE);
        return list;
    }

    @Check
    public void checkFeatureReference(FeatureReference featureReference) {
        NameBinding _nameBinding = featureReference.getNameBinding();
        boolean _equals = Objects.equal((Object)_nameBinding, null);
        if (_equals) {
            Expression expression = featureReference.getExpression();
            if (expression instanceof SequenceAccessExpression) {
                Expression _primary;
                expression = _primary = ((SequenceAccessExpression)expression).getPrimary();
            }
            if (!(expression instanceof PropertyAccessExpression)) {
                EReference _featureReference_Expression = AlfPackage.eINSTANCE.getFeatureReference_Expression();
                this.error("Not a legal left-hand side", (EStructuralFeature)_featureReference_Expression);
            }
        }
    }

    @Check
    public void checkAnnotatedStatement(AnnotatedStatement statement) {
        EList<String> _annotation = statement.getAnnotation();
        for (String text : _annotation) {
            boolean _not;
            Boolean _isAnnotation = AlfValidator.isAnnotation(text);
            boolean bl = _not = _isAnnotation == false;
            if (!_not) continue;
            EAttribute _annotatedStatement_Annotation = AlfPackage.eINSTANCE.getAnnotatedStatement_Annotation();
            this.error("Invalid annotation", (EStructuralFeature)_annotatedStatement_Annotation);
        }
    }

    public static Boolean isAnnotation(String text) {
        String[] _split;
        String _replaceAll = text.replaceAll("[ \f\r\t\n]", "");
        String _substring = _replaceAll.substring(3);
        String[] stringArray = _split = _substring.split("@", -1);
        int n = _split.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _not;
            String annotation = stringArray[n2];
            int i = annotation.indexOf("(");
            String _xifexpression = null;
            _xifexpression = i < 0 ? annotation : annotation.substring(0, i);
            String identifier = _xifexpression;
            Boolean _isIdentifier = AlfValidator.isIdentifier(identifier);
            boolean bl = _not = _isIdentifier == false;
            if (_not) {
                return false;
            }
            if (i >= 0) {
                String[] _split_1;
                int _length;
                int _minus;
                boolean _notEquals;
                int j = annotation.indexOf(")");
                boolean bl2 = _notEquals = j != (_minus = (_length = annotation.length()) - 1);
                if (_notEquals) {
                    return false;
                }
                String _substring_1 = annotation.substring(i + 1, j);
                String[] stringArray2 = _split_1 = _substring_1.split(",", -1);
                int n3 = _split_1.length;
                int n4 = 0;
                while (n4 < n3) {
                    boolean _not_1;
                    String argument = stringArray2[n4];
                    boolean _or = false;
                    Boolean _isIdentifier_1 = AlfValidator.isIdentifier(argument);
                    if (_isIdentifier_1.booleanValue()) {
                        _or = true;
                    } else {
                        Boolean _isUnrestrictedName = AlfValidator.isUnrestrictedName(argument);
                        _or = _isUnrestrictedName;
                    }
                    boolean bl3 = _not_1 = !_or;
                    if (_not_1) {
                        return false;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return true;
    }

    public static Boolean isIdentifier(String text) {
        return text.matches("[a-zA-z_][a-zA-z_0-9]*");
    }

    public static Boolean isUnrestrictedName(String text) {
        return text.matches("'(\\\\[btnfr\"'\\\\]|[^\\\\']*)'");
    }
}

