/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.canonical;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.canonical.strategy.ICreationTargetStrategy;
import org.eclipse.uml2.uml.ActivityEdge;

public class ActivityCanonicalCreationTargetStrategy
implements ICreationTargetStrategy {
    private static final Map<String, String> CONTENT_COMPARTMENT_VISUAL_IDS = ImmutableMap.builder().put((Object)Integer.toString(2001), (Object)Integer.toString(7004)).put((Object)Integer.toString(3083), (Object)Integer.toString(7013)).put((Object)Integer.toString(3069), (Object)Integer.toString(7008)).put((Object)Integer.toString(3070), (Object)Integer.toString(7009)).put((Object)Integer.toString(3071), (Object)Integer.toString(7010)).put((Object)Integer.toString(3073), (Object)Integer.toString(7012)).put((Object)Integer.toString(3065), (Object)Integer.toString(7005)).put((Object)Integer.toString(3067), (Object)Integer.toString(7006)).put((Object)Integer.toString(3068), (Object)Integer.toString(7007)).build();

    public EditPart getTargetEditPart(EditPart host, EObject element) {
        EditPart result = null;
        if (element instanceof ActivityEdge) {
            EditPart candidate = host;
            while (result == null && candidate != null) {
                if (candidate instanceof IResizableCompartmentEditPart) {
                    result = candidate;
                } else {
                    View view = (View)host.getModel();
                    String visualID = view == null ? null : view.getType();
                    String compartmentID = CONTENT_COMPARTMENT_VISUAL_IDS.get(visualID);
                    if (compartmentID != null) {
                        result = ((IGraphicalEditPart)host).getChildBySemanticHint(compartmentID);
                    }
                }
                candidate = candidate.getParent();
            }
        }
        return result;
    }
}

