/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.actions;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.uml.diagram.activity.edit.commands.RestoreRelatedLinksCommand;
import org.eclipse.papyrus.uml.diagram.common.actions.AbstractAction;

public class RestoreRelatedLinksAction
extends AbstractAction {
    public static String ID = "papyrus.restoreRelatedLinksAction";

    public RestoreRelatedLinksAction() {
        this.setId(ID);
        this.setText("Restore Related Elements");
        this.setToolTipText("Restore Related Elements");
    }

    protected String getDiagramNotationID() {
        return "PapyrusUMLActivityDiagram";
    }

    public boolean isEnabled() {
        Diagram currentDiagram = this.getCurrentDiagram();
        if (currentDiagram != null) {
            return !this.getSelection().isEmpty() && this.getDiagramNotationID().equals(currentDiagram.getType());
        }
        return false;
    }

    public void run() {
        List selection = this.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!(this.getHost() instanceof DiagramEditPart)) {
            return;
        }
        DiagramEditPart diagramEditPart = (DiagramEditPart)this.getHost();
        DiagramCommandStack commandStack = this.getHost().getDiagramEditDomain().getDiagramCommandStack();
        CompoundCommand cmd = new CompoundCommand("Restore Related Links");
        cmd.add((Command)new ICommandProxy((ICommand)new RestoreRelatedLinksCommand(diagramEditPart, selection)));
        commandStack.execute((Command)cmd, (IProgressMonitor)new NullProgressMonitor());
    }
}

