/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.parts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultCreationEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultGraphicalNodeEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultSemanticEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RoundedRectangleNodePlateFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SelectableBorderedNodeFigure;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.InputPinInReadStructuralFeatureAsObjectEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.OutputPinInReadStructuralFeatureAsResultEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ReadStructuralFeatureActionFloatingNameEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ReadStructuralFeatureActionNameEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.ActivityDiagramChangeStereotypedShapeEditpolicy;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.CreateActionLocalConditionEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.CustomDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.DeleteActionViewEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.OpenDiagramEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.locator.PinPositionLocator;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.common.editparts.RoundedCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.RoundedCompartmentFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class ReadStructuralFeatureActionEditPart
extends RoundedCompartmentEditPart {
    public static final int VISUAL_ID = 3088;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public ReadStructuralFeatureActionEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new DefaultCreationEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DefaultSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new DefaultGraphicalNodeEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DragDropEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenDiagramEditPolicy());
        this.installEditPolicy("create child", (EditPolicy)new CreateActionLocalConditionEditPolicy());
        this.installEditPolicy("delete", (EditPolicy)new DeleteActionViewEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeNodeLabelDisplayEditPolicy());
        this.installEditPolicy("CHANGE_SHAPE_POLICY", (EditPolicy)new ActivityDiagramChangeStereotypedShapeEditpolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new CustomDiagramDragDropEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                View childView = (View)child.getModel();
                switch (UMLVisualIDRegistry.getVisualID(childView)) {
                    case 6023: {
                        return new BorderItemSelectionEditPolicy(){

                            protected List<?> createSelectionHandles() {
                                MoveHandle mh = new MoveHandle((GraphicalEditPart)this.getHost());
                                mh.setBorder(null);
                                return Collections.singletonList(mh);
                            }
                        };
                    }
                    case 3089: 
                    case 3090: {
                        return new BorderItemResizableEditPolicy();
                    }
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected org.eclipse.gef.commands.Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected org.eclipse.gef.commands.Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new RoundedCompartmentFigure();
        return this.primaryShape;
    }

    public RoundedCompartmentFigure getPrimaryShape() {
        return (RoundedCompartmentFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ReadStructuralFeatureActionNameEditPart) {
            ((ReadStructuralFeatureActionNameEditPart)childEditPart).setLabel((IFigure)this.getPrimaryShape().getNameLabel());
            return true;
        }
        if (childEditPart instanceof InputPinInReadStructuralFeatureAsObjectEditPart) {
            PinPositionLocator locator = new PinPositionLocator(this.getMainFigure(), 1);
            this.getBorderedFigure().getBorderItemContainer().add(((InputPinInReadStructuralFeatureAsObjectEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        if (childEditPart instanceof OutputPinInReadStructuralFeatureAsResultEditPart) {
            PinPositionLocator locator = new PinPositionLocator(this.getMainFigure(), 4);
            this.getBorderedFigure().getBorderItemContainer().add(((OutputPinInReadStructuralFeatureAsResultEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ReadStructuralFeatureActionNameEditPart) {
            return true;
        }
        if (childEditPart instanceof InputPinInReadStructuralFeatureAsObjectEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((InputPinInReadStructuralFeatureAsObjectEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof OutputPinInReadStructuralFeatureAsResultEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((OutputPinInReadStructuralFeatureAsResultEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return this.getContentPane();
    }

    protected void addBorderItem(IFigure borderItemContainer, IBorderItemEditPart borderItemEditPart) {
        if (borderItemEditPart instanceof ReadStructuralFeatureActionFloatingNameEditPart) {
            BorderItemLocator locator = new BorderItemLocator(this.getMainFigure(), 4);
            locator.setBorderItemOffset(new Dimension(-20, -20));
            borderItemContainer.add(borderItemEditPart.getFigure(), (Object)locator);
        } else {
            super.addBorderItem(borderItemContainer, borderItemEditPart);
        }
    }

    protected NodeFigure createNodePlate() {
        RoundedRectangleNodePlateFigure result = new RoundedRectangleNodePlateFigure(40, 40);
        return result;
    }

    protected NodeFigure createMainFigure() {
        return new SelectableBorderedNodeFigure((IFigure)this.createMainFigureWithSVG());
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        super.setLineWidth(width);
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof IPapyrusNodeFigure) {
            ((IPapyrusNodeFigure)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(5153));
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        Object feature = notification.getFeature();
        if (UMLPackage.Literals.STRUCTURAL_FEATURE_ACTION__STRUCTURAL_FEATURE.equals(feature)) {
            Object result = this.resolveSemanticElement().eGet((EStructuralFeature)UMLPackage.Literals.READ_STRUCTURAL_FEATURE_ACTION__RESULT);
            Object object = this.resolveSemanticElement().eGet((EStructuralFeature)UMLPackage.Literals.STRUCTURAL_FEATURE_ACTION__OBJECT);
            Object _feature = notification.getNewValue();
            if (_feature instanceof StructuralFeature) {
                Element owner;
                Command cmdSetResultType = null;
                Command cmdSetObjectType = null;
                StructuralFeature newFeature = (StructuralFeature)_feature;
                Type type = newFeature.getType();
                if (type != null) {
                    cmdSetResultType = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)result, (Object)UMLPackage.Literals.TYPED_ELEMENT__TYPE, (Object)type);
                }
                if ((owner = newFeature.getOwner()) != null) {
                    cmdSetObjectType = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)object, (Object)UMLPackage.Literals.TYPED_ELEMENT__TYPE, (Object)owner);
                }
                try {
                    CommandStack commandStack;
                    if (cmdSetResultType != null && cmdSetResultType.canExecute()) {
                        commandStack = this.getEditingDomain().getCommandStack();
                        if (commandStack instanceof TransactionalCommandStack) {
                            ((TransactionalCommandStack)commandStack).execute(cmdSetResultType, Collections.singletonMap("unprotected", Boolean.TRUE));
                        } else {
                            commandStack.execute(cmdSetResultType);
                        }
                    }
                    if (cmdSetObjectType != null && cmdSetObjectType.canExecute()) {
                        commandStack = this.getEditingDomain().getCommandStack();
                        if (commandStack instanceof TransactionalCommandStack) {
                            ((TransactionalCommandStack)commandStack).execute(cmdSetObjectType, Collections.singletonMap("unprotected", Boolean.TRUE));
                        } else {
                            commandStack.execute(cmdSetObjectType);
                        }
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (RollbackException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

