/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;
import org.eclipse.papyrus.uml.diagram.activity.expressions.UMLOCLFactory;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.ActionInputPin;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.CreateLinkAction;
import org.eclipse.uml2.uml.CreateLinkObjectAction;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.ExpansionNode;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.IntervalConstraint;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValuePin;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.uml.diagram.activity/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PapyrusUMLActivityDiagram".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        return 1000;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLActivityDiagram".equals(containerModelID)) {
            return -1;
        }
        if ("PapyrusUMLActivityDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (!UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) break;
                return 2001;
            }
            case 2001: {
                if (!UMLPackage.eINSTANCE.getActivityParameterNode().isSuperTypeOf(domainElement.eClass())) break;
                return 3059;
            }
            case 3007: {
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass())) {
                    return 3015;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3016;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 3008: {
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass())) {
                    return 3017;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3018;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3019;
                }
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3020;
            }
            case 3010: {
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3021((ActionInputPin)domainElement)) {
                    return 3021;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3022((ValuePin)domainElement)) {
                    return 3022;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3023((InputPin)domainElement)) {
                    return 3023;
                }
                if (UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3024;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3025((ValuePin)domainElement)) {
                    return 3025;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3026((ActionInputPin)domainElement)) {
                    return 3026;
                }
                if (!UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isInputPin_3027((InputPin)domainElement)) break;
                return 3027;
            }
            case 3042: {
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3046((ValuePin)domainElement)) {
                    return 3046;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3047((ActionInputPin)domainElement)) {
                    return 3047;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3048((InputPin)domainElement)) {
                    return 3048;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3049((ValuePin)domainElement)) {
                    return 3049;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3050((ActionInputPin)domainElement)) {
                    return 3050;
                }
                if (!UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isInputPin_3051((InputPin)domainElement)) break;
                return 3051;
            }
            case 3052: {
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3053((ActionInputPin)domainElement)) {
                    return 3053;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3054((ValuePin)domainElement)) {
                    return 3054;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3055((InputPin)domainElement)) {
                    return 3055;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3060((ValuePin)domainElement)) {
                    return 3060;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3061((ActionInputPin)domainElement)) {
                    return 3061;
                }
                if (!UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isInputPin_3062((InputPin)domainElement)) break;
                return 3062;
            }
            case 3063: {
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3064;
            }
            case 3076: {
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3077;
            }
            case 3069: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3188((InputPin)domainElement)) {
                    return 3188;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3189((ValuePin)domainElement)) {
                    return 3189;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3190((ActionInputPin)domainElement)) {
                    return 3190;
                }
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3191;
            }
            case 3070: {
                if (UMLPackage.eINSTANCE.getExpansionNode().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isExpansionNode_3074((ExpansionNode)domainElement)) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getExpansionNode().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isExpansionNode_3075((ExpansionNode)domainElement)) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3188((InputPin)domainElement)) {
                    return 3188;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3189((ValuePin)domainElement)) {
                    return 3189;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3190((ActionInputPin)domainElement)) {
                    return 3190;
                }
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3191;
            }
            case 3071: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3105((InputPin)domainElement)) {
                    return 3105;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass())) {
                    return 3192;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3193;
                }
                if (UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isOutputPin_3109((OutputPin)domainElement)) {
                    return 3109;
                }
                if (UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isOutputPin_3110((OutputPin)domainElement)) {
                    return 3110;
                }
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isOutputPin_3111((OutputPin)domainElement)) break;
                return 3111;
            }
            case 3073: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3188((InputPin)domainElement)) {
                    return 3188;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3189((ValuePin)domainElement)) {
                    return 3189;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3190((ActionInputPin)domainElement)) {
                    return 3190;
                }
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3191;
            }
            case 3065: {
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3189((ValuePin)domainElement)) {
                    return 3189;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3190((ActionInputPin)domainElement)) {
                    return 3190;
                }
                if (UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3191;
                }
                if (!UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isInputPin_3188((InputPin)domainElement)) break;
                return 3188;
            }
            case 3081: {
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3084;
            }
            case 3083: {
                if (!UMLPackage.eINSTANCE.getActivityParameterNode().isSuperTypeOf(domainElement.eClass())) break;
                return 3059;
            }
            case 3086: {
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3087;
            }
            case 3088: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3089;
                }
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3090;
            }
            case 3091: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3092((InputPin)domainElement)) {
                    return 3092;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3093((InputPin)domainElement)) {
                    return 3093;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3181((InputPin)domainElement)) {
                    return 3181;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3182((ValuePin)domainElement)) {
                    return 3182;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3183((ValuePin)domainElement)) {
                    return 3183;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3184((ValuePin)domainElement)) {
                    return 3184;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3185((ActionInputPin)domainElement)) {
                    return 3185;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3186((ActionInputPin)domainElement)) {
                    return 3186;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3187((ActionInputPin)domainElement)) {
                    return 3187;
                }
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3094;
            }
            case 3095: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3096((InputPin)domainElement)) {
                    return 3096;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3173((ValuePin)domainElement)) {
                    return 3173;
                }
                if (!UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isActionInputPin_3174((ActionInputPin)domainElement)) break;
                return 3174;
            }
            case 3097: {
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isOutputPin_3098((OutputPin)domainElement)) break;
                return 3098;
            }
            case 3099: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3100((InputPin)domainElement)) {
                    return 3100;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3101((InputPin)domainElement)) {
                    return 3101;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3175((ValuePin)domainElement)) {
                    return 3175;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3176((ValuePin)domainElement)) {
                    return 3176;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3177((ActionInputPin)domainElement)) {
                    return 3177;
                }
                if (!UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isActionInputPin_3178((ActionInputPin)domainElement)) break;
                return 3178;
            }
            case 3102: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3103((InputPin)domainElement)) {
                    return 3103;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3179((ValuePin)domainElement)) {
                    return 3179;
                }
                if (!UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isActionInputPin_3180((ActionInputPin)domainElement)) break;
                return 3180;
            }
            case 3113: {
                if (UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3125;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3132((InputPin)domainElement)) {
                    return 3132;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3145((ValuePin)domainElement)) {
                    return 3145;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3158((ActionInputPin)domainElement)) {
                    return 3158;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3133((InputPin)domainElement)) {
                    return 3133;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3146((ValuePin)domainElement)) {
                    return 3146;
                }
                if (!UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isActionInputPin_3159((ActionInputPin)domainElement)) break;
                return 3159;
            }
            case 3114: {
                if (UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3126;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3134((InputPin)domainElement)) {
                    return 3134;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3135((InputPin)domainElement)) {
                    return 3135;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3147((ValuePin)domainElement)) {
                    return 3147;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3148((ValuePin)domainElement)) {
                    return 3148;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isActionInputPin_3160((ActionInputPin)domainElement)) {
                    return 3160;
                }
                if (!UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isActionInputPin_3161((ActionInputPin)domainElement)) break;
                return 3161;
            }
            case 3115: {
                if (UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3127;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3136((InputPin)domainElement)) {
                    return 3136;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3149((ValuePin)domainElement)) {
                    return 3149;
                }
                if (!UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isActionInputPin_3162((ActionInputPin)domainElement)) break;
                return 3162;
            }
            case 3117: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3137((InputPin)domainElement)) {
                    return 3137;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3151((ValuePin)domainElement)) {
                    return 3151;
                }
                if (!UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isActionInputPin_3163((ActionInputPin)domainElement)) break;
                return 3163;
            }
            case 3116: {
                if (UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3128;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3138((InputPin)domainElement)) {
                    return 3138;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3150((ValuePin)domainElement)) {
                    return 3150;
                }
                if (!UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isActionInputPin_3164((ActionInputPin)domainElement)) break;
                return 3164;
            }
            case 3118: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3139((InputPin)domainElement)) {
                    return 3139;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3152((ValuePin)domainElement)) {
                    return 3152;
                }
                if (!UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isActionInputPin_3165((ActionInputPin)domainElement)) break;
                return 3165;
            }
            case 3119: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3140((InputPin)domainElement)) {
                    return 3140;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3153((ValuePin)domainElement)) {
                    return 3153;
                }
                if (!UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isActionInputPin_3166((ActionInputPin)domainElement)) break;
                return 3166;
            }
            case 3120: {
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3129;
            }
            case 3121: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3141((InputPin)domainElement)) {
                    return 3141;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3154((ValuePin)domainElement)) {
                    return 3154;
                }
                if (!UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isActionInputPin_3167((ActionInputPin)domainElement)) break;
                return 3167;
            }
            case 3122: {
                if (UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3130;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3142((InputPin)domainElement)) {
                    return 3142;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3155((ValuePin)domainElement)) {
                    return 3155;
                }
                if (!UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isActionInputPin_3168((ActionInputPin)domainElement)) break;
                return 3168;
            }
            case 3123: {
                if (UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3131;
                }
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3143((InputPin)domainElement)) {
                    return 3143;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3156((ValuePin)domainElement)) {
                    return 3156;
                }
                if (!UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isActionInputPin_3169((ActionInputPin)domainElement)) break;
                return 3169;
            }
            case 3124: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isInputPin_3144((InputPin)domainElement)) {
                    return 3144;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isValuePin_3157((ValuePin)domainElement)) {
                    return 3157;
                }
                if (!UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isActionInputPin_3170((ActionInputPin)domainElement)) break;
                return 3170;
            }
            case 3198: {
                if (UMLPackage.eINSTANCE.getInputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3199;
                }
                if (UMLPackage.eINSTANCE.getValuePin().isSuperTypeOf(domainElement.eClass())) {
                    return 3200;
                }
                if (UMLPackage.eINSTANCE.getActionInputPin().isSuperTypeOf(domainElement.eClass())) {
                    return 3201;
                }
                if (!UMLPackage.eINSTANCE.getOutputPin().isSuperTypeOf(domainElement.eClass())) break;
                return 3202;
            }
            case 7001: {
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7002: {
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7003: {
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7004: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034((DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035((DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036((TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037((TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032((IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033((IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011((Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012((Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getActivityPartition().isSuperTypeOf(domainElement.eClass())) {
                    return 3067;
                }
                if (UMLPackage.eINSTANCE.getInterruptibleActivityRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3068;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getBroadcastSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3102;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3112;
                }
                if (UMLPackage.eINSTANCE.getStartObjectBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3113;
                }
                if (UMLPackage.eINSTANCE.getTestIdentityAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3114;
                }
                if (UMLPackage.eINSTANCE.getClearStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3115;
                }
                if (UMLPackage.eINSTANCE.getCreateLinkAction().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isCreateLinkAction_3117((CreateLinkAction)domainElement)) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getReadLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getDestroyLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getClearAssociationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (UMLPackage.eINSTANCE.getReadExtentAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3120;
                }
                if (UMLPackage.eINSTANCE.getReclassifyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3121;
                }
                if (UMLPackage.eINSTANCE.getReadIsClassifiedObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3122;
                }
                if (UMLPackage.eINSTANCE.getReduceAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3123;
                }
                if (UMLPackage.eINSTANCE.getStartClassifierBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3124;
                }
                if (!UMLPackage.eINSTANCE.getCreateLinkObjectAction().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isCreateLinkObjectAction_3198((CreateLinkObjectAction)domainElement)) break;
                return 3198;
            }
            case 7008: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034((DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035((DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036((TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037((TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032((IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033((IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011((Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012((Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3112;
                }
                if (UMLPackage.eINSTANCE.getCreateLinkAction().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isCreateLinkAction_3117((CreateLinkAction)domainElement)) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getReadLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getDestroyLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (!UMLPackage.eINSTANCE.getCreateLinkObjectAction().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isCreateLinkObjectAction_3198((CreateLinkObjectAction)domainElement)) break;
                return 3198;
            }
            case 7009: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034((DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035((DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036((TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037((TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032((IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033((IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011((Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012((Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getBroadcastSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3102;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3112;
                }
                if (UMLPackage.eINSTANCE.getStartObjectBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3113;
                }
                if (UMLPackage.eINSTANCE.getTestIdentityAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3114;
                }
                if (UMLPackage.eINSTANCE.getClearStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3115;
                }
                if (UMLPackage.eINSTANCE.getCreateLinkAction().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isCreateLinkAction_3117((CreateLinkAction)domainElement)) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getReadLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getDestroyLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getClearAssociationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (UMLPackage.eINSTANCE.getReadExtentAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3120;
                }
                if (UMLPackage.eINSTANCE.getReclassifyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3121;
                }
                if (UMLPackage.eINSTANCE.getReadIsClassifiedObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3122;
                }
                if (UMLPackage.eINSTANCE.getReduceAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3123;
                }
                if (UMLPackage.eINSTANCE.getStartClassifierBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3124;
                }
                if (!UMLPackage.eINSTANCE.getCreateLinkObjectAction().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isCreateLinkObjectAction_3198((CreateLinkObjectAction)domainElement)) break;
                return 3198;
            }
            case 7010: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034((DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035((DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036((TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037((TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032((IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033((IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011((Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012((Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getBroadcastSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3102;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3112;
                }
                if (UMLPackage.eINSTANCE.getStartObjectBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3113;
                }
                if (UMLPackage.eINSTANCE.getTestIdentityAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3114;
                }
                if (UMLPackage.eINSTANCE.getClearStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3115;
                }
                if (UMLPackage.eINSTANCE.getCreateLinkAction().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isCreateLinkAction_3117((CreateLinkAction)domainElement)) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getReadLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getDestroyLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getClearAssociationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (UMLPackage.eINSTANCE.getReadExtentAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3120;
                }
                if (UMLPackage.eINSTANCE.getReclassifyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3121;
                }
                if (UMLPackage.eINSTANCE.getReadIsClassifiedObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3122;
                }
                if (UMLPackage.eINSTANCE.getReduceAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3123;
                }
                if (UMLPackage.eINSTANCE.getStartClassifierBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3124;
                }
                if (!UMLPackage.eINSTANCE.getCreateLinkObjectAction().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isCreateLinkObjectAction_3198((CreateLinkObjectAction)domainElement)) break;
                return 3198;
            }
            case 7012: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034((DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035((DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036((TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037((TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032((IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033((IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011((Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012((Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getBroadcastSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3102;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3112;
                }
                if (UMLPackage.eINSTANCE.getStartObjectBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3113;
                }
                if (UMLPackage.eINSTANCE.getTestIdentityAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3114;
                }
                if (UMLPackage.eINSTANCE.getClearStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3115;
                }
                if (UMLPackage.eINSTANCE.getCreateLinkAction().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isCreateLinkAction_3117((CreateLinkAction)domainElement)) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getReadLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getDestroyLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getClearAssociationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (UMLPackage.eINSTANCE.getReadExtentAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3120;
                }
                if (UMLPackage.eINSTANCE.getReclassifyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3121;
                }
                if (UMLPackage.eINSTANCE.getReadIsClassifiedObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3122;
                }
                if (UMLPackage.eINSTANCE.getReduceAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3123;
                }
                if (UMLPackage.eINSTANCE.getStartClassifierBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3124;
                }
                if (!UMLPackage.eINSTANCE.getCreateLinkObjectAction().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isCreateLinkObjectAction_3198((CreateLinkObjectAction)domainElement)) break;
                return 3198;
            }
            case 7005: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034((DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035((DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036((TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037((TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032((IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033((IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011((Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012((Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getBroadcastSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3102;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3112;
                }
                if (UMLPackage.eINSTANCE.getStartObjectBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3113;
                }
                if (UMLPackage.eINSTANCE.getTestIdentityAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3114;
                }
                if (UMLPackage.eINSTANCE.getClearStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3115;
                }
                if (UMLPackage.eINSTANCE.getCreateLinkAction().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isCreateLinkAction_3117((CreateLinkAction)domainElement)) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getReadLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getDestroyLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getClearAssociationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (UMLPackage.eINSTANCE.getReadExtentAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3120;
                }
                if (UMLPackage.eINSTANCE.getReclassifyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3121;
                }
                if (UMLPackage.eINSTANCE.getReadIsClassifiedObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3122;
                }
                if (UMLPackage.eINSTANCE.getReduceAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3123;
                }
                if (UMLPackage.eINSTANCE.getStartClassifierBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3124;
                }
                if (!UMLPackage.eINSTANCE.getCreateLinkObjectAction().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isCreateLinkObjectAction_3198((CreateLinkObjectAction)domainElement)) break;
                return 3198;
            }
            case 7006: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getActivityPartition().isSuperTypeOf(domainElement.eClass())) {
                    return 3067;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034((DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035((DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036((TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037((TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032((IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033((IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011((Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012((Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getBroadcastSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3102;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3112;
                }
                if (UMLPackage.eINSTANCE.getStartObjectBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3113;
                }
                if (UMLPackage.eINSTANCE.getTestIdentityAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3114;
                }
                if (UMLPackage.eINSTANCE.getClearStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3115;
                }
                if (UMLPackage.eINSTANCE.getCreateLinkAction().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isCreateLinkAction_3117((CreateLinkAction)domainElement)) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getReadLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getDestroyLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getClearAssociationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (UMLPackage.eINSTANCE.getReadExtentAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3120;
                }
                if (UMLPackage.eINSTANCE.getReclassifyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3121;
                }
                if (UMLPackage.eINSTANCE.getReadIsClassifiedObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3122;
                }
                if (UMLPackage.eINSTANCE.getReduceAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3123;
                }
                if (UMLPackage.eINSTANCE.getStartClassifierBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3124;
                }
                if (!UMLPackage.eINSTANCE.getCreateLinkObjectAction().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isCreateLinkObjectAction_3198((CreateLinkObjectAction)domainElement)) break;
                return 3198;
            }
            case 7007: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034((DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035((DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036((TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037((TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032((IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033((IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011((Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012((Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getBroadcastSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3102;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3112;
                }
                if (UMLPackage.eINSTANCE.getStartObjectBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3113;
                }
                if (UMLPackage.eINSTANCE.getTestIdentityAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3114;
                }
                if (UMLPackage.eINSTANCE.getClearStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3115;
                }
                if (UMLPackage.eINSTANCE.getCreateLinkAction().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isCreateLinkAction_3117((CreateLinkAction)domainElement)) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getReadLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getDestroyLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getClearAssociationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (UMLPackage.eINSTANCE.getReadExtentAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3120;
                }
                if (UMLPackage.eINSTANCE.getReclassifyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3121;
                }
                if (UMLPackage.eINSTANCE.getReadIsClassifiedObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3122;
                }
                if (UMLPackage.eINSTANCE.getReduceAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3123;
                }
                if (UMLPackage.eINSTANCE.getStartClassifierBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3124;
                }
                if (!UMLPackage.eINSTANCE.getCreateLinkObjectAction().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isCreateLinkObjectAction_3198((CreateLinkObjectAction)domainElement)) break;
                return 3198;
            }
            case 7014: {
                if (!UMLPackage.eINSTANCE.getParameter().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7015: {
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
            case 7016: {
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3003;
            }
            case 7013: {
                if (UMLPackage.eINSTANCE.getInitialNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (UMLPackage.eINSTANCE.getActivityFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (UMLPackage.eINSTANCE.getFlowFinalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (UMLPackage.eINSTANCE.getOpaqueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (UMLPackage.eINSTANCE.getCallBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (UMLPackage.eINSTANCE.getCallOperationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3034((DurationConstraint)domainElement)) {
                    return 3034;
                }
                if (UMLPackage.eINSTANCE.getDurationConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDurationConstraint_3035((DurationConstraint)domainElement)) {
                    return 3035;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3036((TimeConstraint)domainElement)) {
                    return 3036;
                }
                if (UMLPackage.eINSTANCE.getTimeConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isTimeConstraint_3037((TimeConstraint)domainElement)) {
                    return 3037;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3032((IntervalConstraint)domainElement)) {
                    return 3032;
                }
                if (UMLPackage.eINSTANCE.getIntervalConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isIntervalConstraint_3033((IntervalConstraint)domainElement)) {
                    return 3033;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3011((Constraint)domainElement)) {
                    return 3011;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isConstraint_3012((Constraint)domainElement)) {
                    return 3012;
                }
                if (UMLPackage.eINSTANCE.getDecisionNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (UMLPackage.eINSTANCE.getMergeNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (UMLPackage.eINSTANCE.getForkNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (UMLPackage.eINSTANCE.getJoinNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (UMLPackage.eINSTANCE.getDataStoreNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3078;
                }
                if (UMLPackage.eINSTANCE.getSendObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3042;
                }
                if (UMLPackage.eINSTANCE.getSendSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3052;
                }
                if (UMLPackage.eINSTANCE.getAcceptEventAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3063;
                }
                if (UMLPackage.eINSTANCE.getValueSpecificationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getConditionalNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3069;
                }
                if (UMLPackage.eINSTANCE.getExpansionRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3070;
                }
                if (UMLPackage.eINSTANCE.getLoopNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getSequenceNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3073;
                }
                if (UMLPackage.eINSTANCE.getStructuredActivityNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3065;
                }
                if (UMLPackage.eINSTANCE.getActivityPartition().isSuperTypeOf(domainElement.eClass())) {
                    return 3067;
                }
                if (UMLPackage.eINSTANCE.getInterruptibleActivityRegion().isSuperTypeOf(domainElement.eClass())) {
                    return 3068;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3080;
                }
                if (UMLPackage.eINSTANCE.getReadSelfAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3081;
                }
                if (UMLPackage.eINSTANCE.getActivity().isSuperTypeOf(domainElement.eClass())) {
                    return 3083;
                }
                if (UMLPackage.eINSTANCE.getCreateObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3086;
                }
                if (UMLPackage.eINSTANCE.getReadStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3088;
                }
                if (UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3091;
                }
                if (UMLPackage.eINSTANCE.getDestroyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3095;
                }
                if (UMLPackage.eINSTANCE.getReadVariableAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3097;
                }
                if (UMLPackage.eINSTANCE.getAddVariableValueAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3099;
                }
                if (UMLPackage.eINSTANCE.getBroadcastSignalAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3102;
                }
                if (UMLPackage.eINSTANCE.getCentralBufferNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3104;
                }
                if (UMLPackage.eINSTANCE.getActivityParameterNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3059;
                }
                if (UMLPackage.eINSTANCE.getStartObjectBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3113;
                }
                if (UMLPackage.eINSTANCE.getTestIdentityAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3114;
                }
                if (UMLPackage.eINSTANCE.getClearStructuralFeatureAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3115;
                }
                if (UMLPackage.eINSTANCE.getCreateLinkAction().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isCreateLinkAction_3117((CreateLinkAction)domainElement)) {
                    return 3117;
                }
                if (UMLPackage.eINSTANCE.getReadLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3116;
                }
                if (UMLPackage.eINSTANCE.getDestroyLinkAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3118;
                }
                if (UMLPackage.eINSTANCE.getClearAssociationAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3119;
                }
                if (UMLPackage.eINSTANCE.getReadExtentAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3120;
                }
                if (UMLPackage.eINSTANCE.getReclassifyObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3121;
                }
                if (UMLPackage.eINSTANCE.getReadIsClassifiedObjectAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3122;
                }
                if (UMLPackage.eINSTANCE.getReduceAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3123;
                }
                if (UMLPackage.eINSTANCE.getStartClassifierBehaviorAction().isSuperTypeOf(domainElement.eClass())) {
                    return 3124;
                }
                if (!UMLPackage.eINSTANCE.getCreateLinkObjectAction().isSuperTypeOf(domainElement.eClass()) || !UMLVisualIDRegistry.isCreateLinkObjectAction_3198((CreateLinkObjectAction)domainElement)) break;
                return 3198;
            }
        }
        return -1;
    }

    private static boolean isExpansionNode_3075(View containerView, ExpansionNode domainElement) {
        return UMLVisualIDRegistry.isExpansionNode_3075(domainElement);
    }

    private static boolean isExpansionNode_3074(View containerView, ExpansionNode domainElement) {
        return UMLVisualIDRegistry.isExpansionNode_3074(domainElement);
    }

    private static boolean isValuePin_3022(View containerView, ValuePin domainElement) {
        return UMLVisualIDRegistry.isValuePin_3022(domainElement);
    }

    private static boolean isValuePin_3025(View containerView, ValuePin domainElement) {
        return UMLVisualIDRegistry.isValuePin_3025(domainElement);
    }

    private static boolean isValuePin_3046(View containerView, ValuePin domainElement) {
        return UMLVisualIDRegistry.isValuePin_3046(domainElement);
    }

    private static boolean isValuePin_3049(View containerView, ValuePin domainElement) {
        return UMLVisualIDRegistry.isValuePin_3049(domainElement);
    }

    private static boolean isValuePin_3054(View containerView, ValuePin domainElement) {
        return UMLVisualIDRegistry.isValuePin_3054(domainElement);
    }

    private static boolean isValuePin_3060(View containerView, ValuePin domainElement) {
        return UMLVisualIDRegistry.isValuePin_3060(domainElement);
    }

    private static boolean isInputPin_3023(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3023(domainElement);
    }

    private static boolean isInputPin_3027(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3027(domainElement);
    }

    private static boolean isInputPin_3048(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3048(domainElement);
    }

    private static boolean isInputPin_3051(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3051(domainElement);
    }

    private static boolean isInputPin_3055(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3055(domainElement);
    }

    private static boolean isInputPin_3062(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3062(domainElement);
    }

    private static boolean isActionInputPin_3026(View containerView, ActionInputPin domainElement) {
        return UMLVisualIDRegistry.isActionInputPin_3026(domainElement);
    }

    private static boolean isActionInputPin_3021(View containerView, ActionInputPin domainElement) {
        return UMLVisualIDRegistry.isActionInputPin_3021(domainElement);
    }

    private static boolean isActionInputPin_3047(View containerView, ActionInputPin domainElement) {
        return UMLVisualIDRegistry.isActionInputPin_3047(domainElement);
    }

    private static boolean isActionInputPin_3050(View containerView, ActionInputPin domainElement) {
        return UMLVisualIDRegistry.isActionInputPin_3050(domainElement);
    }

    private static boolean isActionInputPin_3053(View containerView, ActionInputPin domainElement) {
        return UMLVisualIDRegistry.isActionInputPin_3053(domainElement);
    }

    private static boolean isActionInputPin_3061(View containerView, ActionInputPin domainElement) {
        return UMLVisualIDRegistry.isActionInputPin_3061(domainElement);
    }

    private static boolean isConstraint_3011(View containerView, Constraint domainElement) {
        return UMLVisualIDRegistry.isConstraint_3011(domainElement);
    }

    private static boolean isConstraint_3012(View containerView, Constraint domainElement) {
        return UMLVisualIDRegistry.isConstraint_3012(domainElement);
    }

    private static boolean isIntervalConstraint_3032(View containerView, IntervalConstraint domainElement) {
        return UMLVisualIDRegistry.isIntervalConstraint_3032(domainElement);
    }

    private static boolean isIntervalConstraint_3033(View containerView, IntervalConstraint domainElement) {
        return UMLVisualIDRegistry.isIntervalConstraint_3033(domainElement);
    }

    private static boolean isDurationConstraint_3034(View containerView, DurationConstraint domainElement) {
        return UMLVisualIDRegistry.isDurationConstraint_3034(domainElement);
    }

    private static boolean isDurationConstraint_3035(View containerView, DurationConstraint domainElement) {
        return UMLVisualIDRegistry.isDurationConstraint_3035(domainElement);
    }

    private static boolean isTimeConstraint_3036(View containerView, TimeConstraint domainElement) {
        return UMLVisualIDRegistry.isTimeConstraint_3036(domainElement);
    }

    private static boolean isTimeConstraint_3037(View containerView, TimeConstraint domainElement) {
        return UMLVisualIDRegistry.isTimeConstraint_3037(domainElement);
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLActivityDiagram".equals(containerModelID)) {
            return false;
        }
        if ("PapyrusUMLActivityDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2001 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (7001 == nodeVisualID) {
                    return true;
                }
                if (7002 == nodeVisualID) {
                    return true;
                }
                if (7003 == nodeVisualID) {
                    return true;
                }
                if (7004 == nodeVisualID) {
                    return true;
                }
                if (3059 != nodeVisualID) break;
                return true;
            }
            case 3004: {
                if (6034 == nodeVisualID) {
                    return true;
                }
                if (5080 != nodeVisualID) break;
                return true;
            }
            case 3005: {
                if (6033 == nodeVisualID) {
                    return true;
                }
                if (5081 != nodeVisualID) break;
                return true;
            }
            case 3006: {
                if (6035 == nodeVisualID) {
                    return true;
                }
                if (5082 != nodeVisualID) break;
                return true;
            }
            case 3007: {
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (6028 == nodeVisualID) {
                    return true;
                }
                if (3015 == nodeVisualID) {
                    return true;
                }
                if (3016 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 3015: {
                if (5011 == nodeVisualID) {
                    return true;
                }
                if (5024 == nodeVisualID) {
                    return true;
                }
                if (5083 != nodeVisualID) break;
                return true;
            }
            case 3016: {
                if (5012 == nodeVisualID) {
                    return true;
                }
                if (5025 == nodeVisualID) {
                    return true;
                }
                if (5084 != nodeVisualID) break;
                return true;
            }
            case 3013: {
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (5085 != nodeVisualID) break;
                return true;
            }
            case 3014: {
                if (5010 == nodeVisualID) {
                    return true;
                }
                if (5086 != nodeVisualID) break;
                return true;
            }
            case 3008: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (6029 == nodeVisualID) {
                    return true;
                }
                if (3017 == nodeVisualID) {
                    return true;
                }
                if (3018 == nodeVisualID) {
                    return true;
                }
                if (3019 == nodeVisualID) {
                    return true;
                }
                if (3020 != nodeVisualID) break;
                return true;
            }
            case 3017: {
                if (5013 == nodeVisualID) {
                    return true;
                }
                if (5026 == nodeVisualID) {
                    return true;
                }
                if (5087 != nodeVisualID) break;
                return true;
            }
            case 3018: {
                if (5014 == nodeVisualID) {
                    return true;
                }
                if (5027 == nodeVisualID) {
                    return true;
                }
                if (5088 != nodeVisualID) break;
                return true;
            }
            case 3019: {
                if (5015 == nodeVisualID) {
                    return true;
                }
                if (5089 != nodeVisualID) break;
                return true;
            }
            case 3020: {
                if (5016 == nodeVisualID) {
                    return true;
                }
                if (5090 != nodeVisualID) break;
                return true;
            }
            case 3010: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (6020 == nodeVisualID) {
                    return true;
                }
                if (3021 == nodeVisualID) {
                    return true;
                }
                if (3022 == nodeVisualID) {
                    return true;
                }
                if (3023 == nodeVisualID) {
                    return true;
                }
                if (3024 == nodeVisualID) {
                    return true;
                }
                if (3025 == nodeVisualID) {
                    return true;
                }
                if (3026 == nodeVisualID) {
                    return true;
                }
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 3021: {
                if (5017 == nodeVisualID) {
                    return true;
                }
                if (5028 == nodeVisualID) {
                    return true;
                }
                if (5091 != nodeVisualID) break;
                return true;
            }
            case 3022: {
                if (5018 == nodeVisualID) {
                    return true;
                }
                if (5029 == nodeVisualID) {
                    return true;
                }
                if (5092 != nodeVisualID) break;
                return true;
            }
            case 3023: {
                if (5019 == nodeVisualID) {
                    return true;
                }
                if (5093 != nodeVisualID) break;
                return true;
            }
            case 3024: {
                if (5020 == nodeVisualID) {
                    return true;
                }
                if (5094 != nodeVisualID) break;
                return true;
            }
            case 3025: {
                if (5021 == nodeVisualID) {
                    return true;
                }
                if (5030 == nodeVisualID) {
                    return true;
                }
                if (5095 != nodeVisualID) break;
                return true;
            }
            case 3026: {
                if (5022 == nodeVisualID) {
                    return true;
                }
                if (5031 == nodeVisualID) {
                    return true;
                }
                if (5096 != nodeVisualID) break;
                return true;
            }
            case 3027: {
                if (5023 == nodeVisualID) {
                    return true;
                }
                if (5097 != nodeVisualID) break;
                return true;
            }
            case 3034: {
                if (5038 == nodeVisualID) {
                    return true;
                }
                if (5130 != nodeVisualID) break;
                return true;
            }
            case 3035: {
                if (5039 == nodeVisualID) {
                    return true;
                }
                if (5131 != nodeVisualID) break;
                return true;
            }
            case 3036: {
                if (5040 == nodeVisualID) {
                    return true;
                }
                if (5132 != nodeVisualID) break;
                return true;
            }
            case 3037: {
                if (5041 == nodeVisualID) {
                    return true;
                }
                if (5133 != nodeVisualID) break;
                return true;
            }
            case 3032: {
                if (5036 == nodeVisualID) {
                    return true;
                }
                if (5134 != nodeVisualID) break;
                return true;
            }
            case 3033: {
                if (5037 == nodeVisualID) {
                    return true;
                }
                if (5135 != nodeVisualID) break;
                return true;
            }
            case 3011: {
                if (5007 == nodeVisualID) {
                    return true;
                }
                if (5136 != nodeVisualID) break;
                return true;
            }
            case 3012: {
                if (5008 == nodeVisualID) {
                    return true;
                }
                if (5137 != nodeVisualID) break;
                return true;
            }
            case 3038: {
                if (6036 == nodeVisualID) {
                    return true;
                }
                if (5043 == nodeVisualID) {
                    return true;
                }
                if (5098 != nodeVisualID) break;
                return true;
            }
            case 3039: {
                if (6037 == nodeVisualID) {
                    return true;
                }
                if (5099 != nodeVisualID) break;
                return true;
            }
            case 3040: {
                if (6038 == nodeVisualID) {
                    return true;
                }
                if (5100 != nodeVisualID) break;
                return true;
            }
            case 3041: {
                if (6039 == nodeVisualID) {
                    return true;
                }
                if (5042 == nodeVisualID) {
                    return true;
                }
                if (5101 != nodeVisualID) break;
                return true;
            }
            case 3078: {
                if (5127 == nodeVisualID) {
                    return true;
                }
                if (5128 == nodeVisualID) {
                    return true;
                }
                if (6031 != nodeVisualID) break;
                return true;
            }
            case 3042: {
                if (5059 == nodeVisualID) {
                    return true;
                }
                if (6027 == nodeVisualID) {
                    return true;
                }
                if (3046 == nodeVisualID) {
                    return true;
                }
                if (3047 == nodeVisualID) {
                    return true;
                }
                if (3048 == nodeVisualID) {
                    return true;
                }
                if (3049 == nodeVisualID) {
                    return true;
                }
                if (3050 == nodeVisualID) {
                    return true;
                }
                if (3051 != nodeVisualID) break;
                return true;
            }
            case 3046: {
                if (5049 == nodeVisualID) {
                    return true;
                }
                if (5050 == nodeVisualID) {
                    return true;
                }
                if (5102 != nodeVisualID) break;
                return true;
            }
            case 3047: {
                if (5051 == nodeVisualID) {
                    return true;
                }
                if (5052 == nodeVisualID) {
                    return true;
                }
                if (5103 != nodeVisualID) break;
                return true;
            }
            case 3048: {
                if (5053 == nodeVisualID) {
                    return true;
                }
                if (5104 != nodeVisualID) break;
                return true;
            }
            case 3049: {
                if (5054 == nodeVisualID) {
                    return true;
                }
                if (5055 == nodeVisualID) {
                    return true;
                }
                if (5105 != nodeVisualID) break;
                return true;
            }
            case 3050: {
                if (5056 == nodeVisualID) {
                    return true;
                }
                if (5057 == nodeVisualID) {
                    return true;
                }
                if (5106 != nodeVisualID) break;
                return true;
            }
            case 3051: {
                if (5058 == nodeVisualID) {
                    return true;
                }
                if (5107 != nodeVisualID) break;
                return true;
            }
            case 3052: {
                if (5060 == nodeVisualID) {
                    return true;
                }
                if (6032 == nodeVisualID) {
                    return true;
                }
                if (3053 == nodeVisualID) {
                    return true;
                }
                if (3054 == nodeVisualID) {
                    return true;
                }
                if (3055 == nodeVisualID) {
                    return true;
                }
                if (3060 == nodeVisualID) {
                    return true;
                }
                if (3061 == nodeVisualID) {
                    return true;
                }
                if (3062 != nodeVisualID) break;
                return true;
            }
            case 3053: {
                if (5061 == nodeVisualID) {
                    return true;
                }
                if (5062 == nodeVisualID) {
                    return true;
                }
                if (5108 != nodeVisualID) break;
                return true;
            }
            case 3054: {
                if (5063 == nodeVisualID) {
                    return true;
                }
                if (5064 == nodeVisualID) {
                    return true;
                }
                if (5109 != nodeVisualID) break;
                return true;
            }
            case 3055: {
                if (5065 == nodeVisualID) {
                    return true;
                }
                if (5110 != nodeVisualID) break;
                return true;
            }
            case 3060: {
                if (5072 == nodeVisualID) {
                    return true;
                }
                if (5073 == nodeVisualID) {
                    return true;
                }
                if (5111 != nodeVisualID) break;
                return true;
            }
            case 3061: {
                if (5074 == nodeVisualID) {
                    return true;
                }
                if (5075 == nodeVisualID) {
                    return true;
                }
                if (5112 != nodeVisualID) break;
                return true;
            }
            case 3062: {
                if (5076 == nodeVisualID) {
                    return true;
                }
                if (5113 != nodeVisualID) break;
                return true;
            }
            case 3059: {
                if (5071 != nodeVisualID) break;
                return true;
            }
            case 3063: {
                if (5078 == nodeVisualID) {
                    return true;
                }
                if (5079 == nodeVisualID) {
                    return true;
                }
                if (5115 == nodeVisualID) {
                    return true;
                }
                if (6040 == nodeVisualID) {
                    return true;
                }
                if (3064 != nodeVisualID) break;
                return true;
            }
            case 3064: {
                if (5077 == nodeVisualID) {
                    return true;
                }
                if (5114 != nodeVisualID) break;
                return true;
            }
            case 3076: {
                if (5126 == nodeVisualID) {
                    return true;
                }
                if (6026 == nodeVisualID) {
                    return true;
                }
                if (3077 != nodeVisualID) break;
                return true;
            }
            case 3077: {
                if (5124 == nodeVisualID) {
                    return true;
                }
                if (5125 != nodeVisualID) break;
                return true;
            }
            case 3069: {
                if (5119 == nodeVisualID) {
                    return true;
                }
                if (7008 == nodeVisualID) {
                    return true;
                }
                if (3188 == nodeVisualID) {
                    return true;
                }
                if (3189 == nodeVisualID) {
                    return true;
                }
                if (3190 == nodeVisualID) {
                    return true;
                }
                if (3191 != nodeVisualID) break;
                return true;
            }
            case 3070: {
                if (5120 == nodeVisualID) {
                    return true;
                }
                if (7009 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3188 == nodeVisualID) {
                    return true;
                }
                if (3189 == nodeVisualID) {
                    return true;
                }
                if (3190 == nodeVisualID) {
                    return true;
                }
                if (3191 != nodeVisualID) break;
                return true;
            }
            case 3071: {
                if (5121 == nodeVisualID) {
                    return true;
                }
                if (7010 == nodeVisualID) {
                    return true;
                }
                if (3105 == nodeVisualID) {
                    return true;
                }
                if (3192 == nodeVisualID) {
                    return true;
                }
                if (3193 == nodeVisualID) {
                    return true;
                }
                if (3109 == nodeVisualID) {
                    return true;
                }
                if (3110 == nodeVisualID) {
                    return true;
                }
                if (3111 != nodeVisualID) break;
                return true;
            }
            case 3105: {
                if (5178 == nodeVisualID) {
                    return true;
                }
                if (5179 != nodeVisualID) break;
                return true;
            }
            case 3192: {
                if (5388 == nodeVisualID) {
                    return true;
                }
                if (5389 == nodeVisualID) {
                    return true;
                }
                if (5390 != nodeVisualID) break;
                return true;
            }
            case 3193: {
                if (5391 == nodeVisualID) {
                    return true;
                }
                if (5392 == nodeVisualID) {
                    return true;
                }
                if (5393 != nodeVisualID) break;
                return true;
            }
            case 3109: {
                if (5184 == nodeVisualID) {
                    return true;
                }
                if (5185 != nodeVisualID) break;
                return true;
            }
            case 3110: {
                if (5186 == nodeVisualID) {
                    return true;
                }
                if (5183 != nodeVisualID) break;
                return true;
            }
            case 3111: {
                if (5187 == nodeVisualID) {
                    return true;
                }
                if (5188 != nodeVisualID) break;
                return true;
            }
            case 3073: {
                if (5123 == nodeVisualID) {
                    return true;
                }
                if (7012 == nodeVisualID) {
                    return true;
                }
                if (3188 == nodeVisualID) {
                    return true;
                }
                if (3189 == nodeVisualID) {
                    return true;
                }
                if (3190 == nodeVisualID) {
                    return true;
                }
                if (3191 != nodeVisualID) break;
                return true;
            }
            case 3065: {
                if (5117 == nodeVisualID) {
                    return true;
                }
                if (7005 == nodeVisualID) {
                    return true;
                }
                if (3189 == nodeVisualID) {
                    return true;
                }
                if (3190 == nodeVisualID) {
                    return true;
                }
                if (3191 == nodeVisualID) {
                    return true;
                }
                if (3188 != nodeVisualID) break;
                return true;
            }
            case 3188: {
                if (5377 == nodeVisualID) {
                    return true;
                }
                if (5378 != nodeVisualID) break;
                return true;
            }
            case 3189: {
                if (5379 == nodeVisualID) {
                    return true;
                }
                if (5380 == nodeVisualID) {
                    return true;
                }
                if (5381 != nodeVisualID) break;
                return true;
            }
            case 3190: {
                if (5382 == nodeVisualID) {
                    return true;
                }
                if (5383 == nodeVisualID) {
                    return true;
                }
                if (5384 != nodeVisualID) break;
                return true;
            }
            case 3191: {
                if (5385 == nodeVisualID) {
                    return true;
                }
                if (5386 != nodeVisualID) break;
                return true;
            }
            case 3067: {
                if (5118 == nodeVisualID) {
                    return true;
                }
                if (6016 == nodeVisualID) {
                    return true;
                }
                if (7006 != nodeVisualID) break;
                return true;
            }
            case 3068: {
                if (7007 != nodeVisualID) break;
                return true;
            }
            case 3080: {
                if (5138 != nodeVisualID) break;
                return true;
            }
            case 3081: {
                if (5139 == nodeVisualID) {
                    return true;
                }
                if (6025 == nodeVisualID) {
                    return true;
                }
                if (3084 != nodeVisualID) break;
                return true;
            }
            case 3084: {
                if (5144 == nodeVisualID) {
                    return true;
                }
                if (5145 != nodeVisualID) break;
                return true;
            }
            case 3083: {
                if (5142 == nodeVisualID) {
                    return true;
                }
                if (5143 == nodeVisualID) {
                    return true;
                }
                if (7014 == nodeVisualID) {
                    return true;
                }
                if (7015 == nodeVisualID) {
                    return true;
                }
                if (7016 == nodeVisualID) {
                    return true;
                }
                if (7013 == nodeVisualID) {
                    return true;
                }
                if (3059 != nodeVisualID) break;
                return true;
            }
            case 3086: {
                if (5148 == nodeVisualID) {
                    return true;
                }
                if (6024 == nodeVisualID) {
                    return true;
                }
                if (3087 != nodeVisualID) break;
                return true;
            }
            case 3087: {
                if (5146 == nodeVisualID) {
                    return true;
                }
                if (5147 != nodeVisualID) break;
                return true;
            }
            case 3085: {
                if (5129 != nodeVisualID) break;
                return true;
            }
            case 3088: {
                if (5153 == nodeVisualID) {
                    return true;
                }
                if (6023 == nodeVisualID) {
                    return true;
                }
                if (3089 == nodeVisualID) {
                    return true;
                }
                if (3090 != nodeVisualID) break;
                return true;
            }
            case 3089: {
                if (5149 == nodeVisualID) {
                    return true;
                }
                if (5150 != nodeVisualID) break;
                return true;
            }
            case 3090: {
                if (5151 == nodeVisualID) {
                    return true;
                }
                if (5152 != nodeVisualID) break;
                return true;
            }
            case 3091: {
                if (5160 == nodeVisualID) {
                    return true;
                }
                if (6019 == nodeVisualID) {
                    return true;
                }
                if (3092 == nodeVisualID) {
                    return true;
                }
                if (3093 == nodeVisualID) {
                    return true;
                }
                if (3181 == nodeVisualID) {
                    return true;
                }
                if (3182 == nodeVisualID) {
                    return true;
                }
                if (3183 == nodeVisualID) {
                    return true;
                }
                if (3184 == nodeVisualID) {
                    return true;
                }
                if (3185 == nodeVisualID) {
                    return true;
                }
                if (3186 == nodeVisualID) {
                    return true;
                }
                if (3187 == nodeVisualID) {
                    return true;
                }
                if (3094 != nodeVisualID) break;
                return true;
            }
            case 3092: {
                if (5154 == nodeVisualID) {
                    return true;
                }
                if (5155 != nodeVisualID) break;
                return true;
            }
            case 3093: {
                if (5156 == nodeVisualID) {
                    return true;
                }
                if (5157 != nodeVisualID) break;
                return true;
            }
            case 3181: {
                if (5357 == nodeVisualID) {
                    return true;
                }
                if (5358 != nodeVisualID) break;
                return true;
            }
            case 3182: {
                if (5359 == nodeVisualID) {
                    return true;
                }
                if (5360 == nodeVisualID) {
                    return true;
                }
                if (5361 != nodeVisualID) break;
                return true;
            }
            case 3183: {
                if (5362 == nodeVisualID) {
                    return true;
                }
                if (5363 == nodeVisualID) {
                    return true;
                }
                if (5364 != nodeVisualID) break;
                return true;
            }
            case 3184: {
                if (5365 == nodeVisualID) {
                    return true;
                }
                if (5366 == nodeVisualID) {
                    return true;
                }
                if (5367 != nodeVisualID) break;
                return true;
            }
            case 3185: {
                if (5368 == nodeVisualID) {
                    return true;
                }
                if (5369 == nodeVisualID) {
                    return true;
                }
                if (5370 != nodeVisualID) break;
                return true;
            }
            case 3186: {
                if (5371 == nodeVisualID) {
                    return true;
                }
                if (5372 == nodeVisualID) {
                    return true;
                }
                if (5373 != nodeVisualID) break;
                return true;
            }
            case 3187: {
                if (5374 == nodeVisualID) {
                    return true;
                }
                if (5375 == nodeVisualID) {
                    return true;
                }
                if (5376 != nodeVisualID) break;
                return true;
            }
            case 3094: {
                if (5158 == nodeVisualID) {
                    return true;
                }
                if (5159 != nodeVisualID) break;
                return true;
            }
            case 3095: {
                if (5163 == nodeVisualID) {
                    return true;
                }
                if (6022 == nodeVisualID) {
                    return true;
                }
                if (3096 == nodeVisualID) {
                    return true;
                }
                if (3173 == nodeVisualID) {
                    return true;
                }
                if (3174 != nodeVisualID) break;
                return true;
            }
            case 3096: {
                if (5161 == nodeVisualID) {
                    return true;
                }
                if (5162 != nodeVisualID) break;
                return true;
            }
            case 3173: {
                if (5332 == nodeVisualID) {
                    return true;
                }
                if (5333 == nodeVisualID) {
                    return true;
                }
                if (5334 != nodeVisualID) break;
                return true;
            }
            case 3174: {
                if (5335 == nodeVisualID) {
                    return true;
                }
                if (5336 == nodeVisualID) {
                    return true;
                }
                if (5337 != nodeVisualID) break;
                return true;
            }
            case 3097: {
                if (5166 == nodeVisualID) {
                    return true;
                }
                if (6021 == nodeVisualID) {
                    return true;
                }
                if (3098 != nodeVisualID) break;
                return true;
            }
            case 3098: {
                if (5164 == nodeVisualID) {
                    return true;
                }
                if (5165 != nodeVisualID) break;
                return true;
            }
            case 3099: {
                if (5171 == nodeVisualID) {
                    return true;
                }
                if (6018 == nodeVisualID) {
                    return true;
                }
                if (3100 == nodeVisualID) {
                    return true;
                }
                if (3101 == nodeVisualID) {
                    return true;
                }
                if (3175 == nodeVisualID) {
                    return true;
                }
                if (3176 == nodeVisualID) {
                    return true;
                }
                if (3177 == nodeVisualID) {
                    return true;
                }
                if (3178 != nodeVisualID) break;
                return true;
            }
            case 3100: {
                if (5167 == nodeVisualID) {
                    return true;
                }
                if (5168 != nodeVisualID) break;
                return true;
            }
            case 3101: {
                if (5169 == nodeVisualID) {
                    return true;
                }
                if (5170 != nodeVisualID) break;
                return true;
            }
            case 3175: {
                if (5350 == nodeVisualID) {
                    return true;
                }
                if (5339 == nodeVisualID) {
                    return true;
                }
                if (5340 != nodeVisualID) break;
                return true;
            }
            case 3176: {
                if (5341 == nodeVisualID) {
                    return true;
                }
                if (5342 == nodeVisualID) {
                    return true;
                }
                if (5343 != nodeVisualID) break;
                return true;
            }
            case 3177: {
                if (5344 == nodeVisualID) {
                    return true;
                }
                if (5345 == nodeVisualID) {
                    return true;
                }
                if (5346 != nodeVisualID) break;
                return true;
            }
            case 3178: {
                if (5347 == nodeVisualID) {
                    return true;
                }
                if (5348 == nodeVisualID) {
                    return true;
                }
                if (5349 != nodeVisualID) break;
                return true;
            }
            case 3102: {
                if (5175 == nodeVisualID) {
                    return true;
                }
                if (6017 == nodeVisualID) {
                    return true;
                }
                if (3103 == nodeVisualID) {
                    return true;
                }
                if (3179 == nodeVisualID) {
                    return true;
                }
                if (3180 != nodeVisualID) break;
                return true;
            }
            case 3103: {
                if (5172 == nodeVisualID) {
                    return true;
                }
                if (5173 == nodeVisualID) {
                    return true;
                }
                if (5174 != nodeVisualID) break;
                return true;
            }
            case 3179: {
                if (5351 == nodeVisualID) {
                    return true;
                }
                if (5352 == nodeVisualID) {
                    return true;
                }
                if (5353 != nodeVisualID) break;
                return true;
            }
            case 3180: {
                if (5354 == nodeVisualID) {
                    return true;
                }
                if (5355 == nodeVisualID) {
                    return true;
                }
                if (5356 != nodeVisualID) break;
                return true;
            }
            case 3104: {
                if (5176 == nodeVisualID) {
                    return true;
                }
                if (5177 == nodeVisualID) {
                    return true;
                }
                if (6030 != nodeVisualID) break;
                return true;
            }
            case 3112: {
                if (5189 == nodeVisualID) {
                    return true;
                }
                if (5190 != nodeVisualID) break;
                return true;
            }
            case 3113: {
                if (5191 == nodeVisualID) {
                    return true;
                }
                if (5394 == nodeVisualID) {
                    return true;
                }
                if (3125 == nodeVisualID) {
                    return true;
                }
                if (3132 == nodeVisualID) {
                    return true;
                }
                if (3145 == nodeVisualID) {
                    return true;
                }
                if (3158 == nodeVisualID) {
                    return true;
                }
                if (3133 == nodeVisualID) {
                    return true;
                }
                if (3146 == nodeVisualID) {
                    return true;
                }
                if (3159 != nodeVisualID) break;
                return true;
            }
            case 3125: {
                if (5203 == nodeVisualID) {
                    return true;
                }
                if (5204 != nodeVisualID) break;
                return true;
            }
            case 3132: {
                if (5217 == nodeVisualID) {
                    return true;
                }
                if (5218 != nodeVisualID) break;
                return true;
            }
            case 3145: {
                if (5245 == nodeVisualID) {
                    return true;
                }
                if (5246 == nodeVisualID) {
                    return true;
                }
                if (5247 != nodeVisualID) break;
                return true;
            }
            case 3158: {
                if (5263 == nodeVisualID) {
                    return true;
                }
                if (5264 == nodeVisualID) {
                    return true;
                }
                if (5265 != nodeVisualID) break;
                return true;
            }
            case 3133: {
                if (5219 == nodeVisualID) {
                    return true;
                }
                if (5220 != nodeVisualID) break;
                return true;
            }
            case 3146: {
                if (5248 == nodeVisualID) {
                    return true;
                }
                if (5249 == nodeVisualID) {
                    return true;
                }
                if (5250 != nodeVisualID) break;
                return true;
            }
            case 3159: {
                if (5266 == nodeVisualID) {
                    return true;
                }
                if (5267 == nodeVisualID) {
                    return true;
                }
                if (5268 != nodeVisualID) break;
                return true;
            }
            case 3114: {
                if (5192 == nodeVisualID) {
                    return true;
                }
                if (5395 == nodeVisualID) {
                    return true;
                }
                if (3126 == nodeVisualID) {
                    return true;
                }
                if (3134 == nodeVisualID) {
                    return true;
                }
                if (3135 == nodeVisualID) {
                    return true;
                }
                if (3147 == nodeVisualID) {
                    return true;
                }
                if (3148 == nodeVisualID) {
                    return true;
                }
                if (3160 == nodeVisualID) {
                    return true;
                }
                if (3161 != nodeVisualID) break;
                return true;
            }
            case 3126: {
                if (5205 == nodeVisualID) {
                    return true;
                }
                if (5206 != nodeVisualID) break;
                return true;
            }
            case 3134: {
                if (5221 == nodeVisualID) {
                    return true;
                }
                if (5222 != nodeVisualID) break;
                return true;
            }
            case 3135: {
                if (5223 == nodeVisualID) {
                    return true;
                }
                if (5224 != nodeVisualID) break;
                return true;
            }
            case 3147: {
                if (5251 == nodeVisualID) {
                    return true;
                }
                if (5252 == nodeVisualID) {
                    return true;
                }
                if (5253 != nodeVisualID) break;
                return true;
            }
            case 3148: {
                if (5254 == nodeVisualID) {
                    return true;
                }
                if (5255 == nodeVisualID) {
                    return true;
                }
                if (5256 != nodeVisualID) break;
                return true;
            }
            case 3160: {
                if (5269 == nodeVisualID) {
                    return true;
                }
                if (5270 == nodeVisualID) {
                    return true;
                }
                if (5271 != nodeVisualID) break;
                return true;
            }
            case 3161: {
                if (5272 == nodeVisualID) {
                    return true;
                }
                if (5273 == nodeVisualID) {
                    return true;
                }
                if (5274 != nodeVisualID) break;
                return true;
            }
            case 3115: {
                if (5193 == nodeVisualID) {
                    return true;
                }
                if (5396 == nodeVisualID) {
                    return true;
                }
                if (3127 == nodeVisualID) {
                    return true;
                }
                if (3136 == nodeVisualID) {
                    return true;
                }
                if (3149 == nodeVisualID) {
                    return true;
                }
                if (3162 != nodeVisualID) break;
                return true;
            }
            case 3127: {
                if (5207 == nodeVisualID) {
                    return true;
                }
                if (5208 != nodeVisualID) break;
                return true;
            }
            case 3136: {
                if (5225 == nodeVisualID) {
                    return true;
                }
                if (5226 != nodeVisualID) break;
                return true;
            }
            case 3149: {
                if (5260 == nodeVisualID) {
                    return true;
                }
                if (5261 == nodeVisualID) {
                    return true;
                }
                if (5262 != nodeVisualID) break;
                return true;
            }
            case 3162: {
                if (5275 == nodeVisualID) {
                    return true;
                }
                if (5276 == nodeVisualID) {
                    return true;
                }
                if (5277 != nodeVisualID) break;
                return true;
            }
            case 3117: {
                if (5195 == nodeVisualID) {
                    return true;
                }
                if (5397 == nodeVisualID) {
                    return true;
                }
                if (3137 == nodeVisualID) {
                    return true;
                }
                if (3151 == nodeVisualID) {
                    return true;
                }
                if (3163 != nodeVisualID) break;
                return true;
            }
            case 3137: {
                if (5227 == nodeVisualID) {
                    return true;
                }
                if (5228 != nodeVisualID) break;
                return true;
            }
            case 3151: {
                if (5281 == nodeVisualID) {
                    return true;
                }
                if (5282 == nodeVisualID) {
                    return true;
                }
                if (5283 != nodeVisualID) break;
                return true;
            }
            case 3163: {
                if (5278 == nodeVisualID) {
                    return true;
                }
                if (5279 == nodeVisualID) {
                    return true;
                }
                if (5280 != nodeVisualID) break;
                return true;
            }
            case 3116: {
                if (5194 == nodeVisualID) {
                    return true;
                }
                if (5398 == nodeVisualID) {
                    return true;
                }
                if (3128 == nodeVisualID) {
                    return true;
                }
                if (3138 == nodeVisualID) {
                    return true;
                }
                if (3150 == nodeVisualID) {
                    return true;
                }
                if (3164 != nodeVisualID) break;
                return true;
            }
            case 3128: {
                if (5209 == nodeVisualID) {
                    return true;
                }
                if (5210 != nodeVisualID) break;
                return true;
            }
            case 3138: {
                if (5229 == nodeVisualID) {
                    return true;
                }
                if (5230 != nodeVisualID) break;
                return true;
            }
            case 3150: {
                if (5287 == nodeVisualID) {
                    return true;
                }
                if (5288 == nodeVisualID) {
                    return true;
                }
                if (5289 != nodeVisualID) break;
                return true;
            }
            case 3164: {
                if (5284 == nodeVisualID) {
                    return true;
                }
                if (5285 == nodeVisualID) {
                    return true;
                }
                if (5286 != nodeVisualID) break;
                return true;
            }
            case 3118: {
                if (5196 == nodeVisualID) {
                    return true;
                }
                if (5399 == nodeVisualID) {
                    return true;
                }
                if (3139 == nodeVisualID) {
                    return true;
                }
                if (3152 == nodeVisualID) {
                    return true;
                }
                if (3165 != nodeVisualID) break;
                return true;
            }
            case 3139: {
                if (5231 == nodeVisualID) {
                    return true;
                }
                if (5232 != nodeVisualID) break;
                return true;
            }
            case 3152: {
                if (5290 == nodeVisualID) {
                    return true;
                }
                if (5291 == nodeVisualID) {
                    return true;
                }
                if (5292 != nodeVisualID) break;
                return true;
            }
            case 3165: {
                if (5293 == nodeVisualID) {
                    return true;
                }
                if (5294 == nodeVisualID) {
                    return true;
                }
                if (5295 != nodeVisualID) break;
                return true;
            }
            case 3119: {
                if (5197 == nodeVisualID) {
                    return true;
                }
                if (5400 == nodeVisualID) {
                    return true;
                }
                if (3140 == nodeVisualID) {
                    return true;
                }
                if (3153 == nodeVisualID) {
                    return true;
                }
                if (3166 != nodeVisualID) break;
                return true;
            }
            case 3140: {
                if (5235 == nodeVisualID) {
                    return true;
                }
                if (5236 != nodeVisualID) break;
                return true;
            }
            case 3153: {
                if (5296 == nodeVisualID) {
                    return true;
                }
                if (5297 == nodeVisualID) {
                    return true;
                }
                if (5298 != nodeVisualID) break;
                return true;
            }
            case 3166: {
                if (5299 == nodeVisualID) {
                    return true;
                }
                if (5300 == nodeVisualID) {
                    return true;
                }
                if (5301 != nodeVisualID) break;
                return true;
            }
            case 3120: {
                if (5198 == nodeVisualID) {
                    return true;
                }
                if (5402 == nodeVisualID) {
                    return true;
                }
                if (3129 != nodeVisualID) break;
                return true;
            }
            case 3129: {
                if (5211 == nodeVisualID) {
                    return true;
                }
                if (5212 != nodeVisualID) break;
                return true;
            }
            case 3121: {
                if (5199 == nodeVisualID) {
                    return true;
                }
                if (5401 == nodeVisualID) {
                    return true;
                }
                if (3141 == nodeVisualID) {
                    return true;
                }
                if (3154 == nodeVisualID) {
                    return true;
                }
                if (3167 != nodeVisualID) break;
                return true;
            }
            case 3141: {
                if (5237 == nodeVisualID) {
                    return true;
                }
                if (5238 != nodeVisualID) break;
                return true;
            }
            case 3154: {
                if (5302 == nodeVisualID) {
                    return true;
                }
                if (5303 == nodeVisualID) {
                    return true;
                }
                if (5304 != nodeVisualID) break;
                return true;
            }
            case 3167: {
                if (5305 == nodeVisualID) {
                    return true;
                }
                if (5306 == nodeVisualID) {
                    return true;
                }
                if (5307 != nodeVisualID) break;
                return true;
            }
            case 3122: {
                if (5200 == nodeVisualID) {
                    return true;
                }
                if (5403 == nodeVisualID) {
                    return true;
                }
                if (3130 == nodeVisualID) {
                    return true;
                }
                if (3142 == nodeVisualID) {
                    return true;
                }
                if (3155 == nodeVisualID) {
                    return true;
                }
                if (3168 != nodeVisualID) break;
                return true;
            }
            case 3130: {
                if (5213 == nodeVisualID) {
                    return true;
                }
                if (5214 != nodeVisualID) break;
                return true;
            }
            case 3142: {
                if (5239 == nodeVisualID) {
                    return true;
                }
                if (5240 != nodeVisualID) break;
                return true;
            }
            case 3155: {
                if (5308 == nodeVisualID) {
                    return true;
                }
                if (5309 == nodeVisualID) {
                    return true;
                }
                if (5310 != nodeVisualID) break;
                return true;
            }
            case 3168: {
                if (5311 == nodeVisualID) {
                    return true;
                }
                if (5312 == nodeVisualID) {
                    return true;
                }
                if (5313 != nodeVisualID) break;
                return true;
            }
            case 3123: {
                if (5201 == nodeVisualID) {
                    return true;
                }
                if (5404 == nodeVisualID) {
                    return true;
                }
                if (3131 == nodeVisualID) {
                    return true;
                }
                if (3143 == nodeVisualID) {
                    return true;
                }
                if (3156 == nodeVisualID) {
                    return true;
                }
                if (3169 != nodeVisualID) break;
                return true;
            }
            case 3131: {
                if (5215 == nodeVisualID) {
                    return true;
                }
                if (5216 != nodeVisualID) break;
                return true;
            }
            case 3143: {
                if (5241 == nodeVisualID) {
                    return true;
                }
                if (5242 != nodeVisualID) break;
                return true;
            }
            case 3156: {
                if (5314 == nodeVisualID) {
                    return true;
                }
                if (5315 == nodeVisualID) {
                    return true;
                }
                if (5316 != nodeVisualID) break;
                return true;
            }
            case 3169: {
                if (5317 == nodeVisualID) {
                    return true;
                }
                if (5318 == nodeVisualID) {
                    return true;
                }
                if (5319 != nodeVisualID) break;
                return true;
            }
            case 3124: {
                if (5202 == nodeVisualID) {
                    return true;
                }
                if (5405 == nodeVisualID) {
                    return true;
                }
                if (3144 == nodeVisualID) {
                    return true;
                }
                if (3157 == nodeVisualID) {
                    return true;
                }
                if (3170 != nodeVisualID) break;
                return true;
            }
            case 3144: {
                if (5243 == nodeVisualID) {
                    return true;
                }
                if (5244 != nodeVisualID) break;
                return true;
            }
            case 3157: {
                if (5320 == nodeVisualID) {
                    return true;
                }
                if (5321 == nodeVisualID) {
                    return true;
                }
                if (5322 != nodeVisualID) break;
                return true;
            }
            case 3170: {
                if (5323 == nodeVisualID) {
                    return true;
                }
                if (5324 == nodeVisualID) {
                    return true;
                }
                if (5325 != nodeVisualID) break;
                return true;
            }
            case 3198: {
                if (5406 == nodeVisualID) {
                    return true;
                }
                if (5407 == nodeVisualID) {
                    return true;
                }
                if (3199 == nodeVisualID) {
                    return true;
                }
                if (3200 == nodeVisualID) {
                    return true;
                }
                if (3201 == nodeVisualID) {
                    return true;
                }
                if (3202 != nodeVisualID) break;
                return true;
            }
            case 3199: {
                if (5408 == nodeVisualID) {
                    return true;
                }
                if (5409 != nodeVisualID) break;
                return true;
            }
            case 3200: {
                if (5410 == nodeVisualID) {
                    return true;
                }
                if (5411 == nodeVisualID) {
                    return true;
                }
                if (5412 != nodeVisualID) break;
                return true;
            }
            case 3201: {
                if (5413 == nodeVisualID) {
                    return true;
                }
                if (5414 == nodeVisualID) {
                    return true;
                }
                if (5415 != nodeVisualID) break;
                return true;
            }
            case 3202: {
                if (5416 == nodeVisualID) {
                    return true;
                }
                if (5417 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3067 == nodeVisualID) {
                    return true;
                }
                if (3068 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3102 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3112 == nodeVisualID) {
                    return true;
                }
                if (3113 == nodeVisualID) {
                    return true;
                }
                if (3114 == nodeVisualID) {
                    return true;
                }
                if (3115 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 == nodeVisualID) {
                    return true;
                }
                if (3121 == nodeVisualID) {
                    return true;
                }
                if (3122 == nodeVisualID) {
                    return true;
                }
                if (3123 == nodeVisualID) {
                    return true;
                }
                if (3124 == nodeVisualID) {
                    return true;
                }
                if (3198 != nodeVisualID) break;
                return true;
            }
            case 7008: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3112 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3198 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3102 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3112 == nodeVisualID) {
                    return true;
                }
                if (3113 == nodeVisualID) {
                    return true;
                }
                if (3114 == nodeVisualID) {
                    return true;
                }
                if (3115 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 == nodeVisualID) {
                    return true;
                }
                if (3121 == nodeVisualID) {
                    return true;
                }
                if (3122 == nodeVisualID) {
                    return true;
                }
                if (3123 == nodeVisualID) {
                    return true;
                }
                if (3124 == nodeVisualID) {
                    return true;
                }
                if (3198 != nodeVisualID) break;
                return true;
            }
            case 7010: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3102 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3112 == nodeVisualID) {
                    return true;
                }
                if (3113 == nodeVisualID) {
                    return true;
                }
                if (3114 == nodeVisualID) {
                    return true;
                }
                if (3115 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 == nodeVisualID) {
                    return true;
                }
                if (3121 == nodeVisualID) {
                    return true;
                }
                if (3122 == nodeVisualID) {
                    return true;
                }
                if (3123 == nodeVisualID) {
                    return true;
                }
                if (3124 == nodeVisualID) {
                    return true;
                }
                if (3198 != nodeVisualID) break;
                return true;
            }
            case 7012: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3102 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3112 == nodeVisualID) {
                    return true;
                }
                if (3113 == nodeVisualID) {
                    return true;
                }
                if (3114 == nodeVisualID) {
                    return true;
                }
                if (3115 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 == nodeVisualID) {
                    return true;
                }
                if (3121 == nodeVisualID) {
                    return true;
                }
                if (3122 == nodeVisualID) {
                    return true;
                }
                if (3123 == nodeVisualID) {
                    return true;
                }
                if (3124 == nodeVisualID) {
                    return true;
                }
                if (3198 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3102 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3112 == nodeVisualID) {
                    return true;
                }
                if (3113 == nodeVisualID) {
                    return true;
                }
                if (3114 == nodeVisualID) {
                    return true;
                }
                if (3115 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 == nodeVisualID) {
                    return true;
                }
                if (3121 == nodeVisualID) {
                    return true;
                }
                if (3122 == nodeVisualID) {
                    return true;
                }
                if (3123 == nodeVisualID) {
                    return true;
                }
                if (3124 == nodeVisualID) {
                    return true;
                }
                if (3198 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3067 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3102 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3112 == nodeVisualID) {
                    return true;
                }
                if (3113 == nodeVisualID) {
                    return true;
                }
                if (3114 == nodeVisualID) {
                    return true;
                }
                if (3115 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 == nodeVisualID) {
                    return true;
                }
                if (3121 == nodeVisualID) {
                    return true;
                }
                if (3122 == nodeVisualID) {
                    return true;
                }
                if (3123 == nodeVisualID) {
                    return true;
                }
                if (3124 == nodeVisualID) {
                    return true;
                }
                if (3198 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3102 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3112 == nodeVisualID) {
                    return true;
                }
                if (3113 == nodeVisualID) {
                    return true;
                }
                if (3114 == nodeVisualID) {
                    return true;
                }
                if (3115 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 == nodeVisualID) {
                    return true;
                }
                if (3121 == nodeVisualID) {
                    return true;
                }
                if (3122 == nodeVisualID) {
                    return true;
                }
                if (3123 == nodeVisualID) {
                    return true;
                }
                if (3124 == nodeVisualID) {
                    return true;
                }
                if (3198 != nodeVisualID) break;
                return true;
            }
            case 7014: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7015: {
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 7016: {
                if (3003 != nodeVisualID) break;
                return true;
            }
            case 7013: {
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3034 == nodeVisualID) {
                    return true;
                }
                if (3035 == nodeVisualID) {
                    return true;
                }
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3078 == nodeVisualID) {
                    return true;
                }
                if (3042 == nodeVisualID) {
                    return true;
                }
                if (3052 == nodeVisualID) {
                    return true;
                }
                if (3063 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3069 == nodeVisualID) {
                    return true;
                }
                if (3070 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3073 == nodeVisualID) {
                    return true;
                }
                if (3065 == nodeVisualID) {
                    return true;
                }
                if (3067 == nodeVisualID) {
                    return true;
                }
                if (3068 == nodeVisualID) {
                    return true;
                }
                if (3080 == nodeVisualID) {
                    return true;
                }
                if (3081 == nodeVisualID) {
                    return true;
                }
                if (3083 == nodeVisualID) {
                    return true;
                }
                if (3086 == nodeVisualID) {
                    return true;
                }
                if (3088 == nodeVisualID) {
                    return true;
                }
                if (3091 == nodeVisualID) {
                    return true;
                }
                if (3095 == nodeVisualID) {
                    return true;
                }
                if (3097 == nodeVisualID) {
                    return true;
                }
                if (3099 == nodeVisualID) {
                    return true;
                }
                if (3102 == nodeVisualID) {
                    return true;
                }
                if (3104 == nodeVisualID) {
                    return true;
                }
                if (3059 == nodeVisualID) {
                    return true;
                }
                if (3113 == nodeVisualID) {
                    return true;
                }
                if (3114 == nodeVisualID) {
                    return true;
                }
                if (3115 == nodeVisualID) {
                    return true;
                }
                if (3117 == nodeVisualID) {
                    return true;
                }
                if (3116 == nodeVisualID) {
                    return true;
                }
                if (3118 == nodeVisualID) {
                    return true;
                }
                if (3119 == nodeVisualID) {
                    return true;
                }
                if (3120 == nodeVisualID) {
                    return true;
                }
                if (3121 == nodeVisualID) {
                    return true;
                }
                if (3122 == nodeVisualID) {
                    return true;
                }
                if (3123 == nodeVisualID) {
                    return true;
                }
                if (3124 == nodeVisualID) {
                    return true;
                }
                if (3198 != nodeVisualID) break;
                return true;
            }
            case 4003: {
                if (6001 == nodeVisualID) {
                    return true;
                }
                if (6002 == nodeVisualID) {
                    return true;
                }
                if (6005 == nodeVisualID) {
                    return true;
                }
                if (6006 == nodeVisualID) {
                    return true;
                }
                if (6007 == nodeVisualID) {
                    return true;
                }
                if (6008 == nodeVisualID) {
                    return true;
                }
                if (6010 == nodeVisualID) {
                    return true;
                }
                if (6014 != nodeVisualID) break;
                return true;
            }
            case 4004: {
                if (6003 == nodeVisualID) {
                    return true;
                }
                if (6004 == nodeVisualID) {
                    return true;
                }
                if (6009 == nodeVisualID) {
                    return true;
                }
                if (6011 == nodeVisualID) {
                    return true;
                }
                if (6013 != nodeVisualID) break;
                return true;
            }
            case 4005: {
                if (6012 == nodeVisualID) {
                    return true;
                }
                if (6015 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getObjectFlow().isSuperTypeOf(domainElement.eClass())) {
            return 4003;
        }
        if (UMLPackage.eINSTANCE.getControlFlow().isSuperTypeOf(domainElement.eClass())) {
            return 4004;
        }
        if (UMLPackage.eINSTANCE.getExceptionHandler().isSuperTypeOf(domainElement.eClass())) {
            return 4005;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    private static boolean isActionInputPin_3021(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(0, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3022(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(1, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3023(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(2, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3025(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(3, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3026(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(4, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3027(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(5, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isConstraint_3011(Constraint domainElement) {
        Object result = UMLOCLFactory.getExpression(12, (EClassifier)UMLPackage.eINSTANCE.getConstraint(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isConstraint_3012(Constraint domainElement) {
        Object result = UMLOCLFactory.getExpression(13, (EClassifier)UMLPackage.eINSTANCE.getConstraint(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3046(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(14, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3047(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(15, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3048(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(16, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3049(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(17, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3050(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(18, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3051(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(19, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3053(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(20, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3054(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(21, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3055(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(22, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3060(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(23, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3061(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(24, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3062(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(25, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isExpansionNode_3074(ExpansionNode domainElement) {
        Object result = UMLOCLFactory.getExpression(26, (EClassifier)UMLPackage.eINSTANCE.getExpansionNode(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isExpansionNode_3075(ExpansionNode domainElement) {
        Object result = UMLOCLFactory.getExpression(27, (EClassifier)UMLPackage.eINSTANCE.getExpansionNode(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3105(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(153, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isOutputPin_3109(OutputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(150, (EClassifier)UMLPackage.eINSTANCE.getOutputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isOutputPin_3110(OutputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(149, (EClassifier)UMLPackage.eINSTANCE.getOutputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isOutputPin_3111(OutputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(148, (EClassifier)UMLPackage.eINSTANCE.getOutputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3188(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(147, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3189(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(152, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3190(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(151, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3092(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3092(domainElement);
    }

    private static boolean isInputPin_3092(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(139, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3093(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3093(domainElement);
    }

    private static boolean isInputPin_3093(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(145, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3181(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(142, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3182(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(138, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3183(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(144, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3184(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(141, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3185(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(140, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3186(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(146, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3187(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(143, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3096(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3096(domainElement);
    }

    private static boolean isInputPin_3096(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(127, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3173(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(126, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3174(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(128, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isOutputPin_3098(View containerView, OutputPin domainElement) {
        return UMLVisualIDRegistry.isOutputPin_3098(domainElement);
    }

    private static boolean isOutputPin_3098(OutputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(32, (EClassifier)UMLPackage.eINSTANCE.getOutputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3100(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3100(domainElement);
    }

    private static boolean isInputPin_3100(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(133, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3101(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3101(domainElement);
    }

    private static boolean isInputPin_3101(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(130, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3175(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(134, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3176(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(131, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3177(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(132, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3178(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(129, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3103(View containerView, InputPin domainElement) {
        return UMLVisualIDRegistry.isInputPin_3103(domainElement);
    }

    private static boolean isInputPin_3103(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(135, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3179(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(137, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3180(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(136, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3132(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(88, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3145(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(90, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3158(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(92, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3133(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(87, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3146(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(89, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3159(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(91, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3134(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(93, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3135(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(94, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3147(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(95, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3148(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(96, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3160(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(97, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3161(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(98, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3136(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(99, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3149(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(100, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3162(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(101, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isCreateLinkAction_3117(CreateLinkAction domainElement) {
        Object result = UMLOCLFactory.getExpression(154, (EClassifier)UMLPackage.eINSTANCE.getCreateLinkAction(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3137(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(102, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3151(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(103, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3163(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(104, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3138(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(105, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3150(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(106, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3164(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(107, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3139(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(108, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3152(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(109, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3165(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(110, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3140(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(111, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3153(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(112, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3166(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(113, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3141(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(115, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3154(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(116, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3167(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(114, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3142(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(119, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3155(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(117, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3168(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(118, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3143(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(120, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3156(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(121, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3169(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(122, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isInputPin_3144(InputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(124, (EClassifier)UMLPackage.eINSTANCE.getInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isValuePin_3157(ValuePin domainElement) {
        Object result = UMLOCLFactory.getExpression(125, (EClassifier)UMLPackage.eINSTANCE.getValuePin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isActionInputPin_3170(ActionInputPin domainElement) {
        Object result = UMLOCLFactory.getExpression(123, (EClassifier)UMLPackage.eINSTANCE.getActionInputPin(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isCreateLinkObjectAction_3198(CreateLinkObjectAction domainElement) {
        Object result = UMLOCLFactory.getExpression(155, (EClassifier)UMLPackage.eINSTANCE.getCreateLinkObjectAction(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7001: 
            case 7002: 
            case 7003: 
            case 7004: 
            case 7005: 
            case 7006: 
            case 7007: 
            case 7008: 
            case 7009: 
            case 7010: 
            case 7012: 
            case 7013: 
            case 7014: 
            case 7015: 
            case 7016: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1000: {
                return false;
            }
            case 3001: 
            case 3002: 
            case 3003: 
            case 3004: 
            case 3005: 
            case 3006: 
            case 3011: 
            case 3012: 
            case 3013: 
            case 3014: 
            case 3015: 
            case 3016: 
            case 3017: 
            case 3018: 
            case 3019: 
            case 3020: 
            case 3021: 
            case 3022: 
            case 3023: 
            case 3024: 
            case 3025: 
            case 3026: 
            case 3027: 
            case 3032: 
            case 3033: 
            case 3034: 
            case 3035: 
            case 3036: 
            case 3037: 
            case 3038: 
            case 3039: 
            case 3040: 
            case 3041: 
            case 3046: 
            case 3047: 
            case 3048: 
            case 3049: 
            case 3050: 
            case 3051: 
            case 3053: 
            case 3054: 
            case 3055: 
            case 3059: 
            case 3060: 
            case 3061: 
            case 3062: 
            case 3064: 
            case 3074: 
            case 3075: 
            case 3077: 
            case 3078: 
            case 3080: 
            case 3084: 
            case 3085: 
            case 3087: 
            case 3089: 
            case 3090: 
            case 3092: 
            case 3093: 
            case 3094: 
            case 3096: 
            case 3098: 
            case 3100: 
            case 3101: 
            case 3103: 
            case 3104: 
            case 3105: 
            case 3109: 
            case 3110: 
            case 3111: 
            case 3112: 
            case 3125: 
            case 3126: 
            case 3127: 
            case 3128: 
            case 3129: 
            case 3130: 
            case 3131: 
            case 3132: 
            case 3133: 
            case 3134: 
            case 3135: 
            case 3136: 
            case 3137: 
            case 3138: 
            case 3139: 
            case 3140: 
            case 3141: 
            case 3142: 
            case 3143: 
            case 3144: 
            case 3145: 
            case 3146: 
            case 3147: 
            case 3148: 
            case 3149: 
            case 3150: 
            case 3151: 
            case 3152: 
            case 3153: 
            case 3154: 
            case 3155: 
            case 3156: 
            case 3157: 
            case 3158: 
            case 3159: 
            case 3160: 
            case 3161: 
            case 3162: 
            case 3163: 
            case 3164: 
            case 3165: 
            case 3166: 
            case 3167: 
            case 3168: 
            case 3169: 
            case 3170: 
            case 3173: 
            case 3174: 
            case 3175: 
            case 3176: 
            case 3177: 
            case 3178: 
            case 3179: 
            case 3180: 
            case 3181: 
            case 3182: 
            case 3183: 
            case 3184: 
            case 3185: 
            case 3186: 
            case 3187: 
            case 3188: 
            case 3189: 
            case 3190: 
            case 3191: 
            case 3192: 
            case 3193: 
            case 3199: 
            case 3200: 
            case 3201: 
            case 3202: {
                return true;
            }
        }
        return false;
    }

    private static boolean isIntervalConstraint_3032(IntervalConstraint domainElement) {
        Object result = UMLOCLFactory.getExpression(10, (EClassifier)UMLPackage.eINSTANCE.getIntervalConstraint(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isIntervalConstraint_3033(IntervalConstraint domainElement) {
        Object result = UMLOCLFactory.getExpression(11, (EClassifier)UMLPackage.eINSTANCE.getIntervalConstraint(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isDurationConstraint_3034(DurationConstraint domainElement) {
        Object result = UMLOCLFactory.getExpression(6, (EClassifier)UMLPackage.eINSTANCE.getDurationConstraint(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isDurationConstraint_3035(DurationConstraint domainElement) {
        Object result = UMLOCLFactory.getExpression(7, (EClassifier)UMLPackage.eINSTANCE.getDurationConstraint(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isTimeConstraint_3036(TimeConstraint domainElement) {
        Object result = UMLOCLFactory.getExpression(8, (EClassifier)UMLPackage.eINSTANCE.getTimeConstraint(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }

    private static boolean isTimeConstraint_3037(TimeConstraint domainElement) {
        Object result = UMLOCLFactory.getExpression(9, (EClassifier)UMLPackage.eINSTANCE.getTimeConstraint(), null).evaluate(domainElement);
        return result instanceof Boolean && (Boolean)result != false;
    }
}

