/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.providers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLViewProvider;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.uml2.uml.UMLPackage;

public class CustomUMLViewProvider
extends UMLViewProvider {
    @Override
    public Edge createControlFlow_4004(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Edge edge = super.createControlFlow_4004(domainElement, containerView, index, persisted, preferencesHint);
        if (edge != null) {
            EObject semanticElement = edge.getElement();
            if (semanticElement != null) {
                if (!semanticElement.eIsSet((EStructuralFeature)UMLPackage.Literals.ACTIVITY_EDGE__INTERRUPTS)) {
                    this.deleteView(edge, 6013);
                }
            } else {
                this.deleteView(edge, 6013);
            }
        }
        return edge;
    }

    @Override
    public Edge createObjectFlow_4003(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Edge edge = super.createObjectFlow_4003(domainElement, containerView, index, persisted, preferencesHint);
        if (edge != null) {
            EObject semanticElement = edge.getElement();
            if (semanticElement != null) {
                if (!semanticElement.eIsSet((EStructuralFeature)UMLPackage.Literals.ACTIVITY_EDGE__INTERRUPTS)) {
                    this.deleteView(edge, 6014);
                }
            } else {
                this.deleteView(edge, 6014);
            }
        }
        return edge;
    }

    private void deleteView(Edge edge, int semanticHint) {
        View interruptibleIconView = ViewUtil.getChildBySemanticHint((View)edge, (String)String.valueOf(semanticHint));
        if (interruptibleIconView != null) {
            ViewUtil.destroy((View)interruptibleIconView);
        }
    }

    public Node createInterruptibleEdgeIconOnControlFlow(View edge, PreferencesHint preferencesHint) {
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        Node label = this.createLabel(edge, UMLVisualIDRegistry.getType(6013));
        label.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"ControlFlow");
        return label;
    }

    public Node createInterruptibleEdgeIconOnObjectlFlow(View containerView, PreferencesHint preferencesHint) {
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        Node label = this.createLabel(containerView, UMLVisualIDRegistry.getType(6014));
        label.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)containerView, (IPreferenceStore)prefStore, (String)"ObjectFlow");
        return label;
    }

    @Override
    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        int visualID = semanticHint == null ? UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement) : UMLVisualIDRegistry.getVisualID(semanticHint);
        Node node = this.createCustomNode(visualID, containerView, preferencesHint);
        return node != null ? node : super.createNode(semanticAdapter, containerView, semanticHint, index, persisted, preferencesHint);
    }

    @Override
    protected boolean provides(CreateNodeViewOperation op) {
        return super.provides(op) || this.isCustomNode(op);
    }

    protected boolean isCustomNode(CreateNodeViewOperation op) {
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (op.getContainerView() != null && op.getSemanticHint() != null && elementType == null) {
            int visualID = UMLVisualIDRegistry.getVisualID(op.getSemanticHint());
            return this.isCustomNode(visualID);
        }
        return false;
    }

    protected boolean isCustomNode(int visualID) {
        switch (visualID) {
            case 6013: 
            case 6014: {
                return true;
            }
        }
        return false;
    }

    protected Node createCustomNode(int visualID, View containerView, PreferencesHint preferencesHint) {
        switch (visualID) {
            case 6013: {
                return this.createInterruptibleEdgeIconOnControlFlow(containerView, preferencesHint);
            }
            case 6014: {
                return this.createInterruptibleEdgeIconOnObjectlFlow(containerView, preferencesHint);
            }
        }
        return null;
    }
}

