/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.dialogs.CreateOrShowExistingLinkDialog;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.LinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.common.messages.Messages;
import org.eclipse.papyrus.uml.diagram.common.util.LinkEndsMapper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateOrShowExistingElementHelper {
    protected final ILinkMappingHelper linkMappingHelper;
    public static final String DISPLAY_DIALOG_FOR_CREATE_OR_RESTORE_ELEMENT = "Display Dialog For Create Or Restore Element";

    public CreateOrShowExistingElementHelper() {
        this(new ILinkMappingHelper(){

            @Override
            public Collection<?> getTarget(Element link) {
                return LinkMappingHelper.getTarget(link);
            }

            @Override
            public Collection<?> getSource(Element link) {
                return LinkMappingHelper.getSource(link);
            }
        });
    }

    public CreateOrShowExistingElementHelper(ILinkMappingHelper linkHelper) {
        this.linkMappingHelper = linkHelper;
    }

    public Command getCreateOrRestoreElementCommand(CreateRelationshipRequest req, Command defaultCommand, IElementType linkElementType) {
        List<LinkEndsMapper> existingElements;
        EObject container;
        if (this.showDialogAccordingPreferences() && defaultCommand.canExecute() && (container = req.getContainer()) instanceof Element && (existingElements = this.getExistingLinksBetweenSourceAndTarget(req, linkElementType)).size() > 0) {
            String className = this.getIElementTypeNameToDisplay(linkElementType);
            String dialogTitle = NLS.bind((String)Messages.CreateOrShowExistingElementHelper_CreateOrRestoreX, (Object)className);
            String dialogMessage = NLS.bind((String)Messages.CreateOrShowExistingElementHelper_XBetweenTheseElementAlreadyExists, (Object)className);
            CreateOrShowExistingLinkDialog dialog = new CreateOrShowExistingLinkDialog(dialogTitle, dialogMessage, existingElements);
            return new ICommandProxy(CreateOrShowExistingElementHelper.getOpenLinkDialogCommand(req, defaultCommand, dialog, existingElements));
        }
        return defaultCommand;
    }

    protected boolean hasWantedType(EObject element, IElementType elementType) {
        return element.eClass() == elementType.getEClass();
    }

    protected boolean showDialogAccordingPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean contains = store.contains(DISPLAY_DIALOG_FOR_CREATE_OR_RESTORE_ELEMENT);
        if (!contains) {
            store.setValue(DISPLAY_DIALOG_FOR_CREATE_OR_RESTORE_ELEMENT, "always");
            store.setDefault(DISPLAY_DIALOG_FOR_CREATE_OR_RESTORE_ELEMENT, "never");
        }
        return store.getString(DISPLAY_DIALOG_FOR_CREATE_OR_RESTORE_ELEMENT).equals("always");
    }

    protected String getIElementTypeNameToDisplay(IElementType elementType) {
        return elementType.getEClass().getName();
    }

    protected List<LinkEndsMapper> getExistingLinksBetweenSourceAndTarget(CreateRelationshipRequest request, IElementType wantedElementType) {
        ArrayList<LinkEndsMapper> existingElement = new ArrayList<LinkEndsMapper>();
        for (Element current : ((Element)request.getContainer()).getOwnedElements()) {
            if (!this.hasWantedType((EObject)current, wantedElementType)) continue;
            Collection<?> sources = this.linkMappingHelper.getSource(current);
            Collection<?> targets = this.linkMappingHelper.getTarget(current);
            if (!sources.contains(request.getSource()) || !targets.contains(request.getTarget())) continue;
            EClass wantedEClass = wantedElementType.getEClass();
            if (wantedEClass == UMLPackage.eINSTANCE.getConnector() || wantedEClass == UMLPackage.eINSTANCE.getAssociation()) {
                existingElement.add(new LinkEndsMapper((EObject)current, sources, null, null));
                continue;
            }
            existingElement.add(new LinkEndsMapper((EObject)current, null, sources, targets));
        }
        return existingElement;
    }

    public static final ICommand getOpenLinkDialogCommand(final CreateRelationshipRequest request, final Command defaultCommand, final CreateOrShowExistingLinkDialog dialog, List<LinkEndsMapper> existingEObject) {
        AbstractTransactionalCommand compoundCommand = new AbstractTransactionalCommand(request.getEditingDomain(), "", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                int result = dialog.open();
                switch (result) {
                    case 0: {
                        defaultCommand.execute();
                        return CommandResult.newOKCommandResult((Object)request.getNewElement());
                    }
                    case 1: {
                        EObject selectedElement = dialog.getResult();
                        if (selectedElement != null) {
                            request.setNewElement(selectedElement);
                            return CommandResult.newOKCommandResult((Object)selectedElement);
                        }
                        return CommandResult.newErrorCommandResult((String)"The selected element in the dialog is null");
                    }
                }
                return CommandResult.newCancelledCommandResult();
            }

            public boolean canExecute() {
                return defaultCommand.canExecute();
            }
        };
        return compoundCommand;
    }

    public ILinkMappingHelper getLinkMappingHelper() {
        return this.linkMappingHelper;
    }
}

