/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.uml.diagram.common.service.IPapyrusPaletteConstant;
import org.eclipse.papyrus.uml.diagram.common.service.XMLPaletteDefinitionVisitor;
import org.eclipse.papyrus.uml.diagram.common.service.palette.AspectToolService;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.uml.diagram.common.service.palette.StereotypePostAction;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPaletteDefinitionProfileInspector
implements XMLPaletteDefinitionVisitor,
IPapyrusPaletteConstant {
    private final Collection<String> requiredProfiles = new HashSet<String>();

    public Collection<String> getRequiredProfiles() {
        return this.requiredProfiles;
    }

    @Override
    public void onContent(Node node) {
    }

    @Override
    public void onDrawer(Node node) {
    }

    @Override
    public void onToolEntry(Node node) {
    }

    @Override
    public void onStack(Node node) {
    }

    @Override
    public void onSeparator(Node node) {
    }

    @Override
    public void onAspectToolEntry(Node node) {
        if (node.getChildNodes().getLength() > 0) {
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node childNode = children.item(i);
                String childName = childNode.getNodeName();
                if ("postAction".equals(childName)) {
                    IAspectActionProvider provider = AspectToolService.getInstance().getProvider(AspectToolService.getProviderId(childNode));
                    if (provider != null) {
                        IAspectAction action = provider.createAction(childNode);
                        if (action instanceof StereotypePostAction) {
                            List<String> stereotypesToApply = ((StereotypePostAction)action).getStereotypesToApply();
                            for (String stereotypeQN : stereotypesToApply) {
                                String profileName = PaletteUtil.findProfileNameFromStereotypeName(stereotypeQN);
                                this.requiredProfiles.add(profileName);
                            }
                        }
                    } else {
                        Activator.log.error("impossible to find factory with id: " + AspectToolService.getProviderId(childNode), null);
                    }
                }
                ++i;
            }
        }
    }
}

