/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.sheet;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class UMLPropertySource
extends PropertySource {
    public UMLPropertySource(Object object, IItemPropertySource ips) {
        super(object, ips);
    }

    protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
        return new CustomPropertyDescriptor(this.object, itemPropertyDescriptor);
    }

    public static Collection<?> filterOwned(Object parent, Collection<?> in) {
        BasicEList list = new BasicEList();
        for (Object obj : in) {
            if (!(obj instanceof EObject) || !UMLPropertySource.isOwned(parent, (EObject)obj)) continue;
            list.add((Object)((EObject)obj));
        }
        return list;
    }

    public static boolean isOwned(Object parent, EObject child) {
        child = child.eContainer();
        while (child != null) {
            if (child == parent) {
                return true;
            }
            child = child.eContainer();
        }
        return false;
    }

    private class CustomPropertyDescriptor
    extends PropertyDescriptor {
        public CustomPropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
            super(object, itemPropertyDescriptor);
        }

        public CellEditor createPropertyEditor(Composite composite) {
            if (!this.itemPropertyDescriptor.canSetProperty(this.object)) {
                return null;
            }
            Object result = null;
            final Object genericFeature = this.itemPropertyDescriptor.getFeature(this.object);
            if (genericFeature instanceof EReference && !((EReference)genericFeature).isMany()) {
                final ILabelProvider editLabelProvider = this.getEditLabelProvider();
                result = new ExtendedDialogCellEditor(composite, editLabelProvider){

                    protected Object openDialogBox(Control cellEditorWindow) {
                        ElementListSelectionDialog dialog = new ElementListSelectionDialog(cellEditorWindow.getShell(), editLabelProvider);
                        dialog.setTitle("Element Selection");
                        dialog.setMessage("Select a String (* = any string, ? = any char):");
                        LinkedList<String> result = new LinkedList<String>();
                        Collection collection = CustomPropertyDescriptor.this.itemPropertyDescriptor.getChoiceOfValues(CustomPropertyDescriptor.this.object);
                        result.add("");
                        if (genericFeature instanceof ENamedElement && ((ENamedElement)genericFeature).getName().equals("classifierBehavior")) {
                            Collection all = CustomPropertyDescriptor.this.itemPropertyDescriptor.getChoiceOfValues(CustomPropertyDescriptor.this.object);
                            result.addAll(UMLPropertySource.filterOwned(CustomPropertyDescriptor.this.object, collection));
                        } else {
                            result.addAll(collection);
                        }
                        result.remove(null);
                        dialog.setElements(result.toArray());
                        Object toReturn = null;
                        if (dialog.open() == 0) {
                            toReturn = dialog.getFirstResult();
                            if ("".equals(toReturn)) {
                                toReturn = CustomPropertyDescriptor.this.itemPropertyDescriptor.getPropertyValue(null);
                            }
                        } else {
                            toReturn = CustomPropertyDescriptor.this.itemPropertyDescriptor.getPropertyValue(CustomPropertyDescriptor.this.object);
                        }
                        return toReturn;
                    }
                };
            } else {
                result = super.createPropertyEditor(composite);
            }
            return result;
        }
    }
}

