/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.display.command;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.EObjectValueStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;

public class CreateAppliedStereotypeCommentViewCommand
extends RecordingCommand {
    protected View owner;
    protected EObject base_element;
    protected int x;
    protected int y;
    protected TransactionalEditingDomain domain;
    protected Boolean isBorderedElement;

    public CreateAppliedStereotypeCommentViewCommand(TransactionalEditingDomain domain, View owner, int x, int y, EObject base_Element, boolean isABordererElement) {
        super(domain, "CreateAppliedStereotypeCommentView");
        this.owner = owner;
        this.base_element = base_Element;
        this.x = x;
        this.y = y;
        this.domain = domain;
        this.isBorderedElement = isABordererElement;
    }

    public void doExecute() {
        Shape node = NotationFactory.eINSTANCE.createShape();
        Bounds bounds = NotationFactory.eINSTANCE.createBounds();
        bounds.setX(this.x);
        bounds.setY(this.y);
        node.setLayoutConstraint((LayoutConstraint)bounds);
        TitleStyle ts = NotationFactory.eINSTANCE.createTitleStyle();
        ts.setShowTitle(true);
        node.getStyles().add((Object)ts);
        node.setElement(null);
        node.setType("StereotypeComment");
        this.connectCommentNode(this.owner, (Node)node);
        EObjectValueStyle eObjectValueStyle = (EObjectValueStyle)node.createStyle(NotationPackage.eINSTANCE.getEObjectValueStyle());
        eObjectValueStyle.setEObjectValue(this.base_element);
        eObjectValueStyle.setName("BASE_ELEMENT");
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)this.owner.getDiagram(), (View)edge, (int)-1, (boolean)true);
        edge.setType("StereotypeCommentLink");
        edge.setElement(this.base_element);
        IdentityAnchor anchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        edge.setSourceAnchor((Anchor)anchor);
        anchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        edge.setTargetAnchor((Anchor)anchor);
        edge.setSource(this.owner);
        edge.setTarget((View)node);
        edge.setElement(null);
        eObjectValueStyle = (EObjectValueStyle)edge.createStyle(NotationPackage.eINSTANCE.getEObjectValueStyle());
        eObjectValueStyle.setEObjectValue(this.base_element);
        eObjectValueStyle.setName("BASE_ELEMENT");
    }

    private void connectCommentNode(View owner, Node commentNode) {
        if (owner instanceof Edge) {
            View viewSource = ((Edge)owner).getSource();
            View viewTarget = ((Edge)owner).getSource();
            ArrayList<View> parentsSource = this.getParentTree(viewSource);
            ArrayList<View> parentsTarget = this.getParentTree(viewTarget);
            View commonParent = null;
            int index = 0;
            while (commonParent == null && index < parentsSource.size()) {
                if (parentsTarget.contains(parentsSource.get(index)) && !((commonParent = parentsSource.get(index)) instanceof BasicCompartment)) {
                    commonParent = null;
                }
                ++index;
            }
            if (commonParent != null) {
                ((Bounds)commentNode.getLayoutConstraint()).setX(100);
                ((Bounds)commentNode.getLayoutConstraint()).setY(100);
                ViewUtil.insertChildView((View)commonParent, (View)commentNode, (int)-1, (boolean)true);
                return;
            }
        }
        View econtainer = (View)owner.eContainer();
        if (this.isBorderedElement.booleanValue() && econtainer.eContainer() != null) {
            econtainer = (View)econtainer.eContainer();
        }
        ViewUtil.insertChildView((View)econtainer, (View)commentNode, (int)-1, (boolean)true);
    }

    private ArrayList<View> getParentTree(View view) {
        ArrayList<View> parents = new ArrayList<View>();
        View currentView = view;
        while (currentView != null) {
            if ((currentView = (View)currentView.eContainer()) == null) continue;
            if (!(currentView instanceof DecorationNode)) {
                boolean cfr_ignored_0 = currentView instanceof BasicCompartment;
            }
            parents.add(currentView);
        }
        return parents;
    }
}

