/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.display.command;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.stereotype.StereotypeLocationEnum;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayCommandExecution;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class RemoveAppliedStereotypePropertiesToDisplayCommand
extends RecordingCommand {
    private View view;
    private TransactionalEditingDomain domain;
    private Stereotype stereotype;
    private Property property;
    private String location;
    private static StereotypeDisplayUtil helper = StereotypeDisplayUtil.getInstance();
    private static StereotypeDisplayCommandExecution commandHelper = StereotypeDisplayCommandExecution.getInstance();

    public RemoveAppliedStereotypePropertiesToDisplayCommand(TransactionalEditingDomain domain, View view, Property property, Stereotype stereotype, String location) {
        super(domain, "Hide a Stereotype Property");
        this.property = property;
        this.stereotype = stereotype;
        this.domain = domain;
        this.view = view;
        this.location = location;
    }

    protected void doExecute() {
        DecorationNode propertyView = null;
        if (StereotypeLocationEnum.IN_COMPARTMENT.equals(this.location)) {
            propertyView = helper.getStereotypeProperty(this.view, this.stereotype, this.property);
        } else if (StereotypeLocationEnum.IN_BRACE.equals(this.location)) {
            propertyView = helper.getStereotypePropertyInBrace(this.view, this.stereotype, this.property);
        } else if (StereotypeLocationEnum.IN_COMMENT.equals(this.location)) {
            propertyView = helper.getStereotypePropertyInComment(this.view, this.stereotype, this.property);
        }
        commandHelper.setUserVisibility(this.domain, (View)propertyView, false);
    }
}

