/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.GMFUnsafe;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.UnsetPersistentViewCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayConstant;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class StereotypeDisplayUtil {
    private static final String EMPTY_STRING = "";
    private static StereotypeDisplayUtil labelHelper;

    private StereotypeDisplayUtil() {
    }

    public static StereotypeDisplayUtil getInstance() {
        if (labelHelper == null) {
            labelHelper = new StereotypeDisplayUtil();
        }
        return labelHelper;
    }

    public EObject getStereotypeApplication(View view, Stereotype stereo) {
        EObject appliedStereotypes = null;
        if (this.isInStereotypeComment((Node)view) && this.getCommentSemanticElement(this.getTopContainer(view)) != null) {
            appliedStereotypes = this.getCommentSemanticElement(this.getTopContainer(view)).getStereotypeApplication(stereo);
        }
        if (this.getContainerSemanticElement(view) != null) {
            appliedStereotypes = this.getContainerSemanticElement(view).getStereotypeApplication(stereo);
        }
        return appliedStereotypes;
    }

    public Element getCommentSemanticElement(View view) {
        EObject baseElement;
        Element elementSemantic = null;
        if (this.isStereotypeComment(view) && (baseElement = NotationUtils.getEObjectValue((View)view, (String)"BASE_ELEMENT", null)) instanceof Element) {
            elementSemantic = (Element)baseElement;
        }
        return elementSemantic;
    }

    public View getTopContainer(View view) {
        View topView = null;
        if (view != null) {
            EObject container = view.eContainer();
            if (this.isStereotypeCompartment(container) || this.isStereotypeBrace(container) || this.isStereotypeLabel(container)) {
                container = container.eContainer();
            }
            if (container instanceof View) {
                topView = (View)container;
            }
        }
        return topView;
    }

    public Element getContainerSemanticElement(View view) {
        Element elementUML = null;
        EObject parentElement = this.getTopContainer(view).getElement();
        if (parentElement instanceof Element) {
            elementUML = (Element)parentElement;
        }
        return elementUML;
    }

    public String getStereotypeTextToDisplay(View model) {
        StringBuilder textToDisplay = new StringBuilder();
        StringBuilder finalText = new StringBuilder();
        Iterator childrenIterator = model.getChildren().iterator();
        boolean displayStereotypes = NotationUtils.getBooleanValue((View)model, (String)"displayStereotypes", (boolean)true);
        while (childrenIterator.hasNext()) {
            Object object = childrenIterator.next();
            if (!this.isStereotypeLabel(object) || !((View)object).isVisible() || !displayStereotypes) continue;
            if (!EMPTY_STRING.equals(textToDisplay.toString()) && textToDisplay != null) {
                textToDisplay.append(", ");
            }
            textToDisplay.append(this.getStereotypeName((DecorationNode)object));
        }
        if (textToDisplay.toString() != null && !EMPTY_STRING.equals(textToDisplay.toString())) {
            finalText.append(StereotypeDisplayConstant.QUOTE_LEFT).append((CharSequence)textToDisplay).append(StereotypeDisplayConstant.QUOTE_RIGHT);
        }
        return finalText.toString();
    }

    public String getStereotypePropertiesInBrace(View notationView) {
        String textToDisplay = EMPTY_STRING;
        for (Object object : notationView.getChildren()) {
            if (!this.isStereotypeBrace(object)) continue;
            BasicCompartment compartment = (BasicCompartment)object;
            textToDisplay = this.addStereotypeCompartmentProperties(textToDisplay, compartment);
        }
        return textToDisplay;
    }

    public String getStereotypeName(DecorationNode label) {
        String name = this.getName(label);
        String depth = this.getDepth(label);
        String nameWithDepth = this.getStereotypeNameWithDepth(name, depth);
        return nameWithDepth;
    }

    public String getStereotypeNameWithDepth(String qualifiedName, String depth) {
        if (depth != null && !EMPTY_STRING.equals(depth)) {
            if ("none".equals(depth)) {
                return this.getMinimumDepthName(qualifiedName);
            }
            if ("full".equals(depth)) {
                return qualifiedName;
            }
            if ("auto".equals(depth)) {
                return qualifiedName;
            }
            try {
                int depthRetrieve = Integer.parseInt(depth);
                if (depthRetrieve > -this.getMaxDepth(qualifiedName) && depthRetrieve < 0) {
                    return this.computeDepthName(depthRetrieve, qualifiedName);
                }
                if (depthRetrieve <= -this.getMaxDepth(qualifiedName)) {
                    return this.getMinimumDepthName(qualifiedName);
                }
                if (depthRetrieve == 0) {
                    return qualifiedName;
                }
                return qualifiedName;
            }
            catch (NumberFormatException e) {
                Activator.log.error("Wrong Depth value. Impossible to parse depth : " + depth, (Throwable)e);
            }
        }
        return qualifiedName;
    }

    protected String computeDepthName(int depthRetrieve, String qualifiedName) {
        StringBuffer name = new StringBuffer(qualifiedName);
        try {
            int i = 0;
            while (i > depthRetrieve) {
                int index = name.indexOf("::");
                name = name.delete(0, index + "::".length());
                --i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            Activator.log.error(e.getMessage(), (Throwable)e);
        }
        return name.toString();
    }

    public String getMinimumDepthName(String qualifiedName) {
        String segment = EMPTY_STRING;
        StringBuffer name = new StringBuffer(qualifiedName);
        int index = name.lastIndexOf("::");
        segment = name.substring(index + "::".length());
        return segment;
    }

    protected int getMaxDepth(String qualifiedName) {
        StringTokenizer tok = new StringTokenizer(qualifiedName, "::");
        return tok.countTokens();
    }

    public DecorationNode getStereotypeLabel(View node, String qualifiedName) {
        if (qualifiedName != null && qualifiedName != EMPTY_STRING) {
            for (Object obj : node.getChildren()) {
                DecorationNode label;
                if (!(obj instanceof DecorationNode) || !"StereotypeLabel".equals((label = (DecorationNode)obj).getType()) || !qualifiedName.equals(this.getName(label))) continue;
                return label;
            }
        }
        return null;
    }

    public DecorationNode getStereotypeProperty(View node, Stereotype stereotype, Property property) {
        BasicCompartment compartment;
        DecorationNode propertyView = null;
        if (stereotype != null && property != null && (compartment = this.getStereotypeCompartment(node, stereotype)) != null) {
            Iterator iter = compartment.getChildren().iterator();
            while (propertyView == null && iter.hasNext()) {
                Object obj = iter.next();
                if (!this.isStereotypeProperty(obj) || !((DecorationNode)obj).getElement().equals(property)) continue;
                propertyView = (DecorationNode)obj;
            }
        }
        return propertyView;
    }

    public DecorationNode getStereotypePropertyInBrace(View node, Stereotype stereotype, Property property) {
        BasicCompartment compartment;
        DecorationNode propertyView = null;
        if (stereotype != null && property != null && (compartment = this.getStereotypeBraceCompartment(node, stereotype)) != null) {
            Iterator iter = compartment.getChildren().iterator();
            while (propertyView == null && iter.hasNext()) {
                Object obj = iter.next();
                if (!this.isStereotypeBraceProperty(obj) || !((DecorationNode)obj).getElement().equals(property)) continue;
                propertyView = (DecorationNode)obj;
            }
        }
        return propertyView;
    }

    public DecorationNode getStereotypePropertyInComment(View mainView, Stereotype stereotype, Property property) {
        BasicCompartment compartment;
        Node node = this.getStereotypeComment(mainView);
        DecorationNode propertyView = null;
        if (stereotype != null && property != null && (compartment = this.getStereotypeCompartment((View)node, stereotype)) != null) {
            Iterator iter = compartment.getChildren().iterator();
            while (propertyView == null && iter.hasNext()) {
                Object obj = iter.next();
                if (!this.isStereotypeProperty(obj) || !((DecorationNode)obj).getElement().equals(property)) continue;
                propertyView = (DecorationNode)obj;
            }
        }
        return propertyView;
    }

    public DecorationNode getStereotypePropertyInCompartment(View node, Stereotype stereotype, Property property) {
        BasicCompartment compartment;
        DecorationNode propertyView = null;
        if (stereotype != null && property != null && (compartment = this.getStereotypeCompartment(node, stereotype)) != null) {
            Iterator iter = compartment.getChildren().iterator();
            while (propertyView == null && iter.hasNext()) {
                Object obj = iter.next();
                if (!this.isStereotypeProperty(obj) || ((DecorationNode)obj).getElement() == null || !((DecorationNode)obj).getElement().equals(property)) continue;
                propertyView = (DecorationNode)obj;
            }
        }
        return propertyView;
    }

    public DecorationNode getStereotypeLabel(View node, Stereotype stereotype) {
        if (stereotype != null && node != null) {
            for (Object obj : node.getChildren()) {
                DecorationNode label;
                if (!(obj instanceof DecorationNode) || !this.isStereotypeLabel(label = (DecorationNode)obj) || !label.getElement().equals(stereotype)) continue;
                return label;
            }
        }
        return null;
    }

    public BasicCompartment getStereotypeCompartment(View node, Stereotype stereotype) {
        if (stereotype != null && node != null) {
            for (Object obj : node.getChildren()) {
                BasicCompartment compartment;
                if (!this.isStereotypeCompartment(obj) || (compartment = (BasicCompartment)obj).getElement() == null || !compartment.getElement().equals(stereotype)) continue;
                return compartment;
            }
        }
        return null;
    }

    public Node getStereotypeComment(View SemanticView) {
        Node node = null;
        if (SemanticView != null && SemanticView.getSourceEdges() != null) {
            Iterator edgeIterator = SemanticView.getSourceEdges().iterator();
            Edge appliedStereotypeLink = null;
            while (appliedStereotypeLink == null && edgeIterator.hasNext()) {
                Edge edge = (Edge)edgeIterator.next();
                if (!edge.getType().equals("StereotypeCommentLink")) continue;
                appliedStereotypeLink = edge;
            }
            if (appliedStereotypeLink == null) {
                return null;
            }
            node = (Node)appliedStereotypeLink.getTarget();
        }
        return node;
    }

    public boolean isStereotypeLabel(Object element) {
        boolean stereotypeLabel = Boolean.FALSE;
        if (element instanceof DecorationNode) {
            stereotypeLabel = "StereotypeLabel".equals(((DecorationNode)element).getType());
        }
        return stereotypeLabel;
    }

    public boolean isStereotypeCompartment(Object element) {
        boolean stereotypeCompartment = Boolean.FALSE;
        if (element instanceof BasicCompartment) {
            stereotypeCompartment = "StereotypeCompartment".equals(((DecorationNode)element).getType());
        }
        return stereotypeCompartment;
    }

    public boolean isStereotypeProperty(Object element) {
        boolean stereotypeProperty = Boolean.FALSE;
        if (element instanceof DecorationNode) {
            stereotypeProperty = "StereotypeProperty".equals(((DecorationNode)element).getType());
        }
        return stereotypeProperty;
    }

    public boolean isStereotypeBrace(Object element) {
        boolean stereotypeBraceCmpt = Boolean.FALSE;
        if (element instanceof BasicCompartment) {
            stereotypeBraceCmpt = "StereotypeBrace".equals(((BasicCompartment)element).getType());
        }
        return stereotypeBraceCmpt;
    }

    public boolean isStereotypeBraceProperty(Object element) {
        boolean stereotypeProperty = Boolean.FALSE;
        if (element instanceof DecorationNode) {
            stereotypeProperty = "StereotypePropertyBrace".equals(((DecorationNode)element).getType());
        }
        return stereotypeProperty;
    }

    public boolean isStereotypeComment(Object element) {
        boolean stereotypeComment = Boolean.FALSE;
        if (element instanceof Shape) {
            stereotypeComment = "StereotypeComment".equals(((Shape)element).getType());
        }
        return stereotypeComment;
    }

    public String getName(DecorationNode label) {
        String name = EMPTY_STRING;
        String defaultName = EMPTY_STRING;
        if (label != null && label.getElement() instanceof Stereotype) {
            defaultName = ((Stereotype)label.getElement()).getQualifiedName();
        }
        if (this.isStereotypeLabel(label)) {
            name = NotationUtils.getStringValue((View)label, (String)"stereotype", (String)defaultName);
        }
        return name;
    }

    public String getName(BasicCompartment compartment) {
        String name = EMPTY_STRING;
        String defaultName = EMPTY_STRING;
        if (compartment != null && compartment.getElement() instanceof Stereotype) {
            defaultName = ((Stereotype)compartment.getElement()).getQualifiedName();
        }
        if (this.isStereotypeCompartment(compartment) || this.isStereotypeBrace(compartment)) {
            name = NotationUtils.getStringValue((View)compartment, (String)"stereotype", (String)defaultName);
        }
        return name;
    }

    public String getDepth(DecorationNode label) {
        String depth = EMPTY_STRING;
        if (label != null && "StereotypeLabel".equals(label.getType())) {
            depth = NotationUtils.getStringValue((View)label, (String)"depth", (String)"full");
        }
        return depth;
    }

    public boolean isLabelExist(View node, Stereotype stereotype) {
        boolean exist = false;
        Iterator iter = node.getChildren().iterator();
        while (!exist && iter.hasNext()) {
            DecorationNode stereo;
            Object obj = iter.next();
            if (!(obj instanceof DecorationNode) || !"StereotypeLabel".equals((stereo = (DecorationNode)obj).getType())) continue;
            exist = stereo.getElement().equals(stereotype);
        }
        return exist;
    }

    public boolean isCompartmentExist(View node, Stereotype stereotype) {
        boolean exist = false;
        Iterator iter = node.getChildren().iterator();
        while (!exist && iter.hasNext()) {
            BasicCompartment compartment;
            Object obj = iter.next();
            if (!(obj instanceof BasicCompartment) || !this.isStereotypeCompartment(compartment = (BasicCompartment)obj)) continue;
            exist = compartment.getElement().equals(stereotype);
        }
        return exist;
    }

    public boolean isPropertyExist(View compartment, Property propertyUML) {
        boolean exist = false;
        Iterator iter = compartment.getChildren().iterator();
        while (!exist && iter.hasNext()) {
            DecorationNode property;
            Object obj = iter.next();
            if (!(obj instanceof DecorationNode) || !this.isStereotypeProperty(property = (DecorationNode)obj)) continue;
            exist = property.getElement().equals(propertyUML);
        }
        return exist;
    }

    public String getStereotypePropertyToDisplay(View view, Property property) {
        DecorationNode node;
        String propertyAndValue = EMPTY_STRING;
        if (view instanceof DecorationNode && (this.isStereotypeProperty(node = (DecorationNode)view) || this.isStereotypeBraceProperty(node))) {
            Stereotype stereotype = (Stereotype)((Property)node.getElement()).getClass_();
            Element umlElement = UMLUtil.getBaseElement((EObject)this.getStereotypeApplication(view, stereotype));
            if (this.isDisplayed((Node)node) && stereotype != null && property != null && umlElement != null) {
                propertyAndValue = StereotypeUtil.displayPropertyValue((Stereotype)stereotype, (Property)property, (Element)umlElement, (String)" ");
            }
        }
        return propertyAndValue;
    }

    public boolean isDisplayed(Node node) {
        boolean visibility = true;
        visibility = node.isVisible() && ((Node)node.eContainer()).isVisible();
        return visibility;
    }

    public boolean isInStereotypeComment(Node node) {
        boolean isComment = false;
        View container = this.getTopContainer((View)node);
        isComment = this.isStereotypeComment(container);
        return isComment;
    }

    protected String addStereotypeCompartmentProperties(String textToDisplay, BasicCompartment compartment) {
        StringBuilder newTextToDisplay = new StringBuilder(textToDisplay);
        StringBuilder propertiesText = new StringBuilder(EMPTY_STRING);
        EList properties = compartment.getChildren();
        for (Object property : properties) {
            if (!this.isStereotypeBraceProperty(property)) continue;
            DecorationNode propertyNode = (DecorationNode)property;
            Property propertyElement = (Property)propertyNode.getElement();
            if (!this.isDisplayed((Node)propertyNode)) continue;
            String propAndValueText = this.getStereotypePropertyToDisplay((View)propertyNode, propertyElement);
            propertiesText = this.addTextWithSeparator(propertiesText, propAndValueText, ", ");
        }
        newTextToDisplay = this.addTextWithSeparator(newTextToDisplay, propertiesText.toString(), ", ");
        String finalText = newTextToDisplay.toString();
        return finalText;
    }

    protected StringBuilder addTextWithSeparator(StringBuilder initialText, String textToAdd, String separator) {
        StringBuilder result = new StringBuilder(initialText);
        if (!EMPTY_STRING.equals(textToAdd) && textToAdd != null) {
            if (result != null && !result.toString().equals(EMPTY_STRING)) {
                result.append(separator);
            }
            result.append(textToAdd);
        }
        return result;
    }

    protected boolean hasBraceLabel(Node comment) {
        boolean hasBrace = false;
        String braceTextInComment = this.getStereotypePropertiesInBrace((View)comment);
        if (braceTextInComment != null) {
            hasBrace = !braceTextInComment.isEmpty();
        }
        return hasBrace;
    }

    public boolean hasStereotypeCompartment(View view) {
        Iterator iter = view.getChildren().iterator();
        boolean compartmentExist = false;
        while (iter.hasNext() && !compartmentExist) {
            Object obj = iter.next();
            compartmentExist = this.isStereotypeCompartment(obj);
        }
        return compartmentExist;
    }

    public boolean hasStereotypeViews(View view) {
        Iterator iter = view.getChildren().iterator();
        boolean compartmentExist = false;
        while (iter.hasNext() && !compartmentExist) {
            Object obj = iter.next();
            boolean bl = compartmentExist = this.isStereotypeCompartment(obj) || this.isStereotypeBrace(obj) || this.isStereotypeLabel(obj);
        }
        return compartmentExist;
    }

    public boolean isCommentEmpty(Node comment) {
        boolean empty = false;
        empty = !this.hasStereotypeCompartment((View)comment) && !this.hasBraceLabel(comment);
        return empty;
    }

    public boolean isEmpty(Node compartment) {
        boolean empty = true;
        if (compartment != null) {
            Iterator childrenIterator = compartment.getChildren().iterator();
            while (empty && childrenIterator.hasNext()) {
                Object property = childrenIterator.next();
                if (!this.isStereotypeProperty(property) && !this.isStereotypeBraceProperty(property) || !this.isDisplayed((Node)property)) continue;
                empty &= false;
            }
        }
        return empty;
    }

    public boolean isAppliedStereotype(Stereotype stereotype, Element hostSemanticElement) {
        return hostSemanticElement.isStereotypeApplied(stereotype);
    }

    public boolean isStereotypeView(Object element) {
        boolean stereotypeView = this.isStereotypeCompartment(element) || this.isStereotypeBrace(element) || this.isStereotypeLabel(element) || this.isStereotypeBraceProperty(element) || this.isStereotypeProperty(element);
        return stereotypeView;
    }

    public boolean isBraceCompartmentExist(View node, Stereotype stereotype) {
        boolean exist = false;
        Iterator iter = node.getChildren().iterator();
        while (!exist && iter.hasNext()) {
            BasicCompartment compartment;
            Object obj = iter.next();
            if (!(obj instanceof BasicCompartment) || !this.isStereotypeBrace(compartment = (BasicCompartment)obj)) continue;
            exist = compartment.getElement().equals(stereotype);
        }
        return exist;
    }

    public boolean isBracePropertyExist(Node compartment, Property propertyUML) {
        boolean exist = false;
        Iterator iter = compartment.getChildren().iterator();
        while (!exist && iter.hasNext()) {
            DecorationNode property;
            Object obj = iter.next();
            if (!(obj instanceof DecorationNode) || !this.isStereotypeBraceProperty(property = (DecorationNode)obj)) continue;
            exist = property.getElement().equals(propertyUML);
        }
        return exist;
    }

    public BasicCompartment getStereotypeBraceCompartment(View node, Stereotype stereotype) {
        if (stereotype != null && node != null) {
            for (Object obj : node.getChildren()) {
                BasicCompartment compartment;
                if (!this.isStereotypeBrace(obj) || (compartment = (BasicCompartment)obj).getElement() == null || !compartment.getElement().equals(stereotype)) continue;
                return compartment;
            }
        }
        return null;
    }

    public boolean hasVisibleProperties(View stereotypeCompartment) {
        boolean visibleProperties = false;
        if (stereotypeCompartment != null) {
            Iterator iter = stereotypeCompartment.getChildren().iterator();
            while (iter.hasNext() && !visibleProperties) {
                Object child = iter.next();
                if (!this.isStereotypeProperty(child)) continue;
                visibleProperties |= ((DecorationNode)child).isVisible();
            }
        }
        return visibleProperties;
    }

    public void unsetPersistency(final TransactionalEditingDomain domain, final View view) {
        try {
            domain.runExclusive(new Runnable(){

                @Override
                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            UnsetPersistentViewCommand command = new UnsetPersistentViewCommand(domain, view);
                            try {
                                GMFUnsafe.write((TransactionalEditingDomain)domain, (Command)command);
                            }
                            catch (Exception e) {
                                Activator.log.error((Throwable)e);
                            }
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    public boolean isStereotypeCommentLink(Object element) {
        boolean stereotypeCommentLink = Boolean.FALSE;
        if (element instanceof Edge) {
            stereotypeCommentLink = "StereotypeCommentLink".equals(((Edge)element).getType());
        }
        return stereotypeCommentLink;
    }

    public Element getSemanticElement(View view) {
        if (this.isStereotypeComment(view)) {
            return this.getCommentSemanticElement(view);
        }
        if (view.getElement() instanceof Element) {
            return (Element)view.getElement();
        }
        return null;
    }

    public String getStereotypeTextForFloatingLabel(View view) {
        StringBuilder text = new StringBuilder();
        String label = this.getStereotypeTextToDisplay(view);
        String brace = this.getStereotypePropertiesInBrace(view);
        if (label != null && !label.isEmpty()) {
            text.append(label);
        }
        if (brace != null && !brace.isEmpty()) {
            text.append("\n").append("{" + brace + "}");
        }
        return text.toString();
    }

    public boolean hasVisibleCompartment(View comment) {
        boolean empty = true;
        if (this.isStereotypeComment(comment)) {
            Iterator childrenIterator = comment.getChildren().iterator();
            while (empty && childrenIterator.hasNext()) {
                Object child = childrenIterator.next();
                if (!this.isStereotypeCompartment(child)) continue;
                boolean bl = empty = !((View)child).isVisible();
            }
        }
        return !empty;
    }
}

